package com.aote.rs;

import java.util.*;

import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

import com.aote.transaction.SessionPool;
import com.aote.workflow.perform.*;
import kafka.utils.Json;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import org.w3c.dom.Element;
import scala.Int;

/**
 * 动态运行部分的主服务类
 */
@Path("workflow")
@Singleton
@Component
@Transactional
public class Server {
	@Autowired
	private SessionPool sessionPool;

	public Session assignedSession;

	public void setAssignedSession(Session session) {
		this.assignedSession = session;
	}

	/**
	 * 启动流程
	 * @param name 流程名
	 * @return 流程id
	 */
	@GET
	@Path("startprocess/{name}")
	public String txstartProcess(@PathParam("name") String name) {
		try {
			// 得到流程定义
			ProcessDef process = ProcessDefManager.getInstance().getProcessDef(
					name);
			if (process == null) {
				throw new RuntimeException("流程不存在：名字=" + name);
			}
			Session session = assignedSession == null ? sessionPool.getSession() : assignedSession;
			// 产生流程实例
			String processId = UUID.randomUUID().toString();
			ProcessInstance procIns = process.createInstance(session, processId);
			return procIns.getId();
		} catch (Error e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	/**
	 * 开始一个活动
	 * @param processid 流程实例id
	 * @param name 要开始的活动名称
	 * @return 开始的活动的id
	 */
	@GET
	@Path("startactivity/{processid}/{name}")
	public String txstartActivity(
			@PathParam("processid") String processid, @PathParam("name") String name) {
		try {
			Session session = assignedSession == null ? sessionPool.getSession() : assignedSession;
			ProcessInstance procIns = (ProcessInstance) session.get(ProcessInstance.class, processid);
			ProcessDef process = procIns.getDefine();
			// 获取活动定义
			ActivityDef activity = process.getActivityByName(name);
			ActivityInstance actIns = new ActivityInstance(activity, procIns, "", null, null, null);
		 	session.save(actIns);
		 	return actIns.getId() + "";
		} catch (Error e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	/**
	 * 给流程设置变量值
	 * @param processid
	 * @param vars
	 * @return
	 */
	@POST
	@Path("setvars/{processid}/{username}/{userid}")
	public String txsetVars(
			@PathParam("processid") String processid, 
			String vars,
			@PathParam("username") String username, 
			@PathParam("userid") String userid
			) {
		ttxsetVars(processid,vars,username,userid);
		return "ok";
	}
	
	/**
	 * 给流程设置变量值
	 * @param processid
	 * @param vars
	 * @return
	 */
	public JSONObject ttxsetVars(
			String processid,
			String vars,
			String username,
			String userid
			){
		try {
			//创建要返回的JSON对象
			JSONObject jsob =new JSONObject();
			JSONObject json = new JSONObject(vars);
			Session session = assignedSession == null ? sessionPool.getSession() : assignedSession;
			ProcessInstance procIns = (ProcessInstance) session.get(ProcessInstance.class, processid);
			procIns.putVar(json);
			// 获取流程所有待办活动
			for(Object obj : procIns.getActivitiesByState("开始活动")) {
				ActivityInstance actIns = (ActivityInstance)obj;
				// 让每个活动尝试结束
				jsob = actIns.finish(session, username, userid);
			};
			return jsob;
		} catch (Error e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}	
	}
	
	/**
	 * 获取流程中所有待办事项
	 * @param processid 流程编号
	 * @return JSON格式待办事项
	 */
	@GET
	@Path("getwait/{processid}")
	public String txgetWait(@PathParam("processid") String processid) {
		JSONArray result = new JSONArray();
		
		Session session = assignedSession == null ? sessionPool.getSession() : assignedSession;
		ProcessInstance procIns = (ProcessInstance) session.get(ProcessInstance.class, processid);
		
		// 获得所有待办
		for(Object obj : procIns.getActivitiesByState("开始活动")) {
			// 把每一个待办转换成JSON对象
			JSONObject json = new JSONObject();
			ActivityInstance actIns = (ActivityInstance)obj;
			json.put("defid", actIns.getDefid());
			json.put("defname", actIns.getDefname());
			result.put(json);
		}
		
		return result.toString();
	}

	/**
	 * 获取流程工作流程图
	 * @param processid 流程编号
	 * @return JSON格式待办事项
	 */
	@GET
	@Path("getWFGraph/{processid}")
	public String txgetWFGraph(@PathParam("processid") String processid) {
		//定义点集
		JSONObject res=new JSONObject();
		JSONArray spotlist = new JSONArray();
		Session session = assignedSession == null ? sessionPool.getSession() : assignedSession;
		ProcessInstance procIns = (ProcessInstance) session.get(ProcessInstance.class, processid);
		// 获得所有待办
		for(Object obj : procIns.getAllActivities()) {
			// 把每一个待办转换成JSON对象
			ActivityInstance actIns = (ActivityInstance)obj;
			spotlist.put(actIns.getJson());
		}
		//获取点和线
		res.put("spots",this.getSpots(procIns));
		res.put("lines",this.getLines(procIns));
		return res.toString();
	}

	/**
	 * 获取点
	 * @param procIns
	 * @return
	 */
	public JSONArray getSpots(ProcessInstance procIns){
		HashMap<String, JSONObject> spotmap = new HashMap<String, JSONObject>();
		JSONArray Spots = new JSONArray();
		//获取流程定义
		ProcessDef pdef=procIns.getDefine();
		// 获得所有办过的数据
		for(Object obj : procIns.getAllActivities()) {
			// 把每一个待办转换成JSON对象
			ActivityInstance actIns = (ActivityInstance)obj;
			JSONObject json = actIns.getJson();
			if(!spotmap.containsKey(json.getString("defid"))){
				spotmap.put(json.getString("defid"),json);
			}
		}
		//处理为进行的数据
		for(Object obj : pdef.getActivities()) {
			//初始化json
			JSONObject json = new JSONObject();
			ActivityDef act = (ActivityDef)obj;
			json.put("defid", act.getID());
			json.put("defname", act.getName());
			json.put("state", "未执行");
			if(!spotmap.containsKey(json.getString("defid"))){
				spotmap.put(json.getString("defid"),json);
			}
		}
		// 获取值集合的迭代器
		Iterator it = spotmap.values().iterator();
		while (it.hasNext()) {
			Spots.put((JSONObject)it.next());
		}
		return  Spots;
	}

	/**
	 * 获取线
	 * @param procIns
	 * @return
	 */
	public JSONArray getLines(ProcessInstance procIns){
		JSONArray Lines = new JSONArray();
		//获取流程定义
		ProcessDef pdef=procIns.getDefine();
		for(Object obj : pdef.getDiversions()) {
			// 把每一个待办转换成JSON对象
			DiversionDef diversion = (DiversionDef)obj;
			JSONObject json = new JSONObject();
			json.put("start", diversion.getHead().getID());
			json.put("end", diversion.getTail().getID());
			Lines.put(json);
		}
		return  Lines;
	}
	/**
	 * 启动流程
	 * 
	 * @param name
	 *            流程名称
	 * @return 启动流程后的HTML片断
	 */
	@POST
	@Path("startprocess/{name}/{username}/{userid}")
	public String txstartProcess(@PathParam("name") String name,
			@PathParam("username") String username,
			@PathParam("userid") String userid,
			String personExpression) {
		try {
			//解析传递过来的对象属性
			JSONArray array = new JSONArray(personExpression);
			JSONObject firstObj = array.getJSONObject(0);
			final String data = firstObj.getString("data");
			JSONObject dataObj = new JSONObject(data);
			String processId = dataObj.getString("id");
		
			Session session = assignedSession == null ? sessionPool.getSession() : assignedSession;
			// 得到流程定义
			ProcessDef process = ProcessDefManager.getInstance().getProcessDef(
					name);
			if (process == null) {
				throw new RuntimeException("流程不存在：名字=" + name);
			}
			ActivityDef activity = process.getStartActivity();
			if (activity == null) {
				throw new RuntimeException("流程没有开始活动：名字=" + name);
			}
			// 产生流程实例
			ProcessInstance procIns = process.createInstance(session,processId);
		
			// 产生活动实例,前一个活动实例为空
			ActivityInstance actIns = new ActivityInstance(activity, procIns,
					"", username, userid, null);
		 	session.save(actIns);
			actIns.finish(session, personExpression, username, userid);
			JSONObject okObject = new JSONObject();
			okObject.put("ok","ok");
			return okObject.toString();
		} catch (Error e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	/**
	 * 启动流程
	 * 
	 * @param name
	 *            流程名称
	 * @param person
	 *            流程启动者
	 * @return 启动流程后的HTML片断
	 */
	@POST
	@Path("startWork/{name}/{username}/{userid}")
	public String txstartWork(@PathParam("name") String name,
			@PathParam("username") String username,
			@PathParam("userid") String userid,
			String personExpression) {
		try {
			//解析传递过来的对象属性
			JSONObject dataObj = new JSONObject(personExpression);
			String processId = dataObj.getString("id");
		
			Session session = assignedSession == null ? sessionPool.getSession() : assignedSession;
			// 得到流程定义
			ProcessDef process = ProcessDefManager.getInstance().getProcessDef(
					name);
			if (process == null) {
				throw new RuntimeException("流程不存在：名字=" + name);
			}
			ActivityDef activity = process.getStartActivity();
			if (activity == null) {
				throw new RuntimeException("流程没有开始活动：名字=" + name);
			}
			// 产生流程实例
			ProcessInstance procIns = process.createInstance(session,processId);
		
			// 产生活动实例,前一个活动实例为空
			ActivityInstance actIns = new ActivityInstance(activity, procIns,
					"", username, userid, null);
		 	session.save(actIns);
			JSONObject result = new JSONObject();
			result.put("procIns",procIns.getId());
			result.put("actIns", actIns.getId());
			result.put("actName", actIns.getName());
			return result.toString();
		} catch (Error e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 执行活动
	 * 
	 * @param request
	 *            HTTP请求，包含活动ID号
	 * @return 提示页面片断
	 */
	@POST
	@Path("perfomactivity/{acitityid}/{username}/{userid}")
	public String txperformActivity(@PathParam("acitityid") String acitityid,
			@PathParam("username") String username,
			@PathParam("userid") String userid,
			String personExpression) {
		try {
			Session session = assignedSession == null ? sessionPool.getSession() : assignedSession;
			ActivityInstance actIns = (ActivityInstance) session.load(
					ActivityInstance.class, acitityid);
			actIns.finish(session, personExpression, username, userid);
			//判断活动已结束，不执行,防止重复
			if(actIns.getState().equals("结束"))
			{
			    JSONObject error = new JSONObject();
			    error.put("error", "已结束");
			      return error.toString();
			}
			JSONObject okObject = new JSONObject();
			okObject.put("ok","ok");
			return okObject.toString();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 获取给定活动的action内容
	 * @param activityId
	 * @return
	 */
	@GET
	@Path("action/{acitityid}")
	public String txgetAction(@PathParam("acitityid") String acitityid) {
		Session session = assignedSession == null ? sessionPool.getSession() : assignedSession;
		ActivityInstance actIns = (ActivityInstance) session.load(ActivityInstance.class, Integer.parseInt(acitityid));
		Element e = actIns.getDefine().getElement();
		if (e.hasAttribute("action")) {
			return e.getAttribute("action");
		} else {
			return "";
		}
	}

	/**
	 * 终止流程
	 * 
	 * @param request
	 *            HTTP请求，包含活动ID号
	 * @return 提示页面片断
	 */
	@POST
	@Path("stop/{acitityid}")
	public String txStopProcess(@PathParam("acitityid") String acitityid) {
		try {
			Session session = assignedSession == null ? sessionPool.getSession() : assignedSession;
			ActivityInstance actIns = (ActivityInstance) session.load(
					ActivityInstance.class, acitityid);
		    ProcessInstance pi = actIns.getProcess();
		    List list = pi.getActivitiesByState("开始活动");
			Iterator iter = list.iterator();
			while (iter.hasNext()) {
				ActivityInstance act = (ActivityInstance) iter.next();
				act.setState("终止ֹ");
				session.update(act);
	 		}
            pi.stop();
            session.update(pi);
		 	JSONObject result = new JSONObject();
		 	result.put("procIns", pi == null ? null : pi.getName());
		 	result.put("actIns",actIns == null ? null : actIns.getName());
			return result.toString();
		}  catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}