select
    cp.f_user_name,
    cp.f_userinfo_code,
    f_userinfoid f_userinfo_id,
    CASE WHEN LEN(isnull(cp.f_address,'')) > 20 THEN
        LEFT(cp.f_address, 13) + '*' + RIGHT(cp.f_address, 6)
    ELSE
    isnull(cp.f_address,'')
END AS f_address,
    cp.id f_third_id,
    '' f_userfiles_id,
    CONVERT(varchar,f_upload_date,120) f_upload_date
from t_check_paper cp
    left join t_banduser bu on cp.f_userinfoid = bu.f_userinfo_id
    left join t_userinfo ui on cp.f_userinfoid = ui.f_userinfo_id
where f_band_state = '有效'
  and ui.f_user_state = '正常'
  and bu.f_open_id is not null
  and f_defect_content like '%有隐患%'
  and f_repaired = '未修'
  and f_upload_date > DATEADD(day,-1,GETDATE())
  and cp.id not in(
    select f_third_id from t_template_push where f_send_type = '燃气隐患整改推送' group by f_third_id
)
