SELECT
    f_open_id,
    f_address,
    f_user_name,
    f_userinfo_id,
    f_userfiles_id,
    f_userinfo_code,
    '您的燃气表电量低，请及时更换电池' f_table_state
FROM
    (
        SELECT
            ua.f_address,
            f_user_state,
            ui.f_user_name,
            b.f_open_id,
            ui.f_userinfo_code,
            ui.f_userinfo_id,
			m.f_user_id  f_userfiles_id
        FROM
            (
			select f_userinfo_id,f_user_id from t_exception
			where (f_error_type like '%低电%' or f_error_type='电压低')
			and f_alias not in ('CangNanSyncSystem ','TianXinSyncTCP')
			and f_insert_date > GETDATE() -1
			group by f_userinfo_id,f_user_id
			) m
                LEFT JOIN t_userinfo ui on ui.f_userinfo_id = m.f_userinfo_id
                LEFT JOIN t_user_address ua ON ua.f_userinfo_id = ui.f_userinfo_id
                LEFT JOIN 
				(select f_userinfo_id,f_open_id from t_banduser 
				where f_band_state = '有效' group by f_userinfo_id,f_open_id)
				b ON ui.f_userinfo_id = b.f_userinfo_id
        where f_user_state = '正常'
    ) c
where f_open_id is not null
  and not exists (
    select
        1
    from
        (
            select
                *
            from
                t_template_push
            where
                    f_send_state = '推送成功'
              and f_send_type = '低电提醒'
              and f_send_date >= DATEADD(dd, DATEDIFF(dd, 0, getdate()), 0) -3
        ) push
    where
            c.f_open_id = push.f_open_id
      and c.f_userinfo_id = push.f_userinfo_id
      and c.f_userfiles_id = push.f_userfiles_id
)