select info.*,
       '' f_third_id,
       cast(f_balance_old as varchar) f_balance,
       b.f_open_id,
       '' f_userfiles_id,
       CONVERT(varchar,GETDATE(),120) f_getdate
from (
         select * from t_banduser where f_band_state = '有效'
     ) b
         join
     (
         select u.f_user_name,
                u.f_userinfo_code,
                u.f_userinfo_id,
                convert(decimal(18,2), f.f_balance_amount) f_balance_old,
                f.f_meter_classify,
                f.f_user_type,
                isnull(u.f_reminder_amount, case when f_user_type='民用' then {remindMoney} else {nonCivilRemindMoney} end) f_reminder_amount,
                CASE WHEN LEN(isnull(a.f_address,'')) > 20 THEN
                 LEFT(a.f_address, 13) + '*' + RIGHT(a.f_address, 6)
             ELSE
             isnull(a.f_address,'')
             END AS f_address
         from t_userinfo u left join t_userfiles f on u.f_userinfo_id = f.f_userinfo_id
             left join t_user_address a on u.f_userinfo_id = a.f_userinfo_id
         where f_user_state = '正常' and f_table_state = '正常' and u.f_orgid = '{orgId}' and f.f_meter_classify = '物联网表'
     ) info on b.f_userinfo_id = info.f_userinfo_id
where not exists (
    select 1 from (
                      select * from t_template_push
                      where f_send_state='推送成功' and f_send_type='余额提醒' and f_send_date>=DATEADD(dd,DATEDIFF(dd,0,getdate()),0)-3) push
    where b.f_open_id=push.f_open_id and b.f_userinfo_id=push.f_userinfo_id
) and f_balance_old < f_reminder_amount
