SELECT * FROM (
  SELECT
    b.f_open_id,
    -- 物联网取f_balance_amount,机表取f_balance,保留两位然后转字符串
    cast(convert(decimal(18,2), CASE WHEN uf.f_meter_classify = '物联网表' THEN uf.f_balance_amount ELSE ui.f_balance END) as float) f_balance,
    ui.f_userinfo_id,
    uf.f_userfiles_id,
    ui.f_user_name,
    ui.f_userinfo_code,
    CONVERT(varchar,GETDATE(),120) f_time,
    ui.f_orgid,
    '' f_third_id
  FROM
    t_banduser b
    LEFT JOIN t_userinfo ui on ui.f_userinfo_id = b.f_userinfo_id
    LEFT JOIN t_userfiles uf ON ui.f_userinfo_id = uf.f_userinfo_id
  where uf.f_meter_classify IN ('机表', '物联网表') and uf.f_table_state = '正常'
) c where {condition}
