package com.aote.rs.wechatpay;

import com.aote.entity.RefundReturnDate;
import com.aote.entity.RefundSendData;
import com.aote.sql.SqlServer;
import com.aote.util.WechatUrl;
import com.aote.util.WxSign;
import com.aote.util.XmlUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.SortedMap;
import java.util.TreeMap;

@Component
public class WxRefund {
	static Logger log = Logger.getLogger(WxRefund.class);

	@Autowired
	private SqlServer sqlServer;
	/**
	 *
	 * @param appId
	 * @param mchId
	 * @param key
	 * @param money
	 * @param transaction_id
	 * @param path
	 * @return
	 */
	public JSONObject SendRefundreq(String appId, String mchId, String key, String money,
									String transaction_id,
									String path,
									String ip,
									String port) {
		JSONObject result = new JSONObject();
		try {
			RefundSendData sendData = getPaySendEntity(appId, mchId, money, transaction_id);
			//发送退款请求
			String returnXml = unifiedOrder(key, mchId, sendData,path);
			log.debug("退款请求xml格式数据:" + returnXml);
			//将拿到的返回数据转成
			RefundReturnDate reData = (RefundReturnDate) XmlUtils.formatXml(returnXml, RefundReturnDate.class);
			// 判断返回数据
			String return_code = reData.getReturn_code();
			if (return_code.equals("SUCCESS")) {
				if (reData.getResult_code().equals("SUCCESS")) {
					result.put("f_return_code", reData.getResult_code());
					result.put("f_return_msg", reData.getReturn_msg());
					result.put("f_result_code", reData.getResult_code());
					result.put("f_err_code", reData.getErr_code());
					result.put("f_err_code_des", reData.getErr_code_des());
					result.put("f_appid", reData.getAppid());
					result.put("f_mch_id", reData.getMch_id());
					result.put("f_nonce_str", reData.getNonce_str());
					result.put("f_sign", reData.getSign());
					result.put("f_transaction_id", reData.getTransaction_id());
					result.put("f_out_trade_no", reData.getOut_trade_no());
					result.put("f_out_refund_no", reData.getOut_refund_no());
					result.put("f_refund_id", reData.getRefund_id());
					result.put("f_refund_fee", reData.getRefund_fee());
					result.put("f_settlement_refund_fee",reData.getSettlement_refund_fee() );
					result.put("f_total_fee", reData.getTotal_fee());
					result.put("f_fee_type", reData.getFee_type());
					result.put("f_cash_fee", reData.getCash_fee());
					result.put("f_cash_fee_type", reData.getCash_fee_type());
					result.put("f_settlement_total_fee", reData.getSettlement_total_fee());
					result.put("f_cash_refund_fee", reData.getCash_refund_fee());
					result.put("f_coupon_refund_fee", reData.getCoupon_refund_fee());
					result.put("f_coupon_refund_count", reData.getCoupon_refund_count());
					result.put("code", 200);
					log.debug("退款接口申请成功:"+result);
					this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state = '已退款',state = '已退款'  where f_transaction_id = '" + transaction_id + "'");
//					HttpUtils.doPost("http://" + ip + port, "saverefundxml", "{\"data\":" + result.toString() + "}");
					return result;
				} else {
					result.put(
							"error",
							"返回错误：" + reData.getErr_code()
									+ reData.getErr_code_des());
					result.put("f_result_code", "success");
					result.put("code", 500);
				}
			} else {
				result.put("error", "系统错误：" + reData.getReturn_msg());
				result.put("code",500);
			}
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
		log.debug("result=" + result);
		return result;
	}

	/**
	 *
	 * @param appId
	 * @param mchId
	 * @param money
	 * @param tran
	 * @return
	 */
	private RefundSendData getPaySendEntity(String appId, String mchId, String money,
											String tran) {
		log.debug("weixin-start-getprepayid"
				+ ",money=" + money );
		RefundSendData result = new RefundSendData();
		result.setAppid(appId);// appid
		result.setMch_id(mchId); //商户id
		result.setNonce_str(WxSign.getNonceStr());
		result.setTransaction_id(tran);
		result.setOut_refund_no(WxSign.getNonceStr());
		result.setTotal_fee(Integer.parseInt(money));//result.setTotal_fee((int) (Double.parseDouble(money) * 100));// 单位：分 支付金额
		result.setRefund_fee(Integer.parseInt(money));
		return result;
	}

	/**
	 *
	 * @param key api秘钥
	 * @param mchId 商户id
	 * @param data 退款数据
	 * @param path
	 * @return
	 */
	public static String unifiedOrder(String key,String mchId, RefundSendData data,String path) {
		// 退款请求
		String returnXml = "";
		try {
			// 生成sign签名
			SortedMap<Object, Object> parameters = new TreeMap<Object, Object>();
			parameters.put("appid", data.getAppid());
			parameters.put("mch_id", data.getMch_id());
			parameters.put("nonce_str", data.getNonce_str());
			parameters.put("transaction_id", data.getTransaction_id());
			parameters.put("out_refund_no", data.getOut_refund_no());
			parameters.put("total_fee",  data.getTotal_fee());
			parameters.put("refund_fee",  data.getRefund_fee());
			data.setSign(WxSign.createSign(parameters, key));
			/*----4.读取证书文件,这一段是直接从微信支付平台提供的demo中copy的，所以一般不需要修改---- */
			KeyStore keyStore  = KeyStore.getInstance("PKCS12");
			char[] password = mchId.toCharArray();
			log.debug(password);
			// 读取证书文件
			FileInputStream instream = new FileInputStream(new File(path));
			log.debug(instream);
			try {
				keyStore.load(instream, password);
			} finally {
				instream.close();
			}
			// 实例化密钥库 & 初始化密钥工厂
			KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
			kmf.init(keyStore, password);

			// 创建 SSLContext
			SSLContext sslContext = SSLContext.getInstance("TLS");
			sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());

			SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(
					sslContext,
					new String[]{"TLSv1"},
					null,
					new DefaultHostnameVerifier());

			BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager(
					RegistryBuilder.<ConnectionSocketFactory>create()
							.register("http", PlainConnectionSocketFactory.getSocketFactory())
							.register("https", sslConnectionSocketFactory)
							.build(),
					null,
					null,
					null
			);

			HttpClient httpClient = HttpClientBuilder.create().setConnectionManager(connManager).build();
			XStream xs = new XStream(new DomDriver("UTF-8",
					new XmlFriendlyNameCoder("-_", "_")));
			xs.alias("xml", RefundSendData.class);
			String xml = xs.toXML(data);
			log.debug(xml);
			HttpPost postRequest = new HttpPost(WechatUrl.REFUND_API);
			StringEntity postEntity = new StringEntity(xml, "UTF-8");
			postRequest.addHeader("Content-Type", "text/xml");
			postRequest.setEntity(postEntity);
			HttpResponse httpResponse = httpClient.execute(postRequest);
			HttpEntity entity = httpResponse.getEntity();
			if (entity != null) {
				returnXml = EntityUtils.toString(entity, "UTF-8");
			}
			log.debug("退款拿到的数据" + returnXml);

		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return returnXml;
	}

}
