/**查询用户气表信息**/
SELECT * FROM (
                  SELECT
                      case WHEN uf.f_open_date is null THEN '未开户' ELSE '已开户' END f_open_date,
                      uf.f_userfiles_id,
                      uf.f_gasbrand_id,
                      uf.f_user_type,
                      uf.f_user_id,
                      uf.f_userinfo_id,
                      uf.f_meternumber,
                      f_meter_classify,
                      f_balance_amount,
                      f_balance_gas,
                      f_meter_base,
                      f_card_id,
                      uf.f_times,
                      f_whether_hairpin,
                      f_collection_type, -- 缴费方式
                      f_total_gas, -- 表累购气量
                      uf.f_card_password, -- 卡密码
                      gb.f_alias,  --别名
                      gb.f_police_gas, -- 报警气量
                      gb.f_topup_ceil, --充值上限
                      gb.f_overdr_lines, -- 透支额度
                      gb.f_meter_brand, -- 表品牌
                      gb.f_calculation, --表端计费/系统计费
                      up.f_state,
                      f_table_state,
                      m.f_jval,
                      m.id
                  FROM
                      t_userfiles uf
                      LEFT JOIN t_gasbrand gb on uf.f_gasbrand_id = gb.id
                     LEFT JOIN t_userproperties up on uf.f_userinfo_id = up.f_userinfo_id
                     LEFT JOIN t_meteread m on m.id = uf.f_meteread_maxid
              ) t
WHERE
    {condition} AND f_table_state = '正常'
ORDER BY
    id desc
