SELECT
    *
FROM
    (
        SELECT
            b.id,
            u.f_userinfo_id,
            u.f_user_state,
            u.f_user_phone,
            u.f_comments,
            u.f_idnumber,
            u.f_balance,
            b.f_open_id,
            b.f_band_state,
            u.f_user_name,
            u.f_address,
            u.f_filiale,
            u.f_outlets,
            u.f_operator,
            u.f_createfile_date,
            g.f_meter_brand,
            g.f_meter_type,
            u.f_slice_area AS f_zones,
            u.f_residential_area,
            u.f_building,
            u.f_unit,
            u.f_floor,
            u.f_room,
            b.f_band_time
        FROM t_banduser b
                 LEFT JOIN t_userinfo u ON u.f_userinfo_id = b.f_userinfo_id
                 LEFT JOIN t_userfiles uf ON uf.f_userinfo_id = u.f_userinfo_id
                 LEFT JOIN t_gasbrand g ON uf.f_gasbrand_id = g.id
        WHERE
                f_band_state = '有效' and b.f_userinfo_id is not null and uf.f_table_state = '正常'
        union all
        SELECT
            '' id,
            u.f_userinfo_id,
            u.f_user_state,
            u.f_user_phone,
            u.f_comments,
            u.f_idnumber,
            u.f_balance,
            u.f_open_id,
            '有效' f_band_state,
            u.f_user_name,
            u.f_address,
            u.f_filiale,
            u.f_outlets,
            u.f_operator,
            u.f_createfile_date,
            g.f_meter_brand,
            g.f_meter_type,
            u.f_slice_area AS f_zones,
            u.f_residential_area,
            u.f_building,
            u.f_unit,
            u.f_floor,
            u.f_room,
            u.f_createfile_date f_band_time
        FROM t_userinfo u
                 LEFT JOIN t_userfiles uf ON uf.f_userinfo_id = u.f_userinfo_id
                 LEFT JOIN t_gasbrand g ON uf.f_gasbrand_id = g.id
        WHERE
            isnull(f_open_id,'') != '' and uf.f_table_state = '正常' and u.f_user_state = '正常'
    ) t
WHERE
    {condition}
ORDER BY
    f_userinfo_id DESC
