
import cn.hutool.http.HttpUtil;
import com.af.plugins.RedisTools;
import com.aote.weixin.Config;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * 全局AccessToken获取
 * 请将该类加入到监听器中
 */
public class AccessToken implements ServletContextListener {
	private static Logger log = Logger.getLogger(AccessToken.class);

	private static String access_token;
	public static String url;
	private static Thread t  = new RefreshThread();

	static {
		log.debug("开启定时刷新access_token");
		// 开启定时刷新access_token线程
		t.start();
	}

	public static void refreshToken() {
		int n = 5;
		while (n > 0) {
			try {
				log.debug("刷新token链接:" + url );
				JSONObject content = new JSONObject();
				content.put("grant_type", "client_credential");
				content.put("appid", Config.wechatConfig.getString("appId"));
				content.put("secret", Config.wechatConfig.getString("appSecret"));
				content.put("force_refresh", Config.wechatConfig.getBoolean("forceRefresh",false));
				JSONObject jsonObject = new JSONObject(HttpUtil.post(url, content.toString()));
				if (jsonObject.has("access_token")) {
					if (Config.wechatConfig.getBoolean("tokenRedis")) {
						// 将access_token加入redis
						log.debug("redis缓存access_token");
						RedisTools.setValue("access_token", jsonObject.getString("access_token"));
					}
					access_token = jsonObject.getString("access_token");
					log.debug("刷新access_token成功:" + access_token);
					n = 0;
				} else {
					n--;
					log.debug("刷新access_token失败:" + jsonObject);
				}
			} catch (Exception e) {
				log.debug("刷新access_token异常:", e);
				n--;
			}
		}
	}

	public static String getAccessToken() {
		return access_token;
	}

	@Override
	public void contextInitialized(ServletContextEvent servletContextEvent) {
	}

	@Override
	public void contextDestroyed(ServletContextEvent servletContextEvent) {
		// 强制关闭
		t.stop();
		log.debug("AccessToken===>销毁线程");
	}

	private static class RefreshThread extends Thread {
		@Override
		public void run() {
			while (true) {
				try {
					// 一小时刷新一次
					Thread.sleep(3600000);
				} catch (InterruptedException e) {
					log.debug("线程休眠异常:", e);
				}
				refreshToken();
			}
		}
	}
}
