SELECT
    h.id as f_third_id,
    CONVERT(varchar(7), h.f_hand_date, 23) f_hand_date,
    CONVERT(varchar(7), h.f_input_date, 23) f_input_date,
    cast(cast(f_oughtamount as numeric(10,2)) as varchar) f_oughtamount,
    cast(cast(f_oughtfee as numeric(10,2)) as varchar) f_oughtfee,
    b.f_open_id,
    h.f_userinfo_code,
    h.f_user_name,
    CASE WHEN LEN(isnull(h.f_address,'')) > 20 THEN
        LEFT(h.f_address, 13) + '*' + RIGHT(h.f_address, 6)
    ELSE
    isnull(h.f_address,'')
END AS f_address,
    h.f_userfiles_id,
    h.f_userinfo_id,
    u.f_balance
FROM t_handplan h
LEFT JOIN (
    SELECT
        f_hand_id
    FROM t_sellinghand
    WHERE f_state = '有效'
    GROUP BY f_hand_id
) sh on h.id = sh.f_hand_id
     LEFT JOIN t_userinfo u ON h.f_userinfo_id = u.f_userinfo_id
     LEFT JOIN t_banduser b on  h.f_userinfo_id=b.f_userinfo_id
WHERE
    f_whether_pay='否' AND f_hand_state = '有效' and
    h.f_meter_state = '已抄表' AND f_oughtfee>0
    and b.f_band_state = '有效'
  and u.f_user_state = '正常'
  and b.f_open_id is not null
  and h.f_meter_classify  = '机表'
  and h.id not in(
    select isnull(f_third_id , '') f_third_id  from t_template_push where f_send_type = '机表抄表欠费推送' group by f_third_id having count(*) >= 5
)
