select * from (
  select f_user_id f_userfiles_id,
         '' f_third_id,
         sd.f_userinfo_id,f_type,
         sum(f_surplus_fee) f_surplus_fee,
         cast(sum(f_surplus_fee) as varchar) f_oughtfee_all,
         sd.f_orgid,sd.f_orgname,
         uf.f_user_name,uf.f_userinfo_code,
         bd.f_open_id
  from t_surplus_detail sd
           left join t_userinfo uf on sd.f_userinfo_id = uf.f_userinfo_id
           left join t_banduser bd on uf.f_userinfo_id = bd.f_userinfo_id
  where f_state = '有效'
    and f_whether_pay = '否'
    and f_type = '调价补差'
    and isnull(bd.f_open_id,'') != ''
and isnull(sd.f_send_success,'') != '是'
  group by  f_user_id,
      sd.f_userinfo_id,
      f_type,
      sd.f_orgid,
      sd.f_orgname,
      uf.f_user_name,
      uf.f_userinfo_code,
      bd.f_open_id
) s where {condition} and f_surplus_fee > 0
order by f_userinfo_code
