SELECT
    w.id,
    w.flag,
    w.f_out_trade_no,
    w.f_transaction_id,
    w.f_attach,
    w.f_total_fee,
    w.f_order_state,
    w.f_order_type,
    w.f_openid,
    w.f_create_time,
    w.f_filiale,
    '' f_is_update
FROM
    t_weixinreturnxml w
        LEFT JOIN (
        SELECT f_serial_id
        FROM t_sellinggas
        WHERE f_state IN ('有效', '冲正') AND f_serial_id IS NOT NULL
    ) s ON w.f_transaction_id = s.f_serial_id
WHERE
        w.f_order_state = '已支付'
  AND w.f_transaction_id IS NOT NULL
  AND s.f_serial_id IS NULL
  AND w.f_create_time <= TO_DATE('{dateNow}', 'YYYY-MM-DD HH24:MI:SS')
  AND w.f_create_time >= ADD_MONTHS(TRUNC(SYSDATE), -1)
