select * from (
  SELECT
      u.f_userinfo_id,
      u.f_userinfo_code,
      u.f_user_name,
      u.f_user_state,
      u.f_user_phone,
      u.f_rent_phone, -- 备用电话
      u.f_balance,
      u.f_orgname,
      u.f_depname,
      u.f_orgid,
      u.f_last_check_result, -- 是否安检过
      u.f_credentials,--证件类型
      u.f_contract_id, -- 合同编号
      u.f_idnumber, --证件号
      u.f_people_num, --人口数
      u.f_cost_type, --缴费类型
      a.f_residential_area,
      a.f_address,
      f.f_user_type,
      f.f_gasproperties,
      f.f_meter_base,
      isnull(f.f_hand_date, '') f_hand_date,
      f.f_total_gas,
      f.f_total_fee,
      f.f_meter_classify,
      f.f_table_state,
      b.f_identity,
      isnull(cp.f_upload_date,f_createfile_date) f_upload_date,
      isnull(cp.f_defect_content,'{"result":"正常","data":[]}') f_defect_content,
      isnull(cp.f_entry_status,'入户') f_entry_status
  from t_userinfo u
           LEFT JOIN t_user_address a ON u.f_userinfo_id = a.f_userinfo_id
           LEFT JOIN t_userfiles f ON u.f_userinfo_id = f.f_userinfo_id
           left join t_banduser b on u.f_userinfo_id = b.f_userinfo_id
           left join (
      select cp.*
      from
          (
              select max(f_upload_date) f_upload_date,
                     f_userinfoid,
                     f_userinfo_code
              from t_check_paper
              group by f_userinfoid,f_userinfo_code
          ) a
              left join t_check_paper cp on a.f_upload_date = cp.f_upload_date and a.f_userinfoid = cp.f_userinfoid
  )cp on cp.f_userinfoid = u.f_userinfo_id
  where b.f_open_id = '{f_open_id}'
) userinfo
WHERE { condition } and f_user_state = '正常' and f_table_state = '正常'
ORDER BY f_userinfo_id
