/** 查询用户欠费信息 **/
select
    a.*,
    0 credit_amount,
    convert(decimal(18, 0), case when a.overduedays>0
                                     then a.f_oughtfee*a.overduedays*a.zhinajinbilv
                                 else 0
        end) overdues
from (
         SELECT
             h.id handplan_id,
             h.f_mark,
             h.f_hand_date,
             h.f_input_date,
             h.f_end_date,
             h.f_audit_date,
             h.f_input_person,
             h.f_reduce_fee,
             h.f_whether_pay,
             h.f_amount,
             ISNULL(s.f_debt_money, 0) f_debt_money,
             ISNULL(s.f_credit_amount, 0) f_credit_amount,
             h.f_oughtfee - ISNULL(s.f_debt_money, 0) - ISNULL(s.f_credit_amount, 0) f_oughtfee, --清缴减免后的应缴金额
             h.f_price_id,
             h.f_stairprice_id,
             CASE WHEN h.f_old_date is null
                      THEN case when DATEDIFF(dd,f_end_Date,getdate())>0 then DATEDIFF(dd,f_end_Date,getdate()) else 0 end
                  ELSE case when DATEDIFF(dd,f_old_date,getdate())>0
                                then DATEDIFF(dd,f_old_date,getdate())
                            else 0 end
                 END overduedays, --滞纳天数
             CASE WHEN (f_user_type='民用' or f_user_type='居民')
                      THEN
                      isnull((SELECT cast(value as float) FROM  t_singlevalue WHERE name='民用违约金' and f_filialeids=h.f_filialeids),0)
                  ELSE
                      isnull((SELECT cast(value as float) FROM  t_singlevalue WHERE name='非民用违约金' and f_filialeids=h.f_filialeids),0)
                 END zhinajinbilv,
             h.f_user_name,
             h.f_user_type,
             h.f_gasproperties,
             h.f_userinfo_id,
             h.f_address,
             h.f_hand_state,
             h.f_operator,
             h.f_filiale,
             h.f_outlets,
             h.f_orgstr,
             h.f_filialeids,
             h.f_expense_type
         FROM
             t_handplan h
                 LEFT JOIN (
                 SELECT
                     f_hand_id,
                     SUM (f_debt_money) f_debt_money,
                     SUM (f_credit_amount) f_credit_amount
                 FROM
                     t_sellinghand
                 WHERE
                         f_charge_state = '有效'
                 GROUP BY
                     f_hand_id
             ) s ON h.id = s.f_hand_id
         WHERE
                 f_userinfo_id = '{f_userinfo_id}' and f_hand_state = '有效'
           and f_hand_date > { entity.findDialect() == $SqlServer$: $'{startDate}'$, $to_date('{startDate}','yyyy-mm-dd HH24:mi:ss')$}
   ) a ORDER BY handplan_id desc

