SELECT
    f_open_id,
    convert(varchar,f_balance) f_balance,
    f_userinfo_id,
    f_userfiles_id,
    f_user_name,
    f_meternumber,
    f_time,
    f_userinfo_code,
    f_orgid,
    convert(varchar,f_meter_base) f_meter_base,
    SUBSTRING(f_address,1,20) f_address
FROM (
 SELECT
     b.f_mainOpenid f_open_id,
     b.f_band_state,
     f_user_state,
     f_table_state,
     convert(decimal(18,2), case when gb.f_calculation = '表端结算' then isnull(m.f_jval,0) else isnull(f_balance_amount,0) end) f_balance,
     ui.f_userinfo_id,
     uf.f_userfiles_id,
     ui.f_user_name,
     uf.f_meternumber,
     CONVERT(varchar,GETDATE(),120) f_time,
     ui.f_userinfo_code,
     ui.f_orgid,
     uf.f_meter_base,
     ua.f_address
 FROM
     t_banduser b
         LEFT JOIN t_userinfo ui on ui.f_userinfo_id = b.f_userinfo_id
         LEFT JOIN t_userfiles uf ON ui.f_userinfo_id = uf.f_userinfo_id
         LEFT JOIN t_gasbrand gb on uf.f_gasbrand_id = gb.id
         left join (select max(id) maxid ,f_userfiles_id from t_meteread group by f_userfiles_id) mr on mr.f_userfiles_id = uf.f_userfiles_id
         LEFT JOIN t_meteread m on m.id = mr.maxid
         left join t_user_address ua on ui.f_userinfo_id = ua.f_userinfo_id
 where uf.f_meter_classify = '物联网表' and uf.f_user_type = '民用' and f_band_state = '有效' and f_user_state = '正常' and f_table_state = '正常' and b.f_mainOpenid is not null and maxid is not null
) c where {condition}

