package com.aote.rs;

import cn.hutool.http.Header;
import cn.hutool.http.HttpGlobalConfig;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.af.plugins.CommonTools;
import com.af.plugins.xq.DefaultAsyncTools;
import com.alibaba.fastjson.JSON;
import com.aote.entity.EntityServer;
import com.aote.entity.WxNofityReturnData;
import com.aote.exception.FileNotFoundException;
import com.aote.logic.LogicServer;
import com.aote.rs.h5pay.H5Webpay;
import com.aote.rs.mapper.WebException;
import com.aote.rs.scanpay.CodeNotify;
import com.aote.rs.scanpay.CreateQRcode;
import com.aote.rs.swingcardpay.SwingcardPrepay;
import com.aote.rs.wechatauth.WxOpenIdRequest;
import com.aote.rs.wechatpay.*;
import com.aote.sql.SqlMapper;
import com.aote.sql.SqlServer;
import com.aote.util.*;
import com.aote.utils.QRCodeUtil;
import com.aote.weixin.Config;
import com.jonnyliu.proj.wechat.bean.MessageHandlerElement;
import com.jonnyliu.proj.wechat.converter.MessageConvert;
import com.jonnyliu.proj.wechat.core.MessageHandlerAdapter;
import com.jonnyliu.proj.wechat.exception.NoMessageHandlerFoundException;
import com.jonnyliu.proj.wechat.handler.AbstractMessageHandler;
import com.jonnyliu.proj.wechat.message.request.BaseRequestMessage;
import com.jonnyliu.proj.wechat.message.response.BaseResponseMessage;
import com.jonnyliu.proj.wechat.utils.MessageUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.imageio.ImageIO;
import javax.inject.Singleton;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.*;

@Path("weixin")
@Singleton
@Component
@Transactional(rollbackFor = Exception.class)
public class WeiXinService {

    static Logger log = LoggerFactory.getLogger(WeiXinService.class);
    @Autowired
    private EntityServer entity;
    @Autowired
    public EntityServer entityServer;

    @Autowired
    private LogicServer logicServer;

    @Autowired
    private SqlServer sql;
    /**
     * 微信获取授权及用户id
     */
    @Autowired
    private WxOpenIdRequest wxOpenIdRequest;

    /**
     * 微信H5支付生成数据
     */
    @Autowired
    private H5Webpay h5prepay;

    /**
     * 微信支付生成数据
     */
    @Autowired
    private Attachprepay attachprepay;
    /**
     * 微信退费
     */
    @Autowired
    private WxRefund wxRefund;
    /**
     * 微信支付回调
     */
    @Autowired
    private WxPayment wxPayment;
    /**
     * 微信其他收费回调
     */
    @Autowired
    private WxOtherPayment wxOtherPayment;
    /**
     * 刷卡支付
     */
    @Autowired
    private SwingcardPrepay SwingcardPrepay;
    /**
     * 扫码支付回调
     */
    @Autowired
    private CodeNotify codeNotify;
    /**
     * 扫码支付数据组织
     */
    @Autowired
    private CreateQRcode createqrcode;
    /**
     * 配置微客服cc路径
     */
    public static String ccurl;
    /**
     * 是否开启获取全局access_token
     */
    public static boolean hasCustomService;
    public static boolean hasMoreTokenFiliale;
    public static int THUMBNAIL_SIZE = 200;
    public static String FILE_LOCATION;
    public static String FFMPEG_LOCATION;
    /**
     * 支付处理成功返回微信数据
     */
    public static String notifySuccessful = "<xml><return_code>SUCCESS</return_code><return_msg>OK</return_msg></xml>";

    @Autowired
    private MessageHandlerAdapter messageHandlerAdapter;

    @Autowired
    private MessageConvert messageConverter;

    static {
        log.debug("WeiXinService.class static start");
        // 全局设置HttpUtil默认的连接和读取超时时长
        HttpGlobalConfig.setTimeout(30000);
        ccurl = Config.wechatConfig.getString("cccurl");
        THUMBNAIL_SIZE = Config.wechatConfig.getInt("thumbNailSize");
        FILE_LOCATION = Config.wechatConfig.getString("fileLocation");
        FFMPEG_LOCATION = WeiXinService.class.getProtectionDomain().getCodeSource().getLocation().getPath().replace("/", "\\").substring(1) + "ffmpeg\\bin\\ffmpeg.exe";
        hasCustomService = Config.wechatConfig.getBoolean("hasCustomService");
        hasMoreTokenFiliale = Config.wechatConfig.getBoolean("hasMoreTokenFiliale");
        if (hasCustomService) {
            // 多个分公司获取tonken
            if (hasMoreTokenFiliale) {
                String filiales =  Config.wechatConfig.getString("openAccessTokenFiliale");
                String[] filialeArrray = filiales.split("-");
                for (int i = 0; i < filialeArrray.length; i++) {
                    JSONObject wxConfig = Config.getConfig(filialeArrray[i]);
                    String appId = wxConfig.getString("appId");
                    String appSecret = wxConfig.getString("appSecret");
                    String tokenName = "access_token_" + filialeArrray[i];
                    AccessToken.url = WechatUrl.ACCESSTOKEN_URL.replace("APPID", appId).replace("APPSECRET", appSecret);
                    AccessToken.urlMap.put(tokenName, AccessToken.url);
                    AccessToken.token_name = tokenName;
                    AccessToken.refreshToken();
                    AccessToken.accessTokenMap.put(tokenName, AccessToken.getAccessToken());
                    AccessToken.url = null;
                    AccessToken.token_name = null;
                    AccessToken.setAccess_token("");
                }
            }  else {
                // 单个分公司获取tonken
                AccessToken.url = Config.wechatConfig.getString("aturl");
                AccessToken.refreshToken();
            }
        }
        log.debug("WeiXinService.class static end");
    }

    /**
     * 介入微信服务器
     *
     * @param signature
     * @param timestamp
     * @param nonce
     * @param echostr
     * @return
     */
    @GET
    public String verifyServer(@QueryParam("signature") String signature, @QueryParam("timestamp") String timestamp,
                               @QueryParam("nonce") String nonce, @QueryParam("echostr") String echostr) {
        return echostr;
    }

    /**
     * 消息处理器，微信通知所有的事件和消息
     *
     * @param xml
     * @return
     */
    @POST
    @Produces("text/xml;charset=utf-8")
    public String msgHandler(String xml) {
        try {
            String msgType = MessageUtils.getMessageType(xml);
            String eventType = MessageUtils.getEventType(xml);
            MessageHandlerElement messageHandlerElement = new MessageHandlerElement(msgType, eventType);
            //将不同类型的消息发送给不同的消息处理器
            AbstractMessageHandler messageHandler = this.messageHandlerAdapter.findMessageHandler(messageHandlerElement);
            if (messageHandler == null) {
                throw new NoMessageHandlerFoundException("no message handler found for message type " + msgType + " and event type " + eventType);
            }
            //将用户发过来的消息转换成消息对象
            BaseRequestMessage requestMessage = this.messageConverter.doConvert(xml);
            //调用消息处理器处理消息
            BaseResponseMessage responseMessage = messageHandler.handleMessage(requestMessage);
            if (responseMessage == null) {
                return "";
            }
            //构造给用户的响应消息
            String responseXml = MessageUtils.messageToXml(responseMessage);
            if (log.isDebugEnabled()) {
                log.debug("response xml : {}", responseXml);
            }
            return responseXml;
        } catch (NoMessageHandlerFoundException e) {
            log.error("找不到对应消息处理器");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return "";
    }

    /**
     * 根据分公司orgname获取token
     * orgname：分公司文件夹名
     **/
    private String token (String orgname) {
        if (orgname == null || orgname.length() == 0) {
            throw new RuntimeException("公司信息不能为空！");
        }
        String accessToken = "";
        // 多个分公司获取tonken
        if (hasMoreTokenFiliale) {
            String key = "access_token_" + orgname;
            log.debug("key:" + key);
            accessToken =  AccessToken.accessTokenMap.get(key);
        } else {
            accessToken = AccessToken.getAccessToken();
        }
        return accessToken;
    }

    /**
     * 介入微信服务器
     *
     * @param signature
     * @param timestamp
     * @param nonce
     * @param echostr
     * @return
     */
    @GET
    @Path("cc/{orgname}")
    public String verifyServer2(@QueryParam("signature") String signature, @QueryParam("timestamp") String timestamp,
                                @QueryParam("nonce") String nonce, @QueryParam("echostr") String echostr) {
        return echostr;
    }

    /**
     * 消息处理器，微信通知所有的事件和消息
     * @param body
     * @return
     */
    @POST
    @Path("cc/{orgname}")
    public Response msgHandler2(@PathParam("orgname") String orgname,String body) {
        log.debug("msg received:" + body);
        log.debug("orgname:" + orgname);

        // start a new thread
        if(hasCustomService) {
            new Thread(new Runnable() {
                @Override
                public void run() {
                    // 多个分公司获取tonken
                    if (hasMoreTokenFiliale) {
                        String key = "access_token_" + orgname;
                        log.debug("msg key:" + key);
                        toCCC(body,  AccessToken.accessTokenMap.get(key));
                    } else {
                        toCCC(body, AccessToken.getAccessToken());
                    }
                }
            }).start();
        }
        return Response.status(200).entity("success").header("Content-Type", "text/html").build();
    }

    private void toCCC(String body, String accessToken) {
        log.debug("进入自定义菜单处理接口！");
        try {
            XStream xs = new XStream(new DomDriver());
            xs.alias("xml", WeMsg.class);
            WeMsg msg = (WeMsg) xs.fromXML(body);
            log.debug("解析后的消息：" + msg);
            // 点击自定义菜单跳转事件,不转给cc了
            if ("VIEW".equals(msg.getEvent())) {
                return;
            }
            int status = HttpRequest.post(ccurl + "?ak=" + accessToken).timeout(60000).body(msg.toString()).execute().getStatus();
            if (status != 200) {
                log.debug("文字服务异常.");
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.debug("文字服务异常：" + e.getMessage());
        }
    }

    @GET
    @Path("tk")
    public String getAccessToken() {
        return AccessToken.getAccessToken();
    }

    @GET
    @Path("tk/{orgname}")
    public String getAccessTokens(@PathParam("orgname") String orgname) {
        if (orgname == null || orgname.length() == 0) {
            throw new RuntimeException("公司信息不能为空！");
        }
        String key = "access_token_" + orgname;
        log.debug("获取分公司token:" + key);
        String token = AccessToken.accessTokenMap.get(key);
        log.debug("获取到token值:" + token);
        return token;
    }

    @GET
    @Path("refreshToken")
    public void refreshToken() {
        AccessToken.refreshToken();
    }

    @POST
    @Path("upload/{type}/{orgname}")
    @Consumes(MediaType.MULTIPART_FORM_DATA)
    public String uploadFile(@PathParam("type") String type,
                             @PathParam("orgname") String orgname,
                             @FormDataParam("file") InputStream uploadedInputStream,
                             @FormDataParam("file") FormDataContentDisposition fileDetail) {
        try {
            String fileName = fileDetail.getFileName();
            fileName = new String(fileName.getBytes("iso-8859-1"), "UTF-8");

            int pos = fileName.lastIndexOf('.');
            String thumbNailFileName = fileName.substring(0, pos) + "_";

            if (type.equals("voice")) {
                thumbNailFileName += ".mp3";
            } else if (type.equals("video")) {
                thumbNailFileName += ".jpg";
            } else {
                thumbNailFileName += fileName.substring(pos);
            }

            String fullFileName = FILE_LOCATION + "\\" + fileName;

            writeToFile(uploadedInputStream, fullFileName);
            uploadedInputStream.close();
            String mediaId = uploadWcMedia(fullFileName, fileName, type, orgname);

            if (mediaId == null) {
                return "{\"code\":500, \"msg\":\"上传素材到微信失败！\"}";
            }

            File file = new File(fullFileName);

            if (type.equals("video")) {
                createVideoThumbNail(FILE_LOCATION + "\\" + thumbNailFileName, fullFileName);
            } else if (type.equals("voice")) {
                createVoiceThumbNail(FILE_LOCATION + "\\" + thumbNailFileName, fullFileName);
            } else if (type.equals("image")) {
                createImageThumbNail(FILE_LOCATION + "\\" + thumbNailFileName, file);
            }

            return "{\"code\": 200, \"msgType\": \"" + type + "\", \"mediaId\": \"" + mediaId
                    + "\", \"fileName\": \"" + fileName + "\", \"thumbnail\": \"" + thumbNailFileName + "\"}";
        } catch (Exception e) {
            e.printStackTrace();
            return "{\"code\":500}";
        }
    }

    /**
     * 删除素材id
     *
     * @param mediaId
     * @return
     */
    @POST
    @Path("del/{mediaId}/{orgname}")
    public String delMediaById(@PathParam("mediaId") String mediaId, @PathParam("orgname") String orgname) {
        try {
            String accessToken = token(orgname);
            log.debug("删除素材的accessToken:" + accessToken);
            String url = "https://api.weixin.qq.com/cgi-bin/material/del_material?access_token=" + accessToken;
            log.debug("删除素材的url:" + url);
            JSONObject json = new JSONObject();
            json.put("media_id", mediaId);
            String res = HttpUtil.post(url, JSON.toJSONString(json));
            log.debug("删除素材的response: {}", res);
            JSONObject response = new JSONObject(res);
            if (response.has("errcode") && response.getInt("errcode") == 0) {
                return "{\"code\":200}";
            } else {
                return "{\"code\":500}";
            }
        } catch (Exception e) {
            e.printStackTrace();
            return "{\"code\":500}";
        }
    }

    private String uploadWcMedia(String fileName, String desc, String type, String orgname) throws Exception {
        HttpClient client = HttpClientBuilder.create().build();
        String accessToken = token(orgname);
        log.debug("上传素材时候的accessToken:" + accessToken);
        String url = "://api.weixin.qq.com/cgi-bin/material/add_material?access_token=" + accessToken + "&type=" + type;
        if (type.equals("video")) {
            url = "http" + url;
        } else {
            url = "https" + url;
        }

        HttpPost post = new HttpPost(url);

        MultipartEntity entity = new MultipartEntity();

        File file = new File(fileName);
        entity.addPart("media", new FileBody(file));
        if (type.equals("video")) {
            String uuid = UUID.randomUUID().toString();
            entity.addPart("description", new StringBody("{\"title\": \"" + uuid + "\", \"introduction\": \"" + uuid + "\"}"));
        }
        post.setEntity(entity);
        HttpResponse response = client.execute(post);
        if (response.getStatusLine().getStatusCode() == 200) {
            String result = EntityUtils.toString(response.getEntity());
            JSONObject js = new JSONObject(result);
            if (js.has("media_id")) {
                return js.getString("media_id");
            } else {
                return null;
            }
        } else {
            return null;
        }
    }

    private void writeToFile(InputStream uploadedInputStream, String uploadedFileLocation) throws Exception {
        OutputStream out;
        int read = 0;
        byte[] bytes = new byte[1024];

        out = new FileOutputStream(new File(uploadedFileLocation));
        while ((read = uploadedInputStream.read(bytes)) != -1) {
            out.write(bytes, 0, read);
        }
        out.flush();
        out.close();
    }

    /**
     * create a thumb nail
     *
     * @param thumbNailFileName
     * @param file
     * @throws Exception
     */
    private void createImageThumbNail(String thumbNailFileName, File file) throws Exception {
        BufferedImage originImg = ImageIO.read(file);
        int d = ((originImg.getWidth() > originImg.getHeight()) ? originImg.getWidth() : originImg.getHeight());

        double scale = (THUMBNAIL_SIZE * 1.0) / d;
        int w = (int) (originImg.getWidth() * scale);
        int h = (int) (originImg.getHeight() * scale);

        BufferedImage img = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
        img.createGraphics().drawImage(originImg.getScaledInstance(w, h, Image.SCALE_SMOOTH), 0, 0, null);
        ImageIO.write(img, "jpg", new File(thumbNailFileName));
    }

    /**
     * @param thumbNailFileName
     * @param fileName
     * @throws IOException
     */
    private void createVoiceThumbNail(String thumbNailFileName, String fileName) throws Exception {
        String path = FFMPEG_LOCATION + " -i " + fileName + " " + thumbNailFileName;
        Runtime rt = Runtime.getRuntime();
        Process pr = rt.exec(path);
        pr.waitFor();
    }

    /**
     * @param thumbNailFileName
     * @param fileName
     * @throws IOException
     */
    private void createVideoThumbNail(String thumbNailFileName, String fileName) throws Exception {
        String path = FFMPEG_LOCATION + " -i " + fileName + " -ss 00:00:00.000 -vframes 1 " + thumbNailFileName;
        Runtime rt = Runtime.getRuntime();
        Process pr = rt.exec(path);
        pr.waitFor();
    }

    /**
     * 微信获取用户授权code
     *
     * @param state 参数信息(第一个参数为分公司),最多128字节
     * @throws Exception
     */
    @GET
    @Path("getcode")
    public String getcode(@QueryParam("state") String state, @Context HttpServletResponse response) throws Exception {
        log.debug("state: " + state);
        if (state == null) {
            throw new RuntimeException("参数不能为空！");
        }
        String filiale;
        if (!state.contains("(=)")) {
            filiale = state;
        } else {
            // 多参数,如: jiuhuashan(=)goto=home,拆分自定义参数(以'(=)'拆封)
            String[] states = state.split("\\(=\\)");
            filiale = states[0];
        }
        // 通过filiale获取访问用户的APPID/重定向信息
        JSONObject wxConfig = Config.getConfig(filiale);
        String appId = wxConfig.getString("appId");
        log.debug("appId: " + appId);
        String openIdUrl = wxConfig.getString("openIdUrl");
        log.debug("openIdUrl: " + openIdUrl);
        String uri = wxOpenIdRequest.getCodeUrl(appId, openIdUrl, state);
        log.debug("uri: " + uri);
        response.sendRedirect(uri);
        return "";
    }

    /**
     * 第三方app调用微信传入
     *
     * @param state 参数信息(第一个参数为分公司),最多128字节
     * @param code 唯一标识
     * @throws Exception
     */
    @GET
    @Path("getidentification")
    public String getidentification(@QueryParam("state") String state, @QueryParam("code") String code,@Context HttpServletResponse response) throws Exception {
        log.debug("state: " + state);
        log.debug("code: " + code);
        String filiale = state;
        JSONObject wxConfig = Config.getConfig(filiale);
        String ywNotifyUrl;
        // 判断是否使用全局跳转链接
        String ywNotifyUrlGlobal = Config.wechatConfig.getString("ywNotifyUrlGlobal");
        if (ywNotifyUrlGlobal == null || "".equals(ywNotifyUrlGlobal)) {
            ywNotifyUrl = wxConfig.getString("ywNotifyUrl");
        } else {
            ywNotifyUrl = ywNotifyUrlGlobal;
        }
        String openId = code;
        try {
            response.sendRedirect(ywNotifyUrl + "" + openId + "&filiale=" + filiale);
        } catch (IOException e) {
            throw new RuntimeException("重定向获取微信授权失败！", e);
        }
        return "";
    }

    /**
     * 获取用户openid
     *
     * @param code     code作为换取access_token的票据，每次用户授权带上的code将不一样，code只能使用一次，5分钟未被使用自动过期。
     * @param state    自定义的参数
     * @param response
     * @return
     */
    @GET
    @Path("getOpenid")
    public String getOpenid(@QueryParam("code") String code, @QueryParam("state") String state, @Context HttpServletResponse response) {
        log.debug("获取到的state =====> " + state);
        log.debug("获取到的code =====> " + code);
        String filiale;
        String allParam;
        if (!state.contains("(=)")) {
            allParam = filiale = state;
        } else {
            String[] states = state.split("\\(=\\)");
            allParam = filiale = states[0];
            if (state.contains("goto=")) {
                // 规定只能最后一个是goto参数, 所以直接取
                String[] goToPage = states[states.length-1].split("=");
                // 其他参数拼接
                if (!states[1].startsWith("goto")) {
                    for (int i = 1; i < states.length-1; i++) {
                        allParam += ("&" + states[i]);
                    }
                }
                allParam += ("#/" + goToPage[1]);
            } else {
                for (int i = 1; i < states.length; i++) {
                    allParam += ("&" + states[i]);
                }
            }
        }
        log.debug("所有参数 =====> " + allParam);
        JSONObject wxConfig = Config.getConfig(filiale);
        String appId = wxConfig.getString("appId");
        String appSecret = wxConfig.getString("appSecret");
        String ywNotifyUrl;
        // 判断是否使用全局跳转链接
        String ywNotifyUrlGlobal = Config.wechatConfig.getString("ywNotifyUrlGlobal");
        if (ywNotifyUrlGlobal == null || "".equals(ywNotifyUrlGlobal)) {
            ywNotifyUrl = wxConfig.getString("ywNotifyUrl");
        } else {
            ywNotifyUrl = ywNotifyUrlGlobal;
        }
        JSONObject result = wxOpenIdRequest.openidRequest(code, appId, appSecret);
        String openId = result.getString("openid");
        try {
            response.sendRedirect(ywNotifyUrl + "" + openId + "&filiale=" + allParam);
        } catch (IOException e) {
            throw new RuntimeException("重定向获取微信授权失败！", e);
        }
        return result.toString();
    }

    /**
     * 微信公众号支付预下单
     *
     * @param money   支付金额（分）
     * @param openid  openid
     * @param attach  附带数据
     * @param filiale 公司名称
     * @param request
     * @return
     */
    @GET
    @Path("getattachprepayid")
    public String getattachprepayid(
            @QueryParam("money") String money,
            @QueryParam("openid") String openid,
            @QueryParam("attach") String attach,
            @QueryParam("filiale") String filiale,
            @Context HttpServletRequest request) {
        if (filiale == null) {
            throw new RuntimeException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        String appId = wxConfig.getString("appId");
        String key = wxConfig.getString("key");
        String mchId = wxConfig.getString("mchId");
        String wechatNotify = wxConfig.getString("wechatNotify");
        String orderType = "燃气收费";
        String ip = request.getRemoteAddr();
        JSONObject json = new JSONObject();
        json.put("appId", appId);
        json.put("key", key);
        json.put("mchId", mchId);
        json.put("wechatNotify", wechatNotify);
        json.put("money", money);
        json.put("openid", openid);
        json.put("attach", attach);
        json.put("ip", ip);
        json.put("filiale", filiale);
        json.put("orderType", orderType);
        String result = attachprepay.prePay(json);
        log.debug("返回的数据" + result);
        return result;
    }

    /**
     * 微信H5支付预下单
     * @param money 支付金额
     * @param openid openid
     * @param attach 附带数据
     * @param filiale 公司名称
     * @param request
     * @return
     */
    @GET
    @Path("h5pay")
    public String H5pay(
            @QueryParam("money") String money,
            @QueryParam("openid") String openid,
            @QueryParam("attach") String attach,
            @QueryParam("filiale") String filiale,
            @Context HttpServletRequest request) {

        log.debug("H5支付预下单,下单用户"+attach);
        if (filiale == null) {
            throw new RuntimeException("公司信息不能为空！");
        }

        JSONObject wxConfig = Config.getConfig(filiale);
        String appId =wxConfig.getString("appId");
        String key =wxConfig.getString("key");
        String mchId =wxConfig.getString("mchId");
        String wechatNotify =wxConfig.getString("wechatNotify");
        String h5PayUrl =wxConfig.getString("h5PayUrl");
        String ip = GetUserIp.getIpAdrress(request);
        String orderType = "燃气收费";
        JSONObject json = new JSONObject();
        json.put("appId", appId);
        json.put("key", key);
        json.put("h5PayUrl", h5PayUrl);
        json.put("mchId", mchId);
        json.put("wechatNotify", wechatNotify);
        json.put("ip", ip);
        json.put("orderType", orderType);
        json.put("money", money);
        json.put("openid", openid);
        json.put("attach", attach);
        json.put("filiale", filiale);
        String result = h5prepay.prePay(json);
        return result;
    }



    /**
     * 微信公众号其他收费下单
     *
     * @param money   支付金额（分）
     * @param openid  openid
     * @param attach  附带数据
     * @param filiale 公司名称
     * @param request
     * @return
     */
    @GET
    @Path("otherfee")
    public String otherfee(
            @QueryParam("money") String money,
            @QueryParam("openid") String openid,
            @QueryParam("attach") String attach,
            @QueryParam("filiale") String filiale,
            @QueryParam("othertype") String othertype,
            @Context HttpServletRequest request) {
        if (filiale == null) {
            throw new RuntimeException("公司信息不能为空！");
        }
        othertype = EscapeUtils.unescape(othertype);
        if (othertype == null) {
            othertype = "其他收费";
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        String appId = wxConfig.getString("appId");
        String key = wxConfig.getString("key");
        String mchId = wxConfig.getString("mchId");
        String wechatNotify = wxConfig.getString("otherFeeNotify");
        String ip = request.getRemoteAddr();
        JSONObject json = new JSONObject();
        json.put("appId", appId);
        json.put("key", key);
        json.put("mchId", mchId);
        json.put("wechatNotify", wechatNotify);
        json.put("money", money);
        json.put("openid", openid);
        json.put("attach", EscapeUtils.unescape(attach));
        json.put("ip", ip);
        json.put("filiale", filiale);
        json.put("orderType", othertype);
        String result = attachprepay.prePay(json);
        log.debug("返回的数据" + result);
        return result;
    }


    @GET
    @Path("getWechatScan")
    public String getWechatScan(@QueryParam("path") String path) {
        return getJSSDK(path);
    }

    public static String getJSSDK(@QueryParam("path") String path) {
        log.debug("path ======> " + path);
        String[] filialeInfo = path.split("&");
        String filiale = filialeInfo[1].substring(filialeInfo[1].lastIndexOf("=") + 1).trim();
        log.debug("filiale ======> " + filiale);
        JSONObject json = new JSONObject();
        JSONObject wxConfig = Config.getConfig(filiale);
        String appId = wxConfig.getString("appId");
        log.debug("appId =======> " + appId);
        String timestamp = WxSign.getTimeStamp();
        String nonceStr = WxSign.getNonceStr();
        if (hasMoreTokenFiliale) {
            String token_name = "access_token_" + filiale;
            JSAPITicket.accessToken = AccessToken.accessTokenMap.get(token_name);
        }
        String ticket = JSAPITicket.getTicket();
        // 获取签名
        SortedMap<Object, Object> finalpackage = new TreeMap<Object, Object>();
        finalpackage.put("jsapi_ticket", ticket);
        finalpackage.put("timestamp", timestamp);
        finalpackage.put("noncestr", nonceStr);
        finalpackage.put("url", path);
        String sortStr = SignUtils.sortStr(finalpackage);
        log.debug(sortStr);
        String sign = SignUtils.encode(sortStr);
        json.put("appId", appId);
        json.put("timeStamp", timestamp);
        json.put("nonceStr", nonceStr);
        json.put("sign", sign);
        log.debug(json.toString());
        return json.toString();
    }

    @GET
    @Path("getWechat")
    public String getWechat(@QueryParam("path") String path) {
        return getJSSDK(path);
    }

    /**
     * @param request
     * @param value   ({filiale: 公司信息,money: 退款金额(分),transaction_id: 支付流水号})
     * @return
     */
    @POST
    @Path("refund")
    public String refund(@Context HttpServletRequest request, String value) {
        log.debug("退款参数:" + value);
        JSONObject params = new JSONObject(value);
        String filiale = params.getString("filiale");
        String money = String.valueOf(params.get("money"));
        String transaction_id = params.getString("transaction_id");
        JSONObject wxConfig = Config.getConfig(filiale);
        String appId = wxConfig.getString("appId");
        String key = wxConfig.getString("key");
        String mchId = wxConfig.getString("mchId");
        // 微信退费证书路径
        String certificatePath = wxConfig.getString("certificatePath");
        String ip = request.getRemoteAddr();
        int port = request.getRemotePort();
        return wxRefund.SendRefundreq(appId, mchId, key, money, transaction_id, certificatePath, ip, port + "").toString();
    }

    /**
     * 微信公众号支付完成回调处理
     *
     * @param value
     * @return
     */
    @POST
    @Path("notify")
    public String notify(String value) {
        log.debug("start-notify");
        String result = wxPayment.pay(value);
        log.debug("end-notify");
        return result;
    }

    /**
     * 微信支付扫码回调接口
     *
     * @param request
     * @return
     * @throws RuntimeException
     * @throws IOException
     */
    @POST
    @Path("codenotify")
    public String getcodeurl(@Context HttpServletRequest request) throws Exception {
        InputStream is = request.getInputStream();
        WxNofityReturnData reData = PayFee.getNofityReturnData(is);
        codeNotify.CodeNotifypay(reData);
        return "SUCCESS";
    }

    /**
     * 微信公众号其他收费回调处理
     *
     * @param value
     * @return
     */
    @POST
    @Path("otherFeeNotify")
    public String otherFeeNotify(String value) {
        log.debug("start-otherFeeNotify");
        String result = wxOtherPayment.pay(value);
        log.debug("end-otherFeeNotify");
        return result;
    }

    /**
     * 支付完成回调,直接返回success,订单不处理,订单通过主动查询处理
     */
    @POST
    @Path("notifySuccess")
    @Produces(MediaType.TEXT_XML)
    public String notifySuccess(String value) {
        log.debug("回调jiluszhi: {}" , value);
        return notifySuccessful;
    }

    /**
     * 刷卡支付处理
     * 传一个jsonobject 包括地下列出的
     * String money 扫码支付的钱数
     * JSONObject js 写到的商家数据包，支付 成功后可在attach内原样返回
     * String str 商品描述，或缴费说明，必填
     * String authcode 刷卡授权码 必填
     *
     * @throws IOException
     */
    @POST
    @Path("Swingcard")
    public String Swingcard(
            @Context HttpServletRequest request,
            @Context HttpServletResponse response,
            @QueryParam("filiale") String filiale) throws RuntimeException, IOException {
        JSONObject wxConfig = Config.getConfig(filiale);
        String appId = wxConfig.getString("appId");
        String key = wxConfig.getString("key");
        String mchId = wxConfig.getString("mchId");
        String ip = request.getRemoteAddr();
        log.debug("拿到的参数");
        InputStream is = request.getInputStream();
        String result = IOUtils.toString(is, "UTF-8");
        JSONObject json = new JSONObject(result);
        log.debug(result);
        JSONObject jo = SwingcardPrepay.swingcardprePay(appId, mchId, ip, key, json);
        if (jo.getInt("code") == 200) {
            return jo.toString();
        } else {
            return jo.toString();
        }

    }

    /**
     * 请求微信扫码支付接口
     *
     * @param request
     * @param value   （参数格式{money: "",attach: "", str: "", filiale: ""}）
     * @return
     */
    @POST
    @Path("gasgetcode")
    public String getcode(@Context HttpServletRequest request, String value) throws Exception {
        JSONObject jsonObject = new JSONObject(value);
        String filiale = jsonObject.getString("filiale");
        JSONArray data = sql.query("select * from t_weixinConfig where f_orgid ='"+filiale+"'");
        if (data.length() == 0 || data.length() > 1) {
            throw new RuntimeException("配置表中不存在该分公司配置");
        }
        JSONObject wxConfig = data.getJSONObject(0);
        log.debug("微信扫码wxConfig >>> " + wxConfig);
        String codeNotifyUrl = "http://" + wxConfig.getString("f_domain_name") + "/weixin2/rs/weixin/codenotify";
        String appId = wxConfig.getString("f_appid");
        String key = wxConfig.getString("f_api_key");
        String mchId = wxConfig.getString("f_mchid");
        String ip = request.getRemoteAddr();
        JSONObject qrcode = createqrcode.qrcode(appId, key, mchId, codeNotifyUrl, ip, value);
        // 微信扫码支付下单处理成功则调用查询接口去查看订单状态
        if (qrcode.getInt("code") == 200 && qrcode.has("url")) {
            JSONObject json = new JSONObject();
            json.put("out_trade_no", qrcode.getString("out_trade_no"));
            json.put("f_filiale", filiale);
            json.put("appId",appId);
            json.put("key",key);
            json.put("mchId",mchId);
            Thread thread = new Thread(() -> {
                try {
                    for (int i = 0; i < 20; i++) {
                        JSONObject result = new JSONObject(this.orderStatus(json.toString()));
                        if ("SUCCESS".equals(result.optString("trade_state"))) {
                            // 支付成功,执行扫码缴费成功回调
                            String resultXml = JSONUtil.toXmlStr(JSONUtil.parseObj(new JSONObject().put("xml", result).toString()));
                            HttpUtil.post(codeNotifyUrl, resultXml, 60000);
                            break;
                        }
                        // 失败则5秒在查询
                        Thread.sleep(5000);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            thread.start();
        }
        return qrcode.toString();
    }

    /**
     * 报装请求微信扫码支付接口
     *
     * @param request
     * @param value   （参数格式{money: "",attach: "", str: "", filiale: ""}）
     * @return
     */
    @POST
    @Path("bzgetcode")
    public String bzgetcode(@Context HttpServletRequest request, String value) throws Exception {
        JSONObject jsonObject = new JSONObject(value);

        String filiale = jsonObject.getString("filiale");
        JSONArray data = sql.query("select * from t_weixinConfig where f_orgid ='"+filiale+"'");
        if (data.length() == 0 || data.length() > 1) {
            throw new RuntimeException("配置表中不存在该分公司配置");
        }
        JSONObject wxConfig  =  data.getJSONObject(0);
        log.debug("baozhuang微信扫码wxConfig >>> " + wxConfig);
        String wechatNotify = "http://" + wxConfig.getString("f_domain_name") + "/weixin2/rs/weixin/notify";
        String appId = wxConfig.getString("f_appid");
        String key = wxConfig.getString("f_api_key");
        String mchId = wxConfig.getString("f_mchid");
        String ip = request.getRemoteAddr();
        JSONObject qrcode = createqrcode.bzqrcode(appId, key, mchId, wechatNotify, ip, value);
        log.debug("-----------------" + qrcode.toString());
        return qrcode.toString();
    }

    /**
     * 查询报装是否支付成功
     *
     * @param value（参数格式{filiale: "",out_trade_no: ""}）
     * @return 订单支付结果
     */
    @POST
    @Path("queryBzIsPay")
    public String queryBzIsPay(@Context HttpServletRequest request, String value) throws Exception {
        log.debug("调取报装查询订单 >>> " + value);
        JSONObject jsonObject = new JSONObject(value);
        String filiale = jsonObject.getString("filiale");
        JSONArray data = sql.query("select * from t_weixinConfig where f_orgid ='"+filiale+"'");
        if (data.length() == 0 || data.length() > 1) {
            throw new RuntimeException("配置表中不存在该分公司配置");
        }
        JSONObject wxConfig  =  data.getJSONObject(0);
        String appId = wxConfig.getString("f_appid");
        String mchId = wxConfig.getString("f_mchid");
        String key = wxConfig.getString("f_api_key");
        String nonceStr = WxSign.getNonceStr();
        // 签名
        SortedMap<Object, Object> parameters = new TreeMap<Object, Object>();
        parameters.put("appid", appId);
        parameters.put("mch_id", mchId);
        parameters.put("nonce_str", nonceStr);
        if (jsonObject.has("out_trade_no")) {
            parameters.put("out_trade_no", jsonObject.getString("out_trade_no"));
        }
        parameters.put("sign", WxSign.createSign(parameters, key));
        String requestXml = XmlUtils.getRequestXml(parameters);
        try {
            // 发送查询请求
            String returnXml = HttpUtil.post(WechatUrl.PAY_QUERY_API, requestXml, 60000);
            String xml = JSONUtil.parseFromXml(returnXml).get("xml").toString();
            log.debug("查询订单返回:" + xml);
            return xml;
        } catch (Exception e) {
            log.debug("查询订单出错:" + e);
            return "{}";
        }
    }



    /**
     * 付款码支付
     *
     * @param request
     * @param value   {filiale: 分公司, money: 金额, auth_code: 付款码, [body: 商品信息], f_userfiles_id: 表主键}
     * @return 支付结果 {result_msg: 支付确认成功, [err_code_des: 错误详情],[out_trade_no: 订单号]}
     * @throws Exception
     */
    @POST
    @Path("paymentCode")
    @Produces(MediaType.APPLICATION_JSON)
    public String paymentCode(@Context HttpServletRequest request, String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("收到付款码下单支付请求:" + value);
            JSONObject jsonObject = new JSONObject(value);

            String filiale = jsonObject.getString("filiale");
            JSONArray data = sql.query("select * from t_weixinConfig where f_orgid ='"+filiale+"'");
            if (data.length() == 0 || data.length() > 1) {
                throw new RuntimeException("配置表中不存在该分公司配置");
            }
            JSONObject wxConfig  =  data.getJSONObject(0);

            log.debug("公司配置:" + wxConfig.toString());
            // 支付请求数据
            SortedMap<Object, Object> parameters = new TreeMap<Object, Object>();
            parameters.put("body", jsonObject.optString("body", "燃气-天然气"));
            parameters.put("out_trade_no", WxSign.getNonceStr());
            // 支付金额,单位：分
            Double b = new BigDecimal(String.valueOf(jsonObject.get("money"))).multiply(new BigDecimal("100")).doubleValue();
            parameters.put("total_fee", b.intValue());
            parameters.put("spbill_create_ip", request.getRemoteAddr());
            // 支付授权码
            parameters.put("auth_code", jsonObject.getString("auth_code"));
            // 填充余下基本字段
            WXPayUtil.fillRequestData(parameters, wxConfig);
            // 将map转换为xml
            String requestXml = XmlUtils.getRequestXml(parameters);
            log.debug("发送付款码支付请求: {}", parameters);
            // 发送付款码支付请求
            String returnXml = HttpUtil.post(WechatUrl.PAY_API, requestXml, 10000);

            Map<String, String> returnXmlMap = WXPayUtil.processResponseXml(returnXml);
            // 下单成功标识
            String f_order_state = null;
            if (WXPayUtil.SUCCESS.equals(returnXmlMap.get("result_code"))) {
                result.put("result_msg", "支付确认成功");
                // 交易成功则返回xml数据包
                result.put("returnXml", returnXml);
                f_order_state = "已支付";
            } else {
                String err_code = returnXmlMap.get("err_code");
                String err_code_des = returnXmlMap.get("err_code_des");
                if (WXPayUtil.SYSTEMERROR.equals(err_code) || WXPayUtil.BANKERROR.equals(err_code) || WXPayUtil.USERPAYING.equals(err_code)) {
                    result.put("result_msg", "支付结果未知");
                    result.put("err_code_des", err_code_des);
                    result.put("out_trade_no", parameters.get("out_trade_no"));
                    f_order_state = "待查询";
                } else {
                    result.put("result_msg", "支付确认失败");
                    result.put("err_code_des", err_code_des);
                }
            }
            if (f_order_state != null) {
                JSONObject saveOrder = PayFee.conversionSave(JSONUtil.parseFromMap(returnXmlMap).toString());
                String userFilesId = jsonObject.optString("f_userfiles_id", "");
                saveOrder.put("f_userfiles_id", userFilesId);
                saveOrder.put("f_order_type", "燃气收费");
                saveOrder.put("flag", "WeiXinService");
                saveOrder.put("f_order_state", f_order_state);
                saveOrder.put("f_trade_type", "MICROPAY");
                saveOrder.put("f_filiale", wxConfig.getString("f_filiale"));
                // 保存分公司id
//                JSONObject clientConfig = Config.getClientConfig(filiale);
                saveOrder.put("f_orgid",  wxConfig.getString("f_orgid"));
                logicServer.run("savewxreturnxml", saveOrder);
            }
        } catch (Exception e) {
            log.debug("付款码下单异常", e);
            result.put("result_msg", "支付确认失败");
            result.put("err_msg", e.getMessage());
        }
        log.debug("返回结果"+ result.toString());
        if (result.optString("result_msg","") == "") {
            result.put("result_msg", "支付确认失败");
        }
        return result.toString();
    }

    /**
     * 查询订单
     *
     * @param value (格式: {transaction_id/out_trade_no: "",f_filiale: ""})
     * @return 查询成功返回对应json数据包, 查询失败返回空字符串
     */
    @POST
    @Path("orderStatus")
    @Produces(MediaType.APPLICATION_JSON)
    public String orderStatus(String value) throws Exception {
        String result = "";
        JSONObject json = new JSONObject(value);
        String filiale = json.getString("filiale");
        JSONArray da = sql.query("select * from t_weixinConfig where f_orgid ='"+filiale+"'");
        if (da.length() == 0 || da.length() > 1) {
            throw new RuntimeException("配置表中不存在该分公司配置");
        }
        JSONObject wxConfig  =  da.getJSONObject(0);
        json.put("appid",wxConfig.getString("f_appid"));
        json.put("key",wxConfig.getString("f_api_key"));
        json.put("mchid",wxConfig.getString("f_mchid"));



        log.debug("公司配置:" + wxConfig.toString());
        try {
            result = attachprepay.orderStatus(json.toString());
            JSONObject jsonObject = new JSONObject(result);
            if ("SUCCESS".equals(jsonObject.optString("trade_state"))) {
                String out_trade_no = jsonObject.getString("out_trade_no");
                JSONArray data = sql.query("select id from t_weixinreturnxml where f_out_trade_no = " + out_trade_no);
                if (data.length() == 0 || data.length() > 1) {
                    throw new RuntimeException("中间表不存在此笔订单或存在多条订单");
                }
                JSONObject saveOrder = PayFee.conversionSave(result);
                saveOrder.put("id", data.getJSONObject(0).getInt("id"));
                // 更新中间表
                logicServer.run("savewxreturnxml", saveOrder);
            }
        } catch (Exception e) {
            log.debug("发起查询订单异常", e);
        }
        return result;
    }

    /**
     * 生成扫码支付二维码图片
     *
     * @param resp
     * @param req
     * @throws Exception
     */
    @GET
    @Path("/paintCode")
    public String paintCode(@Context HttpServletResponse resp, @Context HttpServletRequest req) throws Exception {
        resp.setContentType("image/jpeg;charset=utf-8");
        OutputStream output = resp.getOutputStream();
        QRCodeUtil.encode(req.getParameter("QRCODE"), output);
        System.out.println(req.getParameter("QRCODE"));
        output.close();
        return "";
    }

    /**
     * 群发消息
     *
     * @return
     */
    @POST
    @Path("broadcast/{orgname}")
    public String broadcast(String str, @PathParam("orgname") String orgname) {
        String accessToken = token(orgname);
        log.debug("群发消息的accessToken:" + accessToken);
        String url = "https://api.weixin.qq.com/cgi-bin/message/mass/sendall?access_token=" + accessToken;
        log.debug("url: {}", url);
        JSONObject jo = new JSONObject(str);
        String entity = "{\"filter\":{\"is_to_all\": true}, \"mpnews\":{\"media_id\": \"" + jo.getString("media_id") + "\"}, \"msgtype\": \"mpnews\", \"send_ignore_reprint\": 0}";
        log.debug("群发请求体：" + entity);
        cn.hutool.http.HttpResponse res = HttpRequest.post(url).body(entity).execute();
        if (res.getStatus() == 200) {
            String result = res.body();
            log.debug("发送群发消息返回值" + result);
            return result;
        } else {
            return "{\"code\":500}";
        }
    }

    /**
     * 获取菜单
     *
     * @return
     */
    @POST
    @Path("menu/{orgname}")
    public String getmenu(@PathParam("orgname") String orgname) {
        String accessToken = token(orgname);
        log.debug("获取菜单的accessToken:" + accessToken);
        String url = "https://api.weixin.qq.com/cgi-bin/menu/get?access_token=" + accessToken;
        log.debug("获取菜单url:" + url);
        String result = HttpUtil.get(url);
        if (result != null && !"".equals(result)) {
            return result;
        } else {
            return "{\"code\":500}";
        }
    }

    /**
     * 保存菜单
     *
     * @return
     */
    @POST
    @Path("create/menu/{orgname}")
    public String createenu(String str, @PathParam("orgname") String orgname) {
        String accessToken = token(orgname);
        log.debug("保存菜单的accessToken:" + accessToken);
        String url = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=" + accessToken;
        log.debug("保存菜单url:" + url);
        JSONObject obj = new JSONObject(str);
        log.debug("收到的参数转化为json-->" + obj);
        String result = HttpUtil.post(url, obj.toString());
        if (result != null && !"".equals(result)) {
            log.debug("获取菜单项" + result);
            return result;
        } else {
            return "{\"code\":500}";
        }
    }

    /**
     * 获取素材列表
     *
     * @param type
     * @param offset
     * @param count
     * @return
     */
    @POST
    @Path("material/{type}/{offset}/{count}/{orgname}")
    public String getmaterial(@PathParam("type") String type, @PathParam("offset") int offset, @PathParam("count") String count, @PathParam("orgname") String orgname) {
        String accessToken = token(orgname);
        log.debug("获取素材列表的accessToken:" + accessToken);
        String url = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=" + accessToken;
        log.debug("获取素材列表url:" + url);
        String result = HttpUtil.post(url, "{\"type\":\"" + type + "\",\"offset\":" + offset + ", \"count\":" + count + "}");
        if (result != null && !"".equals(result)) {
            // 数据太大,去除无用的数据
            JSONObject jsonObject = new JSONObject(result);
            JSONArray jsonArray = jsonObject.getJSONArray("item");
            for (Object o : jsonArray) {
                JSONObject json = (JSONObject) o;
                if (json.has("content")) {
                    JSONArray news_item = json.getJSONObject("content").getJSONArray("news_item");
                    for (Object o1 : news_item) {
                        JSONObject js = (JSONObject) o1;
                        js.remove("content");
                    }
                }
            }
            log.debug("获取素材返回信息" + result);
            return jsonObject.toString();
        } else {
            return "{\"code\":500}";
        }
    }

    /**
     * 获取图片素材
     *
     * @return
     * @throws Exception
     */
    @GET
    @Path("image/material/{mediaId}/{orgname}")
    @Produces("image/jpeg")
    public StreamingOutput getFullImage(@PathParam("mediaId") String mediaId, @PathParam("orgname") String orgname) {
        if (mediaId == null || "".equals(mediaId)) {
            return null;
        }
        return new StreamingOutput() {

            @Override
            public void write(OutputStream outputStream) throws IOException {
                InputStream is = fetchImage(mediaId);
                int nextByte = 0;
                while ((nextByte = is.read()) != -1) {
                    outputStream.write(nextByte);
                }
                outputStream.flush();
                outputStream.close();
                is.close();
            }

            private InputStream fetchImage(String mediaId) throws IOException {
                log.debug("mediaId:" + mediaId);
                String accessToken = token(orgname);
                log.debug("获取图片素材的accessToken:" + accessToken);
                String url = "https://api.weixin.qq.com/cgi-bin/material/get_material?access_token=" + accessToken;
                HttpURLConnection conn = (HttpURLConnection) new URL(url).openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setReadTimeout(20000);
                conn.setConnectTimeout(20000);
                conn.setUseCaches(false);
                conn.connect();
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(
                        conn.getOutputStream(), "UTF-8"), true);
                pw.print("{\"media_id\":\"" + mediaId + "\"}");
                pw.flush();
                InputStream is = conn.getInputStream();
                return is;
            }
        };

    }

    /**
     * 获取永久素材
     *
     * @param mediaId 要获取的素材的media_id
     * @return
     */
    @POST
    @Path("material/{mediaId}/{orgname}")
    public void getmaterialMediaId(@Context HttpServletResponse response, @PathParam("mediaId") String mediaId, @PathParam("orgname") String orgname) {
        String accessToken = token(orgname);
        log.debug("获取永久素材的accessToken:" + accessToken);
        String url = "https://api.weixin.qq.com/cgi-bin/material/get_material?access_token=" + accessToken;
        JSONObject json = new JSONObject();
        json.put("media_id", mediaId);
        log.debug("获取永久素材: {}", mediaId);
        cn.hutool.http.HttpResponse response1 = HttpRequest.post(url).body(json.toString()).execute();
        String header = response1.header(Header.CONTENT_TYPE);
        byte[] bytes = response1.bodyBytes();

        response.setContentType(header);
        response.setStatus(response1.getStatus());
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            outputStream.write(bytes);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
                response1.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }


    /**
     * 更新模板
     *
     * @param
     * @return
     */
    @POST
    @Path("refreshTemp")
    public String refreshTemp() {
        try {
            String url = WechatUrl.GETTEMP_API.replace("ACCESS_TOKEN", AccessToken.getAccessToken());
            String tempResult = HttpUtil.get(url);
            if (tempResult == null) {
                throw new RuntimeException("请求错误！");
            }
            sql.runSQL("delete from t_template");
            log.debug("获取模板列表返回: " + tempResult);
            JSONObject tempobj = new JSONObject(tempResult);
            JSONArray tempArray = tempobj.getJSONArray("template_list");
            for (int i = 0; i < tempArray.length(); i++) {
                JSONObject temp = new JSONObject();
                temp.put("f_template_id", tempArray.getJSONObject(i).getString("template_id"));
                temp.put("f_title", tempArray.getJSONObject(i).getString("title"));
                temp.put("f_data_content", tempArray.getJSONObject(i).getString("content"));
                temp.put("f_example", tempArray.getJSONObject(i).getString("example"));
                entity.partialSave("t_template", temp);
            }
        } catch (Exception e) {
            log.debug("刷新模板错误: ", e);
            return "";
        }
        return "成功";
    }

    /**
     * 多分公司更新模板
     *
     * @param
     * @return
     */
    @POST
    @Path("autoRefreshTemplate")
    public String autoRefreshTemplate() {

        try {
            for (Map.Entry<String, String> entry : AccessToken.accessTokenMap.entrySet()) {
                // 获取各个分公司的模板
                String url = null;
                try{
                    log.debug("qwq:" + entry.getValue() );
                    if ("".equals(entry.getValue())){
                        continue;
                    }
                    url = WechatUrl.GETTEMP_API.replace("ACCESS_TOKEN", entry.getValue());
                }catch (Exception e){
                    log.debug("请求链接错误: ", e);
                }
                String tempResult = HttpUtil.get(url);
                if (tempResult == null) {
                    throw new RuntimeException("请求错误！");
                }
                String filiale = entry.getKey().substring(entry.getKey().lastIndexOf("_") + 1);
                JSONObject wxConfig = Config.getClientConfig(filiale);
                String  orgid = wxConfig.getString("orgStr");
                sql.runSQL("delete from t_template where f_orgid = '" + orgid + "'");
                log.debug("获取模板列表返回: " + tempResult);
                JSONObject tempobj = new JSONObject(tempResult);
                JSONArray tempArray = tempobj.getJSONArray("template_list");
                for (int i = 0; i < tempArray.length(); i++) {
                    JSONObject temp = new JSONObject();
                    temp.put("f_template_id", tempArray.getJSONObject(i).getString("template_id"));
                    temp.put("f_title", tempArray.getJSONObject(i).getString("title"));
                    temp.put("f_data_content", tempArray.getJSONObject(i).getString("content"));
                    temp.put("f_example", tempArray.getJSONObject(i).getString("example"));
                    temp.put("f_orgid", orgid);
                    temp.put("f_orgname", filiale);
                    entity.partialSave("t_template", temp);
                }
            }
        }catch (Exception e) {
            log.debug("刷新模板错误: ", e);
            return "失败";
        }
        return "成功";
    }

    /**
     * pos调用生成缴费推送数据
     *
     * @param （参数格式{sellingGas_id: ""}）
     * @return
     */
    @POST
    @Path("posMsgPush")
    public String posMsgPush(String value) {
        JSONObject json = new JSONObject();
        try {
            JSONObject jsonData = new JSONObject(value);
            String sellingGasId = jsonData.getString("sellingGas_id");
            // 查询该订单的收费记录
            JSONArray sellingGasInfo = sql.query("SELECT id FROM t_sellinggas where id = '" + sellingGasId + "'and f_charge_state = '有效'");
            log.debug("收费记录信息--------》:" +  sellingGasInfo.toString());
            if (sellingGasInfo.length() <= 0) {
                log.debug("没有查询收费信息, 推送结束!!!");
                json.put("msg", "推送失败");
                return json.toString();
            }
            // 分公司id获取模板信息
            String orgid = sellingGasInfo.getJSONObject(0).getString("f_filialeids");
            JSONArray templateInfo = sql.query("SELECT * FROM t_template where f_orgid = '" + orgid + "'");
            if (templateInfo.length() != 1) {
                log.debug("模板信息数量不正确: {}, 推送结束!!!", templateInfo.length());
                json.put("msg", "推送失败");
                return json.toString();
            }
            // 通过模板id查询对应的表达式
            String templateId =templateInfo.getJSONObject(0).getString("f_template_id");

            JSONArray templateExpression = sql.query("select * from t_template_expression where f_template_id = '" + templateId + "'");
            if (templateExpression.length() <= 0) {
                log.debug("没有查询到表达式信息, 推送结束!!!");
                json.put("msg", "推送失败");
                return json.toString();
            }
            String url = "";
            for (int i = 0; i < templateExpression.length(); i++) {
                JSONObject row = templateExpression.getJSONObject(i);
                String val = row.optString("f_value");
                String key = row.getString("f_key");
                boolean nullValue = !"url".equals(key) && (val == null || "".equals(val));
                if (nullValue) {
                    log.debug("表达式{}的内容为空, 推送结束!!!", key);
                    json.put("msg", "推送失败");
                    return json.toString();
                }
                if ("url".equals(key)) {
                    url = value;
                }
            }
            String msgPushItem = getMsgPushItem(templateExpression.toString());
            JSONObject pushParams = new JSONObject();
            pushParams.put("sql", "getTemplatePush");
            pushParams.put("params", new JSONObject());
            pushParams.put("filiale", templateInfo.getJSONObject(0).getString("f_orgname"));
            log.debug("表达式组织完成: {}", msgPushItem);
            log.debug("url: {}", url);
            JSONObject params = new JSONObject();
            JSONObject tempInfo = new JSONObject();
            tempInfo.put("f_send_type", "缴费通知");
            tempInfo.put("f_template_id", templateId);
            tempInfo.put("f_url", url);
            String pushNumber = WxSign.getNonceStr();
            tempInfo.put("f_push_number", pushNumber);
            params.put("sql", "posMsgPush");
            params.put("dataStr", msgPushItem);
            JSONObject sqlParams = new JSONObject();
            sqlParams.put("condition", sellingGasId);
            params.put("params", sqlParams);
            params.put("tempInfo", tempInfo);
            log.debug("本次生成推送数据随机编号: {}", pushNumber);
            // 插入推送数据
            int num = Integer.parseInt(msgpushDate(params.toString()));
            log.debug("本次生成推送数据数量: {}", num);
            JSONObject params1 = pushParams.getJSONObject("params");
            // 加入推送表查询条件
            params1.put("condition", "f_push_number = '" + pushNumber + "'");
            // 调起推送
            msgPush(pushParams.toString());

        }catch (Exception e){
            log.debug("推送失败：" + e.getMessage());
            json.put("msg", "推送失败");
            return json.toString();
        }
        json.put("msg", "推送成功");
        return json.toString();
    }

    /**
     * 微信缴费推送数据
     *
     * @param （参数格式{sellingGas_id: ""}）
     * @return
     */
    @POST
    @Path("wxPayMsgPush")
    public String wxPayMsgPush(String value) {
        JSONObject json = new JSONObject();
        try {
            JSONObject jsonData = new JSONObject(value);
            String sellingGasId = jsonData.getString("sellingGas_id");
            // 查询该订单的收费记录
            JSONArray sellingGasInfo = sql.query("SELECT id FROM t_sellinggas where id = '" + sellingGasId + "'and f_state = '有效'");
            log.debug("收费记录信息--------》:" +  sellingGasInfo.toString());
            if (sellingGasInfo.length() <= 0) {
                log.debug("没有查询收费信息, 推送结束!!!");
                json.put("msg", "推送失败");
                return json.toString();
            }
            // 分公司id获取模板信息
            String template_id = jsonData.getString("template_id");
            JSONArray templateInfo = sql.query("SELECT * FROM t_template where f_template_id = '" + template_id + "'");
            if (templateInfo.length() != 1) {
                log.debug("模板信息数量不正确: {}, 推送结束!!!", templateInfo.length());
                json.put("msg", "推送失败");
                return json.toString();
            }
            // 通过模板id查询对应的表达式
            String templateId =templateInfo.getJSONObject(0).getString("f_template_id");

            JSONArray templateExpression = sql.query("select * from t_template_expression where f_template_id = '" + templateId + "'");
            if (templateExpression.length() <= 0) {
                log.debug("没有查询到表达式信息, 推送结束!!!");
                json.put("msg", "推送失败");
                return json.toString();
            }
            String url = "";
            for (int i = 0; i < templateExpression.length(); i++) {
                JSONObject row = templateExpression.getJSONObject(i);
                String val = row.optString("f_value");
                String key = row.getString("f_key");
                boolean nullValue = !"url".equals(key) && (val == null || "".equals(val));
                if (nullValue) {
                    log.debug("表达式{}的内容为空, 推送结束!!!", key);
                    json.put("msg", "推送失败");
                    return json.toString();
                }
                if ("url".equals(key)) {
                    url = value;
                }
            }
            String msgPushItem = getMsgPushItem(templateExpression.toString());
            JSONObject pushParams = new JSONObject();
            pushParams.put("sql", "getTemplatePush");
            pushParams.put("params", new JSONObject());
            pushParams.put("filiale", templateInfo.getJSONObject(0).getString("f_orgname"));
            log.debug("表达式组织完成: {}", msgPushItem);
            log.debug("url: {}", url);
            JSONObject params = new JSONObject();
            JSONObject tempInfo = new JSONObject();
            tempInfo.put("f_send_type", "缴费成功提醒");
            tempInfo.put("f_template_id", templateId);
            tempInfo.put("f_url", url);
            String pushNumber = WxSign.getNonceStr();
            tempInfo.put("f_push_number", pushNumber);
            params.put("sql", "WeiXinMsgPush");
            params.put("dataStr", msgPushItem);
            JSONObject sqlParams = new JSONObject();
            sqlParams.put("condition", sellingGasId);
            params.put("params", sqlParams);
            params.put("tempInfo", tempInfo);
            log.debug("本次生成推送数据随机编号: {}", pushNumber);
            // 插入推送数据
            int num = Integer.parseInt(msgpushDate(params.toString()));
            log.debug("本次生成推送数据数量: {}", num);
            JSONObject params1 = pushParams.getJSONObject("params");
            // 加入推送表查询条件
            params1.put("condition", "f_push_number = '" + pushNumber + "'");
            // 调起推送
            msgPush(pushParams.toString());

        }catch (Exception e){
            log.debug("推送失败：" + e.getMessage());
            json.put("msg", "推送失败");
            return json.toString();
        }
        json.put("msg", "推送成功");
        return json.toString();
    }

    /**
     * 获取模板信息需要的字段，组装成string格式
     *
     * @param expression
     * @return 返回拼接的字符串
     */
    @POST
    @Path("getmsgpushItem")
    public String getMsgPushItem(String expression) {
        JSONArray exp = new JSONArray(expression);
        String dataType = Config.wechatConfig.getString("dataType");
        String str = "'{";
        for (int i = 0; i < exp.length(); i++) {
            JSONObject row = exp.getJSONObject(i);
            if (!"url".equals(row.getString("f_key"))) {
                String temp = row.getString("f_value");
                String mark = row.optString("f_mark","#173177");
                if (temp.contains("<")) {
                    if ("oracle".equals(dataType)) {
                        temp = temp.replace("<", "'||");
                    } else {
                        temp = temp.replace("<", "'+");
                    }
                }
                if (temp.contains(">")) {
                    if ("oracle".equals(dataType)) {
                        temp = temp.replace(">", "||'");
                    } else {
                        temp = temp.replace(">", "+'");
                    }
                }
                if ("'{".equals(str)) {
                    str = str + "\"" + row.getString("f_key") + "\":{\"value\":\"" + temp + "\",\"color\":\""+mark+"\"}";
                } else {
                    str = str + ",\"" + row.getString("f_key") + "\":{\"value\":\"" + temp + "\",\"color\":\""+mark+"\"}";
                }
            }
        }
        str += "}'";
        return str;
    }


    /**
     * 生成推送的消息并存入消息推送表（t_template_push）中
     *
     * @param temp {dataStr,condition,tempInfo}消息串、条件、模板信息
     * @return 存入个数
     */
    @POST
    @Path("msgpushDate")
    public String msgpushDate(String temp) {
        int num = 0;
        try {
            JSONObject tempobj = new JSONObject(temp);
            JSONObject param = tempobj.getJSONObject("params");
            Map<String, Object> params = new HashMap<>();
            Iterator<String> iterator = param.keys();
            while (iterator.hasNext()) {
                String key = (String) iterator.next();
                Object value = param.get(key);
                params.put(key, value);
            }

            // 获取编译后的sql语句
            String sqlName = tempobj.getString("sql");
            String path = SqlMapper.getSql(sqlName);
            if (path == null) {
                throw new RuntimeException("sql语句未注册！" + sqlName);
            }
            String sql2 = null;
            try {
                sql2 = ResourceHelper.getString(path);
            } catch (FileNotFoundException e) {
                throw new RuntimeException(path + ".文件无配置");
            } catch (IOException io) {
                throw new RuntimeException(io);
            }
            String url = null;
            if (tempobj.getJSONObject("tempInfo").getString("f_url").equals("")) {
                url = "\'\'";
            } else {
                url = "'" + tempobj.getJSONObject("tempInfo").getString("f_url") + "'";
            }
            // 获取编译后的sql语句
            sql2 = sql2.replace("\r\n", "\n");
            String dataType = Config.wechatConfig.getString("dataType");
            if (!"oracle".equals(dataType)) {
                sql2 = sql2.replace("select * from", "select top 99999999 * from ");
            }
            sql2 = "$" + sql2;
            // 把自身注册到执行环境中
            params.put("sql", this);
            params.put("entity", entityServer);
            sql2 = ExpressionHelper.run(sql2, params).toString();

            String sql1 = "insert into t_template_push (f_open_id,f_user_name,f_userinfo_id,f_userfiles_id,f_template_id,f_url,f_data,f_send_state,f_fail_cause,f_send_date,f_send_type,f_push_number)\n " +
                    "select  f_open_id,f_user_name,f_userinfo_id,f_userfiles_id,\n'" +
                    tempobj.getJSONObject("tempInfo").getString("f_template_id") + "' f_template_id,\n" +
                    url + " f_url,\n" +
                    tempobj.getString("dataStr") + " f_data,\n" +
                    " '未推送' f_send_state,null f_fail_cause,null f_send_date,'" + tempobj.getJSONObject("tempInfo").getString("f_send_type") + "' f_send_type,'" +
                    tempobj.getJSONObject("tempInfo").optString("f_push_number") + "' f_push_number\n" +
                    "from (\n";
            sql1 = sql1 + sql2 + ")t";
            log.debug("插入推送数据sql: " + sql1);
            num = sql.runSQL(sql1);
        } catch (Exception e) {
            log.debug("生成推送数据失败", e);
            throw new RuntimeException();
        }
        return num + "";
    }


    /**
     * 生成推送的消息并存入消息推送表（t_template_push）中
     *
     * @param temp {dataStr,tempInfo}消息串、条件、模板信息
     * @return 存入个数
     */
    @POST
    @Path("msgpushDateAll")
    public String msgpushDateAll(String temp) {
        JSONObject tempobj = new JSONObject(temp);
        String url;
        if (tempobj.getJSONObject("tempInfo").getString("f_url").equals("")) {
            url = "\'\'";
        } else {
            url = "'" + tempobj.getJSONObject("tempInfo").getString("f_url") + "'";
        }

        String sql1 = "insert into t_template_push (f_open_id,f_user_name,f_userinfo_id,f_userfiles_id,f_template_id,f_url,f_data,f_send_state,f_fail_cause,f_send_date,f_send_type) " +
                "\n values ('所有关注公众号用户','','','', " +
                "\n'" + tempobj.getJSONObject("tempInfo").getString("f_template_id") + "'," +
                "\n" + url + "," + tempobj.getString("dataStr") + ",'未推送'," +
                "null,null,'" + tempobj.getJSONObject("tempInfo").getString("f_send_type") + "')";
        int num = sql.runSQL(sql1);
        return num + "";
    }


    /**
     * 推送消息
     *
     * @param temp row
     * @return 推送请求是否发送成功
     */
    @POST
    @Path("msgPush")
    public String msgPush(String temp) {
        try {
            JSONObject jsonObject = new JSONObject(temp);
            String sql = jsonObject.getString("sql");
            JSONObject params = jsonObject.getJSONObject("params");
            String filiale = jsonObject.getString("filiale");
            // 取分公司配置
            JSONObject config = Config.getConfig(filiale);
            String appId = config.getString("appId");
            String appSecret = config.getString("appSecret");
            JSONObject param = new JSONObject();
            param.put("sql", sql);
            param.put("params", params);
            param.put("appId", appId);
            param.put("appSecret", appSecret);
            if (jsonObject.has("isall")) {
                param.put("isAll", jsonObject.getBoolean("isall"));
            }
            // 推送服务地址
            String weixinPush = Config.wechatConfig.getString("weixinPush");
            log.debug("发送推送请求: " + param.toString());
            String encoding = System.getProperty("file.encoding");
            log.debug("Default System Encoding:" + encoding);
            // 指定请求头
            JSONObject headers = new JSONObject();
            headers.put("Content-Type", "application/json;charset=UTF-8");
            // 异步请求
            DefaultAsyncTools defaultAsyncTools=new DefaultAsyncTools();
            defaultAsyncTools.postAsync(weixinPush + "rs/logic/weixin_temp_msg_push", param, headers, false);
        } catch (Exception e)
        {
            log.debug("发送推送请求错误: ", e);
            throw new WebException(500, e.getMessage());
        }
        return "推送请求发送成功";
    }

    /**
     * 推送消息
     *
     *  @param value（参数格式{filiale: "",template_id: ""}）
     * @return 推送请求是否发送成功
     */
    @POST
    @Path("msgPushByTemplateId")
    public String msgPushByTemplateId(String value) {
        try {
            JSONObject jsonObject = new JSONObject(value);
            // 推送表消息模板主键id
            String template_id = jsonObject.getString("template_id");
            String filiale = jsonObject.getString("filiale");
            // 取分公司配置
            JSONObject config = Config.getConfig(filiale);
            String appId = config.getString("appId");
            String appSecret = config.getString("appSecret");
            JSONObject param = new JSONObject();
            JSONObject condition = new JSONObject();
            condition.put("condition", "id = " + template_id);
            param.put("sql", "getTempMsgInfoByTemplateId");
            param.put("params", condition);
            param.put("appId", appId);
            param.put("appSecret", appSecret);
            if (jsonObject.has("isall")) {
                param.put("isAll", jsonObject.getBoolean("isall"));
            }
            // 推送服务地址
            String weixinPush = Config.wechatConfig.getString("weixinPush");
            log.debug("发送推送请求: " + param.toString());
            String encoding = System.getProperty("file.encoding");
            log.debug("Default System Encoding:" + encoding);
            // 指定请求头
            JSONObject headers = new JSONObject();
            headers.put("Content-Type", "application/json;charset=UTF-8");
            // 异步请求
            DefaultAsyncTools defaultAsyncTools = new DefaultAsyncTools();
            defaultAsyncTools.postAsync(weixinPush + "rs/logic/weixin_temp_msg_push", param, headers, false);
        } catch (Exception e) {
            log.debug("发送推送请求错误: ", e);
            throw new WebException(500, e.getMessage());
        }
        return "推送请求发送成功";
    }


    /**
     * ERP凭证删除
     *
     */
    @POST
    @Path("ERPDocumentDelete")
    public String ERPDocumentDelete(String value) {
        log.debug("ERP删除接口参数: "+ value);
        JSONObject result = new JSONObject();
        String ErpDeleteUrl = Config.wechatConfig.getString("ErpDeleteUrl");
        try {
            JSONObject jsonObject = new JSONObject(value);
//            String filiale = jsonObject.getString("filiale");
//            JSONObject config = Config.getConfig(filiale);
//            String orgid = jsonObject.getString("orgid");
            String f_year_no =  jsonObject.getString("f_year_no");
            String f_fail_cause = jsonObject.getString("f_fail_cause");
            String no_from = jsonObject.getString("f_no");
            String no_to = jsonObject.getString("f_no");
            String f_glorgbook_code = jsonObject.getString("f_glorgbook_code");
            String prepareddate_from = jsonObject.getString("f_prepareddate");
            JSONObject body = new JSONObject();

            Calendar localTime = Calendar.getInstance();
            int x = localTime.get(Calendar.YEAR);
            body.put("no_from",no_from);
            body.put("no_to",no_to);
            body.put("page_now","1");
            body.put("page_size","5");
            body.put("pk_glorgbook",f_glorgbook_code);
            body.put("prepareddate_from",prepareddate_from);
            body.put("prepareddate_to", x + "-12" + "-31");
            log.debug("ERP凭证删除参数: ");
            log.debug(body.toString());
            CloseableHttpClient client = null;
            CloseableHttpResponse response = null;
            String res = null;
            //  http://219.151.35.147:9090/u8cloud/api/gl/voucher/delete
            HttpPost httpPost = new HttpPost(ErpDeleteUrl);
            StringEntity entityParams = new StringEntity(body.toString(), "utf-8");
            httpPost.setEntity(entityParams);
            httpPost.addHeader("Content-Type", "application/json;charset=UTF-8");
            httpPost.addHeader("usercode", "demo");
            httpPost.addHeader("password", "b91f132a1529e7e78591e3caf4ab419d");
            httpPost.addHeader("trantype", "code");
            httpPost.addHeader("system", "systest");
            client = HttpClients.createDefault();
            response = client.execute(httpPost);

            res =  EntityUtils.toString(response.getEntity());
            log.debug("请求结果：" + res);
            result = new JSONObject(res);
            log.debug("请求结果：" + result);
            log.debug("请求结果：" + result.getString("status"));
            if ("success".equals(result.getString("status"))) {
                sql.runSQL("update t_sellinggas set f_evidence_state = '无效', f_glorgbook_no = '' where f_glorgbook_no ='"+f_year_no+"'");
                sql.runSQL("update t_erp_evidence set f_state = '无效',f_fail_cause = '"+f_fail_cause+"' where f_year_no ='"+f_year_no+"'");
            }
        }
        catch (Exception e) {
            result.put("status","falied");
            result.put("errormsg",e);
            log.debug("ERP凭证删除失败: ", e);
            throw new WebException(500, e.getMessage());
        }

        return result.toString();
    }
    /**
     * ERP凭证作废
     *
     */
    @POST
    @Path("ERPDocumentAbandon")
    public String ERPDocumentAbandon(String value) {
        log.debug("ERP作废接口参数: "+ value);
        JSONObject result = new JSONObject();
        String ErpAbandonUrl = Config.wechatConfig.getString("ErpAbandonUrl");
        try {
            JSONObject jsonObject = new JSONObject(value);
            String filiale = jsonObject.optString("filiale","");
            // 取分公司配置
            JSONObject config = Config.getClientConfig(filiale);
            String f_year_no =  jsonObject.getString("f_year_no");
            //原因
            String f_fail_cause = jsonObject.getString("f_fail_cause");
            //结束
            int no = jsonObject.getInt("f_no");
            //会计主体账簿编码
            String f_glorgbook_code = jsonObject.getString("f_glorgbook_code");
            String pk_voucher = jsonObject.getString("pk_voucher");
            JSONObject bill = new JSONObject();
            JSONObject body = new JSONObject();
            JSONArray bills = new JSONArray();
            bill.put("no",no);
            //会计主体账簿编码
            bill.put("glorgbook_code",f_glorgbook_code);
            //vouchertype_code 凭证类别简称
            bill.put("vouchertype_code","记账");
            bill.put("pk_voucher",pk_voucher);
            //作废人编码
            bill.put("abandoner_code",config.getString("pk_prepared"));
            bills.put(bill);
            body.put("bills",bills);
            log.debug("ERP凭证作废参数: {}",body);
            CloseableHttpClient client = null;
            CloseableHttpResponse response = null;
            String res = null;
            HttpPost httpPost = new HttpPost(ErpAbandonUrl);
            StringEntity entityParams = new StringEntity(body.toString(), "utf-8");
            httpPost.setEntity(entityParams);
            httpPost.addHeader("Content-Type", "application/json;charset=UTF-8");
            httpPost.addHeader("usercode", "demo");
            httpPost.addHeader("password", "b91f132a1529e7e78591e3caf4ab419d");
            httpPost.addHeader("trantype", "code");
            httpPost.addHeader("system", "systest");
            client = HttpClients.createDefault();
            response = client.execute(httpPost);

            res =  EntityUtils.toString(response.getEntity());
            log.debug("请求结果：" + res);
            result = new JSONObject(res);
            log.debug("请求结果：" + result);
            log.debug("请求结果：" + result.getString("status"));
            if ("success".equals(result.getString("status"))) {
                sql.runSQL("update t_sellinggas set f_evidence_state = '作废', f_glorgbook_no = '' where f_glorgbook_no ='"+f_year_no+"'");
                sql.runSQL("update t_erp_evidence set f_state = '作废', f_prepareddate = CONVERT(varchar(100), GETDATE(), 20), f_f_fail_cause = '"+f_fail_cause+"' where f_year_no ='"+f_year_no+"'");
            }
        }
        catch (Exception e) {
            result.put("status","falied");
            result.put("errormsg",e);
            log.debug("ERP凭证作废失败: ", e);
            throw new WebException(500, e.getMessage());
        }

        return result.toString();
    }
    /**
     * ERP凭证生成
     *
     */
    @POST
    @Path("ERPDocumentGeneration")
    public String ERPDocumentGeneration(String value) {
        log.debug("ERP接口参数: "+ value);
        JSONObject result = new JSONObject();
        Calendar calendar = Calendar.getInstance();
        String ErpInsertUrl = Config.wechatConfig.getString("ErpInsertUrl");
        try {
            JSONObject jsonObject = new JSONObject(value);
            String filiale = jsonObject.optString("filiale","");
            String f_operator = jsonObject.optString("f_operator","");
            String orgid = jsonObject.optString("orgid","");
            String condition = jsonObject.getString("condition");
            // 取分公司配置
            JSONObject config = Config.getClientConfig(filiale);
            JSONArray voucher = new JSONArray();
            JSONObject vouch = new JSONObject();

            JSONArray details =new JSONArray();
            JSONArray ass = new JSONArray();
            JSONObject as = new JSONObject();
            JSONArray cashflow = new JSONArray();
            //  JSONObject pk_accsubj  = config.getJSONObject("pk_accsubj");

            JSONArray jsonArray =  jsonObject.getJSONArray("f_details");
            //辅助核算类型编码
            as.put("checktypecode","73");
            //辅助核算的值编码
            as.put("checkvaluecode", "00010");
            ass.put(as);
            DecimalFormat df = new DecimalFormat("#.00");
            for (int i = 0; i<jsonArray.length(); i++ ) {
                JSONObject json = jsonArray.getJSONObject(i);
                String f_amount_rate = String.valueOf(CommonTools.div(json.getString("f_amount_rate"),100));
                String money  =  String.valueOf(df.format(CommonTools.mul(json.getString("money"),f_amount_rate)));
                jsonArray.getJSONObject(i).put("money",money);
                String pk_cashflow = json.optString("f_cashflow","");
                JSONObject cashf  = new JSONObject();
                //原币金额
                cashf.put("money",money);
                //现金流量表项编码 1111 收款
                //现金流量表项编码 1123 手续费
                cashf.put("pk_cashflow", pk_cashflow);
                cashflow.put(cashf);
            }
            //先加入1-2个credit
            for (int i = 0; i < jsonArray.length(); i++ ) {
                JSONObject detail = new JSONObject();
                //原币贷方金额
                detail.put("creditamount",  jsonArray.getJSONObject(i).getString("money"));
                //凭证摘要 微信公证号收款
                detail.put("explanation", jsonArray.getJSONObject(i).getString("f_explanation"));
                //本币贷方金额
                detail.put("localcreditamount", jsonArray.getJSONObject(i).getString("money"));
                //科目 220501 100201 660301  100201
                detail.put("pk_accsubj",jsonArray.getJSONObject(i).getString("f_loan_accsubj"));
                //币种编码 CNY
                detail.put("pk_currtype","CNY");
                if ( i == 0) {
                    //辅助核算
                    detail.put("ass",ass);
                    //现金流量
                    detail.put("cashflow",cashflow);
                } else  {
                    detail.put("ass",new JSONArray());
                    detail.put("cashflow",new JSONArray());
                }
                details.put(detail);
            }
            //再加入1-2个debit
            for (int i = 0; i < jsonArray.length(); i++ ) {
                JSONObject detail = new JSONObject();
                detail.put("debitamount",  jsonArray.getJSONObject(i).getString("money"));
                detail.put("explanation", jsonArray.getJSONObject(i).getString("f_explanation"));
                detail.put("localdebitamount", jsonArray.getJSONObject(i).getString("money"));
                detail.put("pk_accsubj",jsonArray.getJSONObject(i).getString("f_lend_accsubj"));
                detail.put("pk_currtype","CNY");
                detail.put("ass",new JSONArray());
                detail.put("cashflow",new JSONArray());
                details.put(detail);
            }
            //分录
            vouch.put("details",details);
            //
            vouch.put("pk_corp",config.getString("pk_corp"));//"1001"
            vouch.put("pk_glorgbook",config.getString("pk_glorgbook"));//"1001-2018E"
            vouch.put("pk_prepared",config.getString("pk_prepared"));//18108900337
            vouch.put("pk_vouchertype",config.getString("pk_vouchertype"));//记账
            voucher.put(vouch);
            JSONObject body = new JSONObject();
            body.put("voucher",voucher);
            log.debug("ERP凭证参数: ");
            log.debug(body.toString());
            CloseableHttpClient client = null;
            CloseableHttpResponse response = null;
            String res = null;
            //http://219.151.35.147:9090/u8cloud/api/gl/voucher/insert
            HttpPost httpPost = new HttpPost(ErpInsertUrl);
            StringEntity entityParams = new StringEntity(body.toString(), "utf-8");
            httpPost.setEntity(entityParams);
            httpPost.addHeader("Content-Type", "application/json;charset=UTF-8");
            httpPost.addHeader("usercode", config.getString("usercode"));//"demo"
            httpPost.addHeader("password",  config.getString("password"));//b91f132a1529e7e78591e3caf4ab419d
            httpPost.addHeader("trantype", config.getString("trantype"));//code
            httpPost.addHeader("system",  config.getString("system"));//systest
            client = HttpClients.createDefault();
            response = client.execute(httpPost);

            res =  EntityUtils.toString(response.getEntity());
            log.debug("请求结果：" + res);
            result = new JSONObject(res);
            log.debug("请求结果：" + result);
            log.debug("请求结果：" + result.getString("status"));
            if ("success".equals(result.getString("status"))) {
                JSONObject data = new JSONArray(result.getString("data")).getJSONObject(0);
                data.put("condition",condition);
                data.put("f_orgid",orgid);
                data.put("f_operator",f_operator);
                data.put("yearNo", String.valueOf(calendar.get(Calendar.YEAR))+data.getString("no"));
                logicServer.run("saveErpEvidence", data);
                result.remove("data");
            }
        }
        catch (Exception e) {
            result.put("status","falied");
            result.put("errormsg",e);
            log.debug("ERP凭证生成失败: ", e);
            throw new WebException(500, e.getMessage());
        }
        return result.toString();
    }
}
