package com.jonnyliu.proj.wechat.message.request;

import com.jonnyliu.proj.wechat.enums.EventType;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import lombok.Data;

/**
 * 订阅(取消订阅)的消息封装
 * Created by liujie-ds8 on 2016/8/5.
 */
@Data
@XStreamAlias("xml")
public class UnsubscribeEventRequestMessage extends EventRequestMessage {

    /**
     * 事件KEY值
     */
    @XStreamAlias("EventKey")
    private String eventKey;

    @Override
    public String getEvent() {
        return EventType.EVENT_UNSUBSCRIBE.getTypeStr();
    }
}
