package com.jonnyliu.proj.wechat.handle;

import cn.hutool.json.JSONObject;
import cn.hutool.json.XML;
import com.af.plugins.JsonTools;
import com.aote.logic.LogicServer;
import com.jonnyliu.proj.wechat.annotation.MessageProcessor;
import com.jonnyliu.proj.wechat.enums.MessageType;
import com.jonnyliu.proj.wechat.handler.AbstractMessageHandler;
import com.jonnyliu.proj.wechat.message.request.BaseRequestMessage;
import com.jonnyliu.proj.wechat.message.request.VoiceRequestMessage;
import com.jonnyliu.proj.wechat.message.response.BaseResponseMessage;
import com.jonnyliu.proj.wechat.utils.MessageUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: JoeCdy
 * @Description: 语音消息处理器
 * @Date: Created in 15:30 2023/4/3
 */
@Slf4j
@Component
@MessageProcessor(messageType = MessageType.VOICE_MESSAGE)
public class VoiceMessageHandler extends AbstractMessageHandler {

    @Autowired
    private LogicServer logicServer;

    @Override
    public BaseResponseMessage doHandleMessage(BaseRequestMessage baseRequestMessage) {
        VoiceRequestMessage voiceRequestMessage = (VoiceRequestMessage) baseRequestMessage;
        String xml = MessageUtils.toXml(voiceRequestMessage);
        JSONObject jsonObject = XML.toJSONObject(xml);
        try {
            org.json.JSONObject result = JsonTools.convertToJson(String.valueOf(logicServer.run("VoiceMessageHandler", jsonObject.get("xml").toString())));
            // 是否需要直接回复
            String reply = result.optString("reply");
            if (!"".equals(reply)) {
                return MessageUtils.buildTextResponseMessage(baseRequestMessage, reply);
            }
        } catch (Exception e) {
            log.info("语音消息处理器异常:", e);
        }
        return null;
    }
}
