package com.jonnyliu.proj.wechat.handle;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.XML;
import com.af.plugins.JsonTools;
import com.aote.logic.LogicServer;
import com.aote.util.AccessToken;
import com.aote.sql.SqlServer;
import com.jonnyliu.proj.wechat.annotation.MessageProcessor;
import com.jonnyliu.proj.wechat.enums.MessageType;
import com.jonnyliu.proj.wechat.handler.AbstractMessageHandler;
import com.jonnyliu.proj.wechat.message.request.BaseRequestMessage;
import com.jonnyliu.proj.wechat.message.request.TextRequestMessage;
import com.jonnyliu.proj.wechat.message.response.BaseResponseMessage;
import com.jonnyliu.proj.wechat.utils.MessageUtils;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: JoeCdy
 * @Description: 文本消息处理器
 * @Date: Created in 14:42 2020/4/15
 */
@Slf4j
@Component
@MessageProcessor(messageType = MessageType.TEXT_MESSAGE)
public class TextMessageHandler extends AbstractMessageHandler {

    @Autowired
    private SqlServer sqlServer;

    @Autowired
    private LogicServer logicServer;

    @Override
    public BaseResponseMessage doHandleMessage(BaseRequestMessage baseRequestMessage) {
        TextRequestMessage textRequestMessage = (TextRequestMessage) baseRequestMessage;
        String xml = MessageUtils.toXml(textRequestMessage);
        cn.hutool.json.JSONObject jsonObject = XML.toJSONObject(xml);
        try {
            org.json.JSONObject result = JsonTools.convertToJson(String.valueOf(logicServer.run("TextMessageHandler", jsonObject.get("xml").toString())));
            // 是否需要直接回复
            String reply = result.optString("reply");
            if (!"".equals(reply)) {
                return MessageUtils.buildTextResponseMessage(baseRequestMessage, reply);
            }
        } catch (Exception e) {
            log.info("文本消息处理器异常:", e);
        }
        return null;
//        // 用户发送过来的文本消息
//        String content = textRequestMessage.getContent();
//        // 进行关键字匹配
//        JSONObject jsonObject = this.keywordProcess(content);
//        // 匹配上了
//        if (jsonObject != null) {
//            // 需要给用户回复的消息
//            String f_autoreply_info = jsonObject.getString("f_autoreply_info");
//            // 判断回复的消息类型
//            if ("text".equals(jsonObject.getString("f_type"))) {
//                // 回复文本
//                return MessageUtils.buildTextResponseMessage(baseRequestMessage, f_autoreply_info);
//            } else {
//                // 回复图文消息, 使用客服接口发送素材
//                //language=JSON
//                String s = "{\n" +
//                        "  \"touser\": \"" + textRequestMessage.getFromUserName() + "\",\n" +
//                        "  \"msgtype\":\"mpnews\",\n" +
//                        "  \"mpnews\":{\n" +
//                        "    \"media_id\":\"" + f_autoreply_info + "\"\n" +
//                        "  }\n" +
//                        "}";
//                System.out.println(s);
//                String post = HttpUtil.post("https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + AccessToken.getAccessToken(), s);
//                log.info("使用客服接口发送图文消息返回: {}", post);
//                return null;
//            }
//        }
//        // 关键字没有匹配上, 先回复默认消息
//        // TODO 后续要优化
//        String defText = "感谢您的关注，此公众号暂没有客服人工回复，如有问题请查看公众号内相应菜单介绍，或拨打客服电话0319-5995110进行咨询，谢谢合作！";
//        return MessageUtils.buildTextResponseMessage(baseRequestMessage, defText);
    }

    /**
     * 关键字匹配
     * @param keyword 接收到用户发送的文本消息
     * @return 正确匹配返回:{f_type: "",f_autoreply_info: ""}回复类型和回复内容, 未匹配上返回null
     */
    public JSONObject keywordProcess(String keyword) {
        JSONObject result = null;
        try {
            JSONArray query = sqlServer.query("select * from t_keywordreply where f_state = '启用'");
            for (Object o : query) {
                JSONObject row = (JSONObject) o;
                String f_keyword = row.getString("f_keyword");
                String f_type = row.getString("f_type");
                String f_autoreply_info = row.getString("f_autoreply_info");
                result = new JSONObject();
                if ("equal".equals(row.getString("f_match_mode")) && keyword.equals(f_keyword)) {
                    // 全匹配
                    result.put("f_type", f_type);
                    result.put("f_autoreply_info", f_autoreply_info);
                    return result;
                } else if (keyword.contains(f_keyword)) {
                    // 半匹配
                    result.put("f_type", f_type);
                    result.put("f_autoreply_info", f_autoreply_info);
                    return result;
                }
            }
        } catch (Exception e) {
            log.error("关键字处理异常:", e);
        }
        return null;
    }

}
