package com.aote.weixin.timer;

import com.aote.rs.LogicService;
import com.aote.rs.SqlService;
import com.aote.sql.SqlMapper;
import com.aote.util.AesUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 任务调度Timer
 * @author Mrriver
 * @date 2021/05/06
 */
@Component
public class TimerWork {
    /**
     * 日志对象
     */
    private static final Logger LOGGER = Logger.getLogger(TimerWork.class);

    /**
     * SQL查询支持
     */
    @Autowired
    private SqlService sqlService;

    /**
     * Logic执行支持
     */
    @Autowired
    private LogicService logicService;

    /**
     * 执行业务
     */
    public void doBusiness(JSONObject params) {
        //模块名称
        String moduleName = params.getString("moduleName");
        //业务名称
        String businessName = params.getString("name");
        //业务逻辑(Logic)名称
        String logicName = params.getString("logicName");
        //组织执行数据
        JSONObject data = new JSONObject(params.getString("data").replaceAll("\\\\",""));
        data.put("moduleName", moduleName);
        //开始执行业务
        LOGGER.info("======模块：【" + moduleName + "】开始" +"【" + businessName + "】业务流程======");
        //业务所需SQL
        JSONObject sqlData;
        //如果有SQL资源
        boolean isRunSql = params.has("sqlData");
        if (isRunSql) {
            sqlData = new JSONObject(params.getString("sqlData").replaceAll("\\\\",""));
            //获取SQL结果集
            JSONArray resultArray = getSqlResult(sqlData);
            if (resultArray != null) {
                resultArray.forEach((item) -> {
                    //追加请求数据
                    data.put("object", item);
                    //执行Logic
                    runLogic(logicName, data);
                });
            }
        } else {
            //执行Logic
            runLogic(logicName, data);
        }
        LOGGER.info("======模块：【" + moduleName + "】的【" + businessName + "】业务流程结束======");
    }

    /**
     * 获取业务执行所需SQL的结果集
     * @param sqlData SQL请求参数
     * @return 结果集
     */
    public JSONArray getSqlResult(JSONObject sqlData){
        if (sqlData.has("sqlName")) {
            //SQL名称
            String sqlName = sqlData.getString("sqlName");
            if(SqlMapper.getSql(sqlName) == null){
                LOGGER.info("未找到名为【"+sqlName+"】的SQL映射文件");
                return null;
            }
            //查询条件
            JSONObject sqlParams = sqlData.getJSONObject("sqlParams");
            //查询数量
            int pageSize = 500;
            //如果有查询条数限制
            boolean isHasPageSize = sqlData.has("pageSize");
            if (isHasPageSize) {
                pageSize = sqlData.getInt("pageSize");
                if (pageSize == 0) {
                    pageSize = 9999999;
                }
            }
            try {
                JSONObject tempParam = new JSONObject();
                tempParam.put("data",sqlParams);
                LOGGER.info("======sqlParams：" + tempParam );
                String param = null;
                try {
                    param = AesUtils.Encrypt(String.valueOf(tempParam), "OXuYieBb4eoIne^K");
                } catch (Exception e) {
                    e.printStackTrace();
                }
                JSONObject params = new JSONObject();
                params.put("aoteEncrypt","AES");
                params.put("data",param);
                // 解密
                String result = AesUtils.Decrypt(sqlService.txExecute(sqlName, 1, pageSize, params.toString()), "OXuYieBb4eoIne^K");
                return new JSONArray(result);
            } catch (Exception e) {
                LOGGER.error("出现异常：", e);
                return null;
            }
        } else {
            return null;
        }
    }

    private void runLogic(String logicName, JSONObject data) {
        try {
            String param = AesUtils.Encrypt(String.valueOf(data), "OXuYieBb4eoIne^K");
            JSONObject params = new JSONObject();
            params.put("aoteEncrypt","AES");
            params.put("data",param);
            logicService.xtSave(logicName, params.toString());
        } catch (Exception e) {
            LOGGER.error("【" + logicName + "】出现异常：", e);
        }
    }
}
