package com.aote.weixin.timer;
import com.aote.pay.RefundSuper;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.ContextLoader;

import javax.annotation.PostConstruct;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;


/**
 * @author JoeCdy
 * @Description 微信公众号单边账处理
 * @createTime 2020年04月08日 18:45:00
 */
public class ErrorOrderProcess {

    static Logger log = Logger.getLogger(OrderProcess.class);

    @Autowired
    private SqlServer sqlServer;

    @Autowired
    public SessionFactory sessionFactory;


    @PostConstruct
    public void init() {
    }

    /**
     * 线程不安全,新任务需要等上次任务执行完毕后在执行,即concurrent设置为false
     */
    @Transactional(propagation = Propagation.NEVER)
    public void run() throws Exception {
        log.debug("本次处理单边账开始");
        JSONObject sqlParam = new JSONObject();
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(Calendar.MINUTE,-10);//5分钟之前的时间
        Date date=beforeTime.getTime();
        String dateNow =  new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(date);
        sqlParam.put("dateNow",dateNow);
        // 这种查询方法最大查询1000条数据,不过够用了
        JSONArray query = sqlServer.query("errorOrderQuery", sqlParam);
        if (query.length() > 0) {
            log.debug("本次处理单边账数量:" + query.length());
        }
        for (Object o : query) {
            try {
                this.process((JSONObject) o);
            } catch (Exception e) {
                log.debug("处理订单系统错误:", e);
            }
        }
    }
    /**
     * 订单处理
     *
     * @param row
     */
    public void process(JSONObject row) {
        Object id = row.get("id");
        if ("1".equals(row.get("f_is_update"))) {
            String flag = row.getString("flag");
            // 首字母转小写
            flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
            // log.debug("处理订单实现类: " + flag);
            RefundSuper refundSuper = (RefundSuper) ContextLoader.getCurrentWebApplicationContext().getBean(flag);
            refundSuper.refund(row);
        } else {
            this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state = '已下单', f_is_update = '1'  where id = '" + id + "'");
        }
    }
}
