package com.aote.util.pdf;

import cn.hutool.core.io.FileUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.af.plugins.DateTools;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.documents4j.api.DocumentType;
import com.documents4j.api.IConverter;
import com.documents4j.job.LocalConverter;
import com.itextpdf.text.Document;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfWriter;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.*;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.*;


public class WordTools {
    public static void main(String[] args) {
//        String uploadContract = uploadContract("http://192.168.50.4:5555/third/rs/signature/wxq/file/upload", "D:\\files\\2024-06-19\\2024_06_19_08_11_42安全供用气合同(商业).pdf");
//        System.out.println("结果"+uploadContract);
        JSONObject fileInfo = getFileInfoByKey("http://49.4.68.202:5555/gzSign/rs/signature/wxq/file/downloadUrl", "8JRzyuLNp7K3Mm/90mdxbc4qKEZUt0Zmx6NoEhGf/WPJk6dcFrKtyKppvmOUWrXvKYKzDeuDT98o+4zTl6PqEQ==");
        System.out.println(fileInfo);
    }


    static Logger log = LoggerFactory.getLogger(WordTools.class);
    /**
     * 将数据生成到word中
     */
    public static String saveWord(String filename, String filePure,String fileurl,JSONObject data) throws IOException {
        log.debug("打印替换参数"+data);
        log.debug("打印替换文件路径"+filename);
        log.debug("打印替换文件路径"+filePure);
        log.debug("打印替换文件路径"+fileurl);
        String absoluturl = "";
        //获取模板的文件流
        HashMap<String, Object> dataMap = new HashMap<>();
        Iterator<String> keys = data.keys();
        log.debug("打印keys:"+keys.hasNext());
        while (keys.hasNext()) {
            String key = keys.next();
            Object value = data.get(key);

            if (!value.equals("null")) {
                if (value.equals("是")) {
                    dataMap.put(key, "☑");
                }else if (value.equals("否")){
                    dataMap.put(key, "☐");
                }else {
                    dataMap.put(key, value);
                }

            }
        }
        log.debug("进入到替换节点");
        log.debug("进入到替换节点打印数据"+dataMap);
        File wordTemplate = new File(filePure);
        String absolutePath = wordTemplate.getAbsolutePath();
        Configure build = Configure.builder().build();
        // 进行编译
        XWPFTemplate render = XWPFTemplate.compile(absolutePath, build).render(dataMap);
        fileurl = fileurl+ File.separator + DateTools.getNow("yyyy-MM-dd");
        File dir = new File(fileurl);
        if (!dir.exists()) {
            dir.mkdir();
        }
        File word = new File(dir.getAbsolutePath() + File.separator + DateTools.getNow("yyyy_MM_dd_hh_mm_ss") + filename + ".docx");
        try {
            absoluturl = word.getAbsolutePath();
            log.debug("打印全路径absoluturl:"+absoluturl);
            render.writeToFile(absoluturl);
            log.debug("生成了对应的文件");
            absoluturl = Word2Pdf(absoluturl);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return absoluturl;
    }



    /**
     * 将word文档转为PDT返回
     * @param
     * @return
     * @throws Exception
     */
    public static String Word2Pdf(String docPath) throws Exception {
        String pdfurl = null;
        pdfurl = docPath.split("\\.")[0];
        pdfurl = pdfurl + ".pdf";
        InputStream docxInputStream = null;
        OutputStream outputStream = null;
        try {
            // 原word地址
            docxInputStream = Files.newInputStream(Paths.get(docPath));
            // 转换后pdf生成地址
            outputStream = Files.newOutputStream(Paths.get(pdfurl));
            IConverter converter = LocalConverter.builder().build();
            converter.convert(docxInputStream)
                    .as(DocumentType.DOCX)
                    .to(outputStream)
                    .as(DocumentType.PDF).execute();
            // 关闭
            converter.shutDown();
            // 关闭
            outputStream.close();
            // 关闭
            docxInputStream.close();
        } catch (Exception e) {
            log.debug("[documents4J] word转pdf失败:" + e.toString());
        } finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (docxInputStream != null) {
                docxInputStream.close();
            }
        }
        return pdfurl;
    }


    /**
     * 将word文档转为PDT返回
     * @param
     * @return
     * @throws Exception
     */
    public static String Word3Pdf(String docPath) throws Exception {
        String pdfurl = null;
        pdfurl = docPath.split("\\.")[0];
        pdfurl = pdfurl + ".pdf";
        InputStream docxInputStream = null;
        OutputStream outputStream = null;
        try {
            XWPFDocument document = new XWPFDocument(Files.newInputStream(Paths.get(docPath)));
            FileOutputStream out = new FileOutputStream(pdfurl);
            Document pdfDocument = new Document();
            PdfWriter.getInstance(pdfDocument, out);
            pdfDocument.open();

            for (XWPFParagraph paragraph : document.getParagraphs()) {
                for (XWPFRun run : paragraph.getRuns()) {
                    String text = run.getText(0);
                    if (text != null) {
                        pdfDocument.add(new Paragraph(text));
                    }
                }
            }

            pdfDocument.close();
            document.close();
        } catch (Exception e) {
            log.debug("[documents4J] word转pdf失败:" + e.toString());
        }
        return pdfurl;
    }


    public static JSONObject wordToJson(JSONObject dataword,JSONObject contedata) {
        log.debug("打印获取到的数据"+ dataword);
        log.debug("打印用户的json数据"+ contedata);
        JSONObject jsonObject = new JSONObject();
        Iterator<String> keys = dataword.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            jsonObject.put(key,contedata.get(key));
        }
        log.debug("打印插入word的json数据"+ contedata);
        return jsonObject;
    }

    public static JSONObject wordChoice(JSONObject dataword,JSONObject contedata,JSONObject choiceword) {
        log.debug("打印获取到的数据dataword"+ dataword);
        log.debug("打印用户的json数据contedata"+ contedata);
        log.debug("打印获取到的数据choiceword"+ choiceword);
        ArrayList<Object> objects = new ArrayList<>();

        // 遍历JSONObject中的每个属性并添加到Map中
        Iterator<?> keys = choiceword.keys();
        while (keys.hasNext()) {
            String key = (String) keys.next();
            Object value = choiceword.get(key);

            if (!value.equals("null")) {
                objects.add(value);
            }
        }
        log.debug("打印集合中的数据数据"+ objects);
        // 遍历JSONObject中的每个属性并添加到Map中
        Iterator<?> datawordkeys = dataword.keys();
        while (datawordkeys.hasNext()) {
            String key = (String) datawordkeys.next();
            String value = (String)dataword.get(key);

            if (objects.contains(value)) {
                contedata.put(key,"是");
            } else {
                contedata.put(key,"否");
            }
        }
        log.debug("打印最终插入word的json数据"+ contedata);
        return contedata;
    }
    public static String uploadContract(String path, String pdfUrl) {
        return uploadContract(path,"file",pdfUrl);
    }
    public static String uploadContract(String path, String key, String pdfUrl) {
        String result = "";
        JSONObject res = new JSONObject();
        //文件上传只需将参数中的键指定（默认file），值设为文件对象即可，对于使用者来说，文件上传与普通表单提交并无区别
        File file = FileUtil.file(pdfUrl);
        if (file.length() > 0) {
            HttpRequest request = HttpRequest.post(path).header("Context-Type", "multipart/form-data").form(key,file);
            HttpResponse httpResponse = request.execute();
            if (httpResponse.isOk()) {
                result = httpResponse.body();
            } else {
                res.put("msg", "文件上传失败");
                res.put("success", false);
                result = res.toString();
            }
        } else {
            res.put("msg", "文件为空");
            res.put("success", false);
            result = res.toString();
        }
        log.debug("文件上传返回数据"+ result);
        return result;
    }
    public JSONObject downloadContract(String path, String downloadPath) {
        JSONObject result = new JSONObject();
        int size =  (int) HttpUtil.downloadFile(path, FileUtil.file(downloadPath));
        if (size > 0){
            result.put("size", size);
            result.put("filePath", downloadPath);
            result.put("success", true);
        } else {
            result.put("size", 0);
            result.put("filePath", downloadPath);
            result.put("success", false);
        }
        return result;
    }

    public static JSONObject getFileInfoByKey(String path,String fileKey) {
        JSONObject fileParam = new JSONObject();
        fileParam.put("fileKey", fileKey);
        String response = HttpUtil.post(path, fileParam.toString(), 60000);
        return new JSONObject(response);
    }

    public String getFileInfo(String pdfUrl) {
        File file = FileUtil.file(pdfUrl);
        return file.getName();
    }
}
