package com.aote.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlUtils {
	
	static Logger log = Logger.getLogger(XmlUtils.class);
	
	/**
	 * 将xml解析为制定的对象
	 * @param xml
	 * @param cl
	 * @return
	 */
	public static Object formatXml (String xml, Class<?> cl) {
		log.debug("请求的xml: " + xml);
		String FEATURE = null;
		StringReader stringReader = new StringReader(xml);
		InputSource is = new InputSource(stringReader);
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		Object object = null;
		try {
			FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
			dbf.setFeature(FEATURE, true);
			FEATURE = "http://xml.org/sax/features/external-general-entities";
			dbf.setFeature(FEATURE, false);
			FEATURE = "http://xml.org/sax/features/external-parameter-entities";
			dbf.setFeature(FEATURE, false);
			FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
			dbf.setFeature(FEATURE, false);
			dbf.setXIncludeAware(false);
			dbf.setExpandEntityReferences(false);
			DocumentBuilder db = dbf.newDocumentBuilder();
			Document document = db.parse(is);
			Element root = document.getDocumentElement();
			NodeList subList = root.getChildNodes();
			JSONObject jo = new JSONObject();
			for (int i = 0; i < subList.getLength(); i ++) {
				Node node = subList.item(i);
				String nodeName = node.getNodeName();
				String nodeText = node.getTextContent();
				jo.put(nodeName, nodeText);
			}
			log.debug("xml解析后的json: " + jo);
			// 通过反射获取需要的类
			Class<?> clazz = Class.forName(cl.getName());
			object = clazz.newInstance();
			// 获取类的属性
	        Field[] fields = clazz.getDeclaredFields();
			for(Field field: fields){
	            String name = field.getName();
	            String methodName = "set" + (name.charAt(0)+"").toUpperCase() + name.substring(1, name.length());
	            Method method = clazz.getMethod(methodName, field.getType());
	            if (jo.has(name)) {
	            	if (field.getType().getSimpleName().equals("String")) {
	            		method.invoke(object, jo.get(name).toString());
	            	} else {
	            		method.invoke(object, Integer.parseInt(jo.get(name).toString()));
	            	}
	            }
	        }
		} catch (Exception e) {
			throw new RuntimeException("xml解析失败", e);
		}
		log.debug("xml解析的对象: " + object);
		return object;
	}

	/**
	 * 将Map<Object,Object> 集合转化成 xml格式
	 * @param parameters
	 * @return
	 */
	public static String getRequestXml(Map<Object,Object> parameters){

		StringBuffer sb = new StringBuffer();

		sb.append("<xml>");

		Set es = parameters.entrySet();

		Iterator it = es.iterator();

		while(it.hasNext()) {

			Map.Entry entry = (Map.Entry)it.next();

			String k = String.valueOf(entry.getKey());

			String v = String.valueOf(entry.getValue());

			if ("attach".equalsIgnoreCase(k)||"body".equalsIgnoreCase(k)||"sign".equalsIgnoreCase(k)) {

				sb.append("<"+k+">"+"<![CDATA["+v+"]]></"+k+">");

			}else {

				sb.append("<"+k+">"+v+"</"+k+">");

			}

		}

		sb.append("</xml>");

		return sb.toString();

	}

	/**
	 * XML格式字符串转换为Map
	 *
	 * @param strXML XML字符串
	 * @return XML数据转换后的Map
	 * @throws Exception
	 */
	public static Map<String, String> xmlToMap(String strXML) throws Exception {
		try {
			Map<String, String> data = new HashMap<String, String>();
			DocumentBuilder documentBuilder = WXPayXmlUtil.newDocumentBuilder();
			InputStream stream = new ByteArrayInputStream(strXML.getBytes("UTF-8"));
			org.w3c.dom.Document doc = documentBuilder.parse(stream);
			doc.getDocumentElement().normalize();
			NodeList nodeList = doc.getDocumentElement().getChildNodes();
			for (int idx = 0; idx < nodeList.getLength(); ++idx) {
				Node node = nodeList.item(idx);
				if (node.getNodeType() == Node.ELEMENT_NODE) {
					org.w3c.dom.Element element = (org.w3c.dom.Element) node;
					data.put(element.getNodeName(), element.getTextContent());
				}
			}
			try {
				stream.close();
			} catch (Exception ex) {
				// do nothing
			}
			return data;
		} catch (Exception ex) {
			log.error(ex);
			throw ex;
		}
	}
}