package com.aote.util;


import cn.hutool.core.codec.Base64;
import it.sauronsoftware.jave.AudioAttributes;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.EncoderException;
import it.sauronsoftware.jave.EncodingAttributes;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.json.JSONObject;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;

/**
 * @author llzh
 * @ClassName AMRtoMP3Converter
 * @Description TODO
 * @DateTime 2023/9/6 11:39
 */
public class WechatVoiceUtil {
    static Logger log = Logger.getLogger(WechatVoiceUtil.class);

    /*
     * @MethodName convertSpeexByteArrayToMp3
     * @Description  Speex转MP3
     * @param [speexData]
     * @return byte[]
     * @Author llz
     * @Date 2023/9/8 4:33
     */
    public static byte[] convertSpeexByteArrayToMp3(byte[] speexData) {
        // 将Speex字节数组写入临时Speex文件
        try {
//            File speexFile = File.createTempFile("temp", ".speex");
            File speexFile = new File("C:\\Users\\Administrator\\Desktop\\wechatAMR\\temp", ".speex");
            try (OutputStream os = new FileOutputStream(speexFile)) {
                os.write(speexData);
            }
            // 创建目标MP3文件
            File mp3File = File.createTempFile("C:\\Users\\Administrator\\Desktop\\wechatAMR\\temp", ".mp3");
            // 创建音频编码器
            AudioAttributes audio = new AudioAttributes();
            audio.setCodec("libmp3lame");
            audio.setBitRate(128000); // 设置比特率，根据需要调整
            audio.setChannels(1); // 声道数（立体声）
            audio.setSamplingRate(16000); // 采样率，根据需要调整

            EncodingAttributes attrs = new EncodingAttributes();
            attrs.setFormat("mp3");
            attrs.setAudioAttributes(audio);

            // 执行转换
            Encoder encoder = new Encoder();
            encoder.encode(speexFile, mp3File, attrs);

            // 从生成的MP3文件中读取数据到字节数组
            byte[] mp3Data;
            try (FileInputStream mp3InputStream = new FileInputStream(mp3File)) {
                mp3Data = new byte[(int) mp3File.length()];
                mp3InputStream.read(mp3Data);
            }

            // 删除临时Speex和MP3文件
//            speexFile.delete();
//            mp3File.delete();
            return mp3Data;
        } catch (EncoderException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    // 步骤1：提交语音
    public static JSONObject submitVoice(byte[] mp3Data, String mediaId, String ACCESS_TOKEN) throws IOException {
        log.info("提交的mp3字节:" + Base64.encode(mp3Data));
        String voiceId = "Voice" + mediaId;
        String submitUrl = "https://api.weixin.qq.com/cgi-bin/media/voice/addvoicetorecofortext?access_token=" + ACCESS_TOKEN + "&format=mp3&voice_id=" + voiceId + "&lang=zh_CN";
        log.info("开始提交语音,VoiceId:" + voiceId + ", url: " + submitUrl);

        HttpClient httpClient = HttpClients.createDefault();
        try {
            HttpPost httpPost = new HttpPost(submitUrl);

            // 设置请求体为MP3字节数组
            HttpEntity entity = new ByteArrayEntity(mp3Data);
            httpPost.setEntity(entity);

            HttpResponse response = httpClient.execute(httpPost);
            String responseBody = EntityUtils.toString(response.getEntity());
            log.info("提交语音结果: " + responseBody);
            return new JSONObject(responseBody);
        } catch (Exception e) {
            log.error("语音提交失败！", e);
        } finally {
            httpClient.getConnectionManager().shutdown();
        }
        return null;
    }

    public static byte[] convertAMRToMP3ByteArray(byte[] amrData) throws EncoderException {
        // 创建AMR临时文件
        File amrFile = null;
        try {
            amrFile = File.createTempFile("C:\\Users\\Administrator\\Desktop\\wechatAMR\\temp", ".amr");
//            amrFile = new File("C:\\Users\\Administrator\\Desktop\\wechatAMR\\temp\\abc.amr");

            try (FileOutputStream fos = new FileOutputStream(amrFile)) {
                fos.write(amrData);
            }

            // 创建目标MP3文件
            File mp3File = File.createTempFile("temp", ".mp3");

            // 创建音频编码器
            AudioAttributes audio = new AudioAttributes();
            audio.setCodec("libmp3lame");
            audio.setBitRate(128000); // 设置比特率，根据需要调整
            audio.setChannels(2); // 声道数（立体声）
            audio.setSamplingRate(44100); // 采样率，根据需要调整

            EncodingAttributes attrs = new EncodingAttributes();
            attrs.setFormat("mp3");
            attrs.setAudioAttributes(audio);

            // 执行转换
            Encoder encoder = new Encoder();
            encoder.encode(amrFile, mp3File, attrs);

            // 从生成的MP3文件中读取数据到字节数组
            try (FileInputStream mp3InputStream = new FileInputStream(mp3File)) {
                byte[] mp3Data = new byte[(int) mp3File.length()];
                mp3InputStream.read(mp3Data);
                return mp3Data;
            }
        } catch (IOException e) {
            log.error("文件转换异常", e);
        }
//        finally {
//            // 删除临时文件
//            if (amrFile != null && amrFile.exists()) {
//                amrFile.delete();
//            }
//        }
        return null;
    }
    public static byte[] convertAMRToMP3(byte[] amrData) {
        File mp3File = new File("D:\\output.mp3");
        try {
            File amrFile = new File("C:\\Users\\Administrator\\Desktop\\wechatAMR\\temp\\abc.amr");
            try (FileOutputStream fos = new FileOutputStream(amrFile)) {
                fos.write(amrData);
            }
            // 创建目标MP3文件
//            File mp3File = File.createTempFile("temp", ".mp3");

            try (InputStream inputStream = new ByteArrayInputStream(amrData);

                 FFmpegFrameGrabber grabber = new FFmpegFrameGrabber(inputStream);
                 ByteArrayOutputStream mp3OutputStream = new ByteArrayOutputStream();
                 FFmpegFrameRecorder recorder = new FFmpegFrameRecorder(mp3File, 1);
            ) {

                // 将AMR字节数组包装成ByteBuffer
                grabber.start();
                // 创建一个ByteArrayOutputStream来存储MP3字节数据
                recorder.setFormat("mp3");
                recorder.setSampleRate(16000);
                recorder.start();
                Frame frame;
                while ((frame = grabber.grabFrame()) != null) {
                    recorder.record(frame);
                }
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                return Files.readAllBytes(mp3File.toPath());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    // 步骤2：获取语音识别结果
    public String getRecognitionResult(String mediaId, String ACCESS_TOKEN) throws IOException {
        String voiceId = "Voice" + mediaId;
        String getResultUrl = "https://api.weixin.qq.com/cgi-bin/media/voice/queryrecoresultfortext?access_token=" + ACCESS_TOKEN + "&voice_id=" + voiceId + "&lang=zh_CN";
        log.info("获取语音识别结果,VoiceId:" + voiceId + ", url: " + getResultUrl);
        HttpClient httpClient = HttpClients.createDefault();
        try {
            HttpPost httpPost = new HttpPost(getResultUrl);
            HttpResponse response = httpClient.execute(httpPost);
            String result = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            log.info("获取语音结果" + result);
            return result;
        } catch (Exception e) {
            log.error("获取语音识别结果失败！", e);
        } finally {
            httpClient.getConnectionManager().shutdown();
        }
        return null;
    }

    public String getVoiceInfo(String mediaId, String ACCESS_TOKEN) {
        try {
            log.info("开始调用微信接口获取语音文件");
            //调用微信接口获取语音文件
            byte[] voiceByte = convertAMRToMP3(getVoiceFile(mediaId,ACCESS_TOKEN));
            //提交微信语音
           JSONObject res = submitVoice(voiceByte, mediaId, ACCESS_TOKEN);
            log.info("提交语音文件结果----------->" + res);
            if (res != null && "0".equals(res.get("errcode").toString())) {
                //获取语音结果
                String ret = getRecognitionResult(mediaId, ACCESS_TOKEN);
                log.info("获取语音内容结果----------->" + ret);
                return ret;
            }
        } catch (Exception e) {
            log.error("获取微信语音信息异常！", e);
        }
        return "获取语音结果失败";

    }

    /**
     * @param
     * @return byte[]
     * @MethodName getVoiceFile
     * @Description TODO 调用微信接口获取语音文件
     * @Author llz
     * @Date 2023/9/8 3:29
     */
    public byte[] getVoiceFile(String mediaId, String ACCESS_TOKEN) {
        HttpClient httpClient = HttpClients.createDefault();
        try {
            log.info("调用微信接口获取语音文件,mediaId:" + mediaId);
            // 构建请求URL
            String url = "https://api.weixin.qq.com/cgi-bin/media/get?access_token=" + ACCESS_TOKEN + "&media_id=" + mediaId;
            log.info("调用微信接口获取语音文件,mediaId:" + mediaId + ",    url:" + url + ",  token:" + ACCESS_TOKEN);

            // 创建HTTP GET请求
            HttpGet httpGet = new HttpGet(url);
            // 执行HTTP请求并获取响应
            HttpResponse response = httpClient.execute(httpGet);
            // 从响应实体中获取输入流，并将其读取为字节数组
            InputStream inputStream = response.getEntity().getContent();
            byte[] voiceData;
            if (response.getEntity() != null && response.getStatusLine().getStatusCode() == 200) {
                // 读取数据为字节数组
                voiceData = EntityUtils.toByteArray(response.getEntity());
                log.info("下载到的文件------------>" + Arrays.toString(voiceData));
            } else {
                log.error("获取语音文件失败，HTTP状态码：" + response.getStatusLine().getStatusCode());
                throw new NullPointerException("获取到的文件是空");
            }
            // 关闭输入流
            inputStream.close();
            log.info("获取到的语音文件为-----》" + Arrays.toString(voiceData));
            return voiceData;
        } catch (Exception e) {
            log.error("下载文件异常！", e);
        } finally {
            // 关闭 HttpClient 连接管理器等资源
            httpClient.getConnectionManager().shutdown();
        }
        return  null;
    }

}
