package com.aote.util;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @Author: JoeCdy
 * @Description:
 * @Date: Created in 0:22 2020/8/29
 */
public class PayUtil {

    /**
     * 生成订单号,最长30位。建议按以下规则生成订单号：商户代码后9位+自定义字符串（不超21位）；字符串可包含数字、字母、下划线；商户需保证订单号唯一。
     *
     * @param merchantid 商户代码
     * @return 随机订单号
     */
    public static String getOrderNum(String merchantid) {
        int i = RandomUtil.randomInt(0, 24);
        return merchantid.substring(6, merchantid.length()) + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + IdUtil.simpleUUID().substring(i, i+7);
    }

    /**
     * 生成30位订单号,纯数字。
     * 日期（年月日） + 雪花算法生成的数字 + 随机数
     *
     * @return 随机订单号
     */
    public static String getOrderNoByNumber() {
        // 日期8位
        String format = new SimpleDateFormat("yyyyMMdd").format(new Date());
        // 5位
        String i = RandomUtil.randomNumbers(5);
        // 17位
        String snowNum = String.valueOf(SnowflakeIdWorker.getValue());
        String orderNoByNumber =  format + snowNum + i;
        if (orderNoByNumber.length() > 30) {
             orderNoByNumber  = orderNoByNumber.substring(0,30);
        }
        return orderNoByNumber;
    }
    public static String getOrderNoByNumber50() {
        // 日期8位
        String format = new SimpleDateFormat("yyyyMMdd").format(new Date());
        // 25位
        String i = RandomUtil.randomNumbers(25);
        // 17位
        String snowNum = String.valueOf(SnowflakeIdWorker.getValue());

        String orderNoByNumber =  format + snowNum + i;
        if (orderNoByNumber.length() > 50) {
            orderNoByNumber  = orderNoByNumber.substring(0,50);
        }
        return orderNoByNumber;
    }
    /**
     * 要求32个字符内、且在同一个商户号下唯一（订单前8位为日期:20180422）
     * @return
     */
    public static String getOutTradeNo () {
        // 当前时间字符串
        String format = DateUtil.format(new Date(), DatePattern.PURE_DATE_PATTERN);
        return format + RandomUtil.randomString(24);
    }

    /**
     * 金额单位转换 元->分
     *
     * @param obj 元值
     * @return 分值
     */
    public static int yuan2FenInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        BigDecimal fee = new BigDecimal(obj.toString());
        fee = fee.multiply(new BigDecimal(100)).setScale(0, BigDecimal.ROUND_HALF_UP);
        return fee.intValue();
    }

    public static String liftOutTradeNo(String thirdSysID) {
        return thirdSysID + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()) + "01";
    }
    public static void main(String[] args) {
            String numNo = getOrderNoByNumber();
            System.out.println("2022112010038699094337126453063-->" + numNo + "--" + numNo.length());


    }

}
