package com.aote.util;

import cn.hutool.http.HttpUtil;
import com.aote.rs.WeiXinService;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;


public class JSAPITicket implements ServletContextListener {
    private static Logger log = Logger.getLogger(JSAPITicket.class);
    private static String ticket;
    public static String accessToken;

    public static void refreshTicket() {
        int n = 5;
        while (n > 0) {
            try {
                String url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi".replace("ACCESS_TOKEN", accessToken);
                log.debug("刷新ticket链接:" + url);
                JSONObject ticketJson = new JSONObject(HttpUtil.get(url));
                if (ticketJson.has("ticket")) {
                    ticket = ticketJson.getString("ticket");
                    log.debug("刷新ticket成功:" + ticket);
                    n = 0;
                } else {
                    n--;
                    log.debug("刷新ticket失败:" + ticketJson);
                }
            } catch (Exception e) {
                log.debug("刷新ticket异常:", e);
                try {
                    Thread.sleep(3000);
                } catch (InterruptedException e1) {
                    e1.printStackTrace();
                } finally {
                    n--;
                }
            }
        }
    }

    public static String getTicket() {
        synchronized (JSAPITicket.class) {
            // 多分公司
            refreshTicket();
            log.debug("ticket：" + ticket);
            return ticket;
        }
    }

    @Override
    public void contextInitialized(ServletContextEvent servletContextEvent) {
    }

    @Override
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        // 强制关闭
        log.debug("JSAPITicket===>销毁线程");
    }
}
