package com.aote.util;

import com.aote.logic.LogicMapper;
import com.aote.sql.SqlMapper;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * @Author: JoeCdy
 * @Description:
 * @Date: Created in 14:29 2020/7/9
 */
@Slf4j
public class FilialeReplace {

    public static final String FILIALE = "filiale";

    /**
     * logic业务逻辑根据分公司进行覆盖或添加
     */
    public static void logicReplace() throws Exception {
        try {
            String filiale = Config.wechatConfig.getString("filiale");
            filiale = FILIALE + File.separator + filiale;
            log.debug("{}===>分公司logic替换", filiale);
            // 分公司logic映射文件
            String str = filiale + File.separator + "logic.xml";
            InputStream moduleLogic = LogicMapper.class.getClassLoader()
                    .getResourceAsStream(str);

            if (moduleLogic == null) {
                log.debug("找不到分公司logic配置文件: {}", str);
                return;
            }
            SAXReader reader = new SAXReader();
            Document docLogic = reader.read(moduleLogic);
            Element rootLogic = docLogic.getRootElement();
            for (Iterator item = rootLogic.elementIterator("logic"); item.hasNext(); ) {
                Element elmment = (Element) item.next();
                String aliasLogic = elmment.attribute("alias").getValue();
                String pathLogic = elmment.attribute("path").getValue();
                String log = elmment.attributeValue("log");
                String mobile = elmment.attributeValue("mobile");
                // 完整logic路径
                String path = filiale + File.separator + "logics" + File.separator + pathLogic;
                // 设置业务逻辑属性
                Map<String, String> logic = new HashMap<>();
                logic.put("alias", aliasLogic);
                logic.put("path", path);
                logic.put("log", log);
                logic.put("mobile", mobile);
                // 进行替换或新增
                LogicMapper.getMap().put(aliasLogic, logic);
            }
        } catch (Exception e) {
            log.debug("分公司logic替换异常", e);
        }
    }

    /**
     * sql根据分公司进行覆盖或添加
     */
    public static void sqlReplace() throws Exception {
        try {
            String filiale = Config.wechatConfig.getString("filiale");
            filiale = FILIALE + File.separator + filiale;
            log.debug("{}===>分公司sql替换", filiale);
            // 分公司logic映射文件
            String str = filiale + File.separator + "sql.xml";
            InputStream moduleLogic = LogicMapper.class.getClassLoader()
                    .getResourceAsStream(str);

            if (moduleLogic == null) {
                log.debug("找不到分公司sql配置文件: {}", str);
                return;
            }
            SAXReader reader = new SAXReader();
            Document docLogic = reader.read(moduleLogic);
            Element rootLogic = docLogic.getRootElement();
            for (Iterator item = rootLogic.elementIterator("sql"); item.hasNext(); ) {
                Element elmment = (Element) item.next();
                String aliasLogic = elmment.attribute("alias").getValue();
                String pathLogic = elmment.attribute("path").getValue();
                String mobile = elmment.attributeValue("mobile");
                // 完整sql路径
                String path = filiale + File.separator + "sqls" + File.separator + pathLogic;
                // 设置sql属性
                Map<String, String> logic = new HashMap<>();
                logic.put("alias", aliasLogic);
                logic.put("path", path);
                logic.put("mobile", mobile);
                // 进行替换或新增
                SqlMapper.getMap().put(aliasLogic, logic);
            }
        } catch (Exception e) {
            log.debug("分公司logic替换异常", e);
        }
    }


}