package com.aote.util;

import org.apache.commons.lang.StringUtils;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DesensitizationTool {
    public static final String KEY = "7xjgtQc4M8FOXikU7JkwcUI0wKhYkREt";
    public static String regex = "\\|-\\S*?==-\\|";

    public DesensitizationTool() {
    }

    public static void main(String[] args) throws Exception {
        String a = phoneEncrypt("21321321312");
        System.out.println(a);
        String b = modifyResponseBody("139|-07940261yyx9U9iTLdqGqm==-|0261", false);
        System.out.println(b);
        String c = modifyResponseBody("139|-07940261yyx9U9iTLdqGqm==-|0261");
        System.out.println(c);
    }

    public static boolean checkID(String id) {
        String regex = "(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)";
        return id.matches(regex);
    }

    public static boolean checkPhone(String phone) {
        String regex = "^(13[0-9]|14[5-9]|15[012356789]|16[56]|17[0-8]|18[0-9]|19[189])\\d{8}$";
        return phone.matches(regex);
    }

    public static String phoneEncrypt(String phone) throws Exception {
        String regex = "(\\d{3})(\\d{4})(\\d{4})";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(phone);
        String encrypt = "";
        if (matcher.find()) {
            String group1 = matcher.group(2);
            encrypt = aesEncrypt(group1, "7xjgtQc4M8FOXikU7JkwcUI0wKhYkREt");
        }

        encrypt = "|-" + encrypt + "-|";
        return phone.replaceAll(regex, "$1" + encrypt + "$3");
    }

    public static String idNumberEncrypt(String idNumber) throws Exception {
        String regex = "^(\\d*)(\\w{4})$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(idNumber);
        String encrypt = "";
        if (matcher.find()) {
            String group1 = matcher.group(1);
            encrypt = aesEncrypt(group1, "7xjgtQc4M8FOXikU7JkwcUI0wKhYkREt");
        }

        encrypt = "|-" + encrypt + "-|";
        return idNumber.replaceAll(regex, encrypt + "$2");
    }

    public static String aesEncrypt(String content, String encryptKey) throws Exception {
        return base64Encode(aesEncryptToBytes(content, encryptKey));
    }

    public static String base64Encode(byte[] bytes) {
        return java.util.Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(encryptKey.getBytes(), "AES"));
        return cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
    }

    public static String aesDecrypt(String encryptStr, String decryptKey) throws Exception {
        return StringUtils.isEmpty(encryptStr) ? null : aesDecryptByBytes(base64Decode(encryptStr), decryptKey);
    }

    public static byte[] base64Decode(String base64Code) throws Exception {
        return StringUtils.isEmpty(base64Code) ? null : java.util.Base64.getDecoder().decode(base64Code);
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(Cipher.DECRYPT_MODE, new SecretKeySpec(decryptKey.getBytes(), "AES"));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes, StandardCharsets.UTF_8);
    }

    public static String modifyResponseBody(String originalBody, Boolean sensitive) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(originalBody);
        StringBuffer sb = new StringBuffer(originalBody.length());
        try {
            for(String replacement = "****"; matcher.find(); matcher.appendReplacement(sb, replacement)) {
                String match = matcher.group(0);
                if (sensitive) {
                    try {
                        replacement = aesDecrypt(match.replace("|-", "").replace("-|", ""), "7xjgtQc4M8FOXikU7JkwcUI0wKhYkREt");
                    } catch (Exception var8) {
                        System.out.println(var8.getMessage());
                        return originalBody;
                    }
                }
            }
        } catch (Exception e) {
            System.out.println(e.getMessage());
            return originalBody;
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    /**
     * 直接进行脱敏处理
     * @param originalBody
     * @return
     */
    public static String modifyResponseBody(String originalBody) { // 假设您传递一个正则表达式
        return modifyResponseBody(originalBody,false);
    }
}
