package com.aote.util;

import java.util.*;

public class CreateSignUtils {
    public static String createSign(Map<String, ?> map, String apiKey, String charset) {

        SortedMap<String, String> packageParams = new TreeMap<String, String>();
        Iterator<String> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            if (map.get(key) != null)
                packageParams.put(key, map.get(key).toString());
        }
        return createSignOfSorted(packageParams, apiKey, charset);
    }

    public static String createSignOfSorted(SortedMap<String, String> packageParams, String apiKey, String charset) {
        StringBuffer sb = new StringBuffer();
        Set es = packageParams.entrySet();
        Iterator it = es.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry) it.next();
            String k = (String) entry.getKey();
            String v = (String) entry.getValue();
            if (null != v && !"".equals(v) && !"sign".equals(k)) {
                sb.append(k + "=" + v + "&");
            }
        }
        sb.append("key=" + apiKey);
        String sign = MD5.MD5Encode(sb.toString(), charset).toUpperCase(Locale.ENGLISH);
        return sign;
    }

}
