package com.aote.rs.otherfee;

import java.io.InputStream;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.aote.entity.WxNofityReturnData;

import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

import com.aote.logic.LogicServer;
import com.aote.rs.wechatpay.PayFee;
import com.google.gson.Gson;
import org.springframework.stereotype.Component;

/**
 * 微信支付成功后交易处理
 */
public class OtherfeePay {

	static Logger log = Logger.getLogger(OtherfeePay.class);


	@Autowired
	private LogicServer logicServer; 
	
	public OtherfeePay() {

	}

	@SuppressWarnings("unchecked")
	public String pay(HttpServletRequest request, HttpServletResponse response) throws Exception {
		// 获取服务器的ip
		String IP = request.getLocalAddr();
		// 获取服务器的端口
		Integer PORT = request.getLocalPort();
		InputStream is = request.getInputStream();
		WxNofityReturnData reData = PayFee.getNofityReturnData(is);
		JSONObject data = PayFee.xml(reData);
			 //保存微信记录,处理交易
			
			log.debug("解析好的数据result:" + data.toString());
			String newdata = "{\"data\":"+data.toString()+"}";
			log.debug("newdata:" + newdata);
			String userid = (String)logicServer.run("Searchwxfeestate", newdata);
			
			log.debug("userid:" + userid);
			Gson gs = new Gson();
			Map<String,Object> map1 = gs.fromJson(userid, Map.class);
			String f_userid = map1.get("f_userid").toString();
			log.debug("f_userid:" + f_userid);
	        data.put("f_userid", f_userid);
	        
	        log.debug("加入f_userid的数据result:" + data);
	        
	        // 查询是否有重复的缴费记录--巨鼎和韶关公用这个
			String result = (String)logicServer.run("weixinreturnxml", newdata);
			
			System.out.println("查到的数据：" +result);
			System.out.println("查到的数据：" +result.isEmpty());
			System.out.println("查到的数据：" +result.length());
			if (result.isEmpty()) {
				//插入缴费记录--公用
				logicServer.run("savewxreturnxml", "{\"data\":"+data.toString()+"}");
				
				logicServer.run("OtherPayfee", "{\"data\":"+data.toString()+"}"); // 其他缴费
			}
			return "SUCCESS";
	}
}
