package com.aote.rs;

import cn.hutool.http.HttpUtil;
import com.aote.util.WechatUrl;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.inject.Singleton;
import javax.ws.rs.POST;
import javax.ws.rs.Path;

/**
 * @Author: JoeCdy
 * @Description:
 * @Date: Created in 10:43 2021/4/20
 */
@Slf4j
@Component
@Path("mini")
@Singleton
@Transactional(rollbackFor = Exception.class)
public class MiniProgramService {
    

    @POST
    @Path("code2Session")
    public String code2Session (String value) {
        String result = "";
        try {
            log.debug("小程序登录: {}", value);
            JSONObject json = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(json.getString("filiale"));
            String miniAppId = wxConfig.getString("miniAppId");
            String miniAppSecret = wxConfig.getString("miniAppSecret");
            String codeUrl = WechatUrl.CODE2SESSION.replace("APPID", miniAppId).replace("SECRET", miniAppSecret).replace("JSCODE", json.getString("code"));
            String openidInfo = HttpUtil.get(codeUrl);
            if (openidInfo == null) {
                throw new RuntimeException("请求发送失败!");
            }
            log.debug("小程序获取到的openid信息: {} ", openidInfo);
            JSONObject openidJson = new JSONObject(openidInfo);
            if (!openidJson.has("openid")) {
                throw new RuntimeException("小程序获取openid失败!");
            }
            result = openidInfo;
        } catch (Exception e) {
            log.debug("小程序登录异常", e);
            throw new RuntimeException("小程序登录异常", e);
        }
        return result;
    }
}
