package com.aote.rs;

import com.aote.logic.LogicServer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import java.io.Serializable;

/**
 * @author 唐梓烨
 */
@Slf4j
@Component
@Path("contract")
@Singleton
@Transactional
public class ContractSignServer implements Serializable {

    @Autowired
    private LogicServer logicServer;

    /**
     * 合同签订状态回调
     * @param request
     * @param value
     * @return
     */
    @POST
    @Path("signStatusNotify")
    public String assignAgent(@Context HttpServletRequest request, String value) {
        String result = "";
        try {
            log.debug("签章平台回调合同签订状态: {}", value);
            result = logicServer.run("companySignNotify", value).toString();
        } catch (Exception e) {
            log.debug("签章平台回调合同签订状态处理失败", e);
        }
        return result;
    }
}
