package com.aote.rs;

import javax.inject.Singleton;
import javax.transaction.Transactional;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

import com.aote.util.AesUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.aote.logic.LogicServer;


/**
 * AES加密服务代理
 * @author le
 *
 */
@Component
@Path("ecryptlogic")
@Singleton
@Transactional
public class CipherServer {
static Logger log = Logger.getLogger(CipherServer.class);


	@Autowired
	private LogicServer logic;

	public static String KEY = "UxMfGXByBCho7OSEH3gPBBCEnjosGi2n";

	@POST
	@Path("{path}")
	public String startLogic (@PathParam("path") String path, String values) throws Exception {
		log.debug("执行参数 =======>" + path);
		log.debug("获取到的data" + values);
		String param = AesUtils.Decrypt(values, KEY);
		log.debug("解密后的data" + param);
		Object result = logic.run(path, param);
		log.debug("将要返回的result" + result);
		String resultStr = AesUtils.Encrypt(result.toString(), KEY);
		log.debug("加密的result" + resultStr);
		return resultStr;
	}
}