package com.aote.pay.yuantiao;


import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

import java.io.IOException;
import java.util.*;
public class DigestUtil {


    /**
     * 根据对象获取待签名字符串
     *
     * @param: obj
     * @return: String
     */
    public static String getDigest(String obj) throws IOException {
        String signData;
        if (obj instanceof String) {
            signData = String.valueOf(obj);
        } else {
            Map<String, String> signMap = JSONObject.parseObject(obj, new TypeReference<Map<String, String>>(){});


            //去除sign和为空字段
            signData = sortByAsc(signMap);
        }
        //进行base64编码
        String digest = Base64.getEncoder().encodeToString(signData.getBytes());
        return digest;

    }


    /**
     * 将参数按照asc从小到大排序，为空值不参与签名==key1=value1&key2=value2
     *
     * @param: params
     * @return: String
     */
    public static String sortByAsc(Map<String, String> params) {
        /*====判空====*/
        if (Objects.isNull(params) || params.isEmpty()) {
            return "";
        }
        /*====获取key值列表====*/
        List<String> keyList = new ArrayList<String>(params.keySet());
        /*====根据key值列表排序====*/
        Collections.sort(keyList);
        /*====获取拼接字符串====*/
        StringBuilder sb = new StringBuilder();
        for (String key : keyList) {

            if (key.equals("signMsg")) {
                continue;
            }
            Object value = params.get(key);
            if (value == null || value.equals("null") || value.equals("")) {
                continue;
            }

            sb.append(key).append("=").append(Objects.isNull(value) ? "" : value).append("&");
        }
        String result = sb.substring(0, sb.length() - 1);
        return result;
    }


}

