package com.aote.pay.xingtaibank.pingxiang;

import com.alibaba.fastjson.JSON;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.util.PayUtil;
import com.aote.utils.SSLClient;
import com.aote.weixin.Config;
import com.google.gson.Gson;
import com.ruim.ifsp.signature.IfspSdkSecurityAtureUtil;
import com.ruim.ifsp.signature.cert.IfspSdkConstants;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@Component
public class JsApiPingXiang implements PaySuper {
    @Autowired
    private LogicServer logicServer;
    

    /**
     * 下单接口
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        String userfilesid = json.getString("userfilesid");

        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);

        JSONObject result = new JSONObject();
        try {
            // 编码方式,默认取值：UTF-8
            String encoding = "UTF-8";
            // 签名方式, 01：RSA；02：MD5；
            String signMethod = wxConfig.getString("signMethod");
            // aapId,SDK 或 API 编号
            String sdkAppId = wxConfig.getString("app_id");
            // 交易类型,1006
            String txnType = "1006";
            // 交易子类型,100603
            String txnSubType = "100603";
            // 接入方式,01
            String aesWay = "01";
            // 商户编号,普通商户或一级商户的商户号
            String merId = wxConfig.getString("mer_id");
            // 后台通知地址，后台返回商户结果时使用，如上送，则发送商户后台交易结果通知
            String backEndUrl = wxConfig.getString("wechatNotify");
            // 商户订单号，商户系统内部的订单号,32个字符内、可包含字母, 确保在商户系统唯一
            String txnOrderId = PayUtil.getOutTradeNo();
            // 商户订单发送时间，商户发送交易时间，格式[yyyyMMddHHmmss]; 商户端生成
            String txnOrderTime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            // 商户子订单信息数据域
            String txnSecOrderInfoList = attach;
            // 账号类型,01：银行卡;02：微信账号；03：支付账户；
            String txnAccType = "02";
            // 账号,账号类型为 01时上送银行卡号或银行账号号；账号类型为 02/03 时上送支付宝或微信的授权码。
            String accNo = openid;
            // 用户子标识,用户在二级商户appid下的唯一标识, 账号类型为02，交易类型为微信公众号（JSAPI）时，此参数必传
            String txnSubOpenid = openid;
            // 支付金额,订单总金额(交易单位为分，例:1.23 元=123)，只能整数
            String txnAmt = String.valueOf(PayUtil.yuan2FenInt(money));
            // 币种,默认是 156：人民币
            String txnCcyType = "156";
            // 商户名称
            String merName = txnOrderId;
            // 支付订单描述
            String txnOrderBody = wxConfig.getString("body") + txnOrderId;
            // secMerAppId
            String secMerAppId = wxConfig.getString("appId");

            Map<String, Object> map = new HashMap<>();
            map.put("encoding", encoding);
            map.put("signMethod", signMethod);
            map.put("sdkAppId", sdkAppId);
            map.put("txnType", txnType);
            map.put("txnSubType", txnSubType);
            map.put("txnAccType", txnAccType);
            map.put("txnCcyType", txnCcyType);
            map.put("aesWay", aesWay);
            map.put("merId", merId);
            map.put("backEndUrl", backEndUrl);
            map.put("txnOrderId", txnOrderId);
            map.put("txnOrderTime", txnOrderTime);
            map.put("accNo", accNo);
            map.put("secMerAppId", secMerAppId);
            map.put("txnOrderBody", txnOrderBody);
            map.put("txnAmt", txnAmt);
            map.put("txnSubOpenid", txnSubOpenid);
            map.put("merExtInfo", userfilesid);
            map.put("merName", merName);
            map.put("txnSecOrderInfoList", txnSecOrderInfoList);

            Gson gson = new Gson();
            // 证书ID,证书编号，通过API插件自动获取
            // 证书路径
            String crePath = wxConfig.getString("crePath");
            String pfxPath = wxConfig.getString("pfxPath");
            String pfxPassWord = wxConfig.getString("pfxPassWord");
            try {
                boolean rsaSigndata = IfspSdkSecurityAtureUtil.RSASigndata(map, pfxPath, pfxPassWord);
                log.debug("rsaSigndata:" + rsaSigndata);
                String signature = (String) map.get(IfspSdkConstants.param_signature);
                log.debug("signature:" + signature);
                String requestMsg = JSON.toJSON(map).toString();
                Map respMsg = JSON.parseObject(requestMsg, Map.class);
                boolean rsaValidata= IfspSdkSecurityAtureUtil.RSAValidata(respMsg, crePath);
                log.debug("rsaValidata:" + rsaValidata);
                JSONObject jsonParams = new JSONObject(gson.toJson(map));
                HttpClient httpclient = new SSLClient();
                // 下单请求地址
                String PrePayUrl = wxConfig.getString("PrePayUrl");
                log.debug("邢台银行下单地址: {},下单参数: {}", PrePayUrl, jsonParams);
                HttpPost postRequest = new HttpPost(PrePayUrl);
                postRequest.setEntity(new StringEntity(jsonParams.toString(), "UTF-8"));
                HttpResponse httpResponse = httpclient.execute(postRequest);
                log.debug("httpResponse====>" + httpResponse.getStatusLine());
                int StatusCode = httpResponse.getStatusLine().getStatusCode();
                if (StatusCode != 200) {
                    log.debug("邢台银行服务平台连接错误，错误代码:" + StatusCode);
                    result.put("code", StatusCode);
                    result.put("error", "邢台银行服务平台连接错误，错误代码:" + StatusCode);
                    return result.toString();
                }
                HttpEntity entity = httpResponse.getEntity();
                String rs = EntityUtils.toString(entity, "UTF-8");
                log.debug("同步返回结果："+rs);
                JSONObject responseJson = new JSONObject(rs);
                log.debug("邢台银行下单返回结果：" + responseJson);
                if ("0000".equals(responseJson.get("respCode"))) {
                    JSONObject saveOrder = new JSONObject();
                    saveOrder.put("f_out_trade_no", txnOrderId);
                    saveOrder.put("f_attach", attach);
                    saveOrder.put("f_openid", openid);
                    saveOrder.put("f_order_state", "已下单");
                    saveOrder.put("f_order_type", "燃气收费");
                    saveOrder.put("flag", "JsApiPingXiang");
                    saveOrder.put("f_trade_type", "JSAPI");
                    saveOrder.put("f_filiale", filiale);
                    saveOrder.put("f_total_fee", txnAmt);
                    saveOrder.put("f_send_time", txnOrderTime);
                    saveOrder.put("f_userfiles_id", userfilesid);
                    // 保存分公司id
                    JSONObject clientConfig = Config.getClientConfig(filiale);
                    saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                    logicServer.run("savewxreturnxml", saveOrder);

                    result.put("code", 200);
                    result.put("msg", "SUCCESS");
                    result.put("f_out_trade_no", txnOrderId);
                    JSONObject payInfo= new JSONObject(responseJson.get("respData").toString());
                    result.put("appId", payInfo.getString("appId"));
                    result.put("timeStamp", payInfo.getString("timeStamp"));
                    result.put("signType", payInfo.getString("signType"));
                    result.put("package", payInfo.getString("package"));
                    result.put("nonceStr", payInfo.getString("nonceStr"));
                    result.put("paySign", payInfo.getString("paySign"));
                } else {
                    result.put("code", responseJson.get("respCode"));
                    result.put("error", "下单失败，失败原因:" + responseJson.get("respMsg").toString());
                }
            } catch (Exception e) {
                log.debug("下单异常，异常内容：" + e.getMessage());
            }
        } catch (Exception e) {
            log.debug("邢台银行下单异常错误", e);
        }
        return result.toString();
    }

    /**
     * 查询订单是否支付成功
     *
     * @param value
     * @return 订单支付结果
     */
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            // 编码方式,默认取值：UTF-8
            String encoding = "UTF-8";
            // 签名方式, 01：RSA；02：MD5；
            String signMethod = wxConfig.getString("signMethod");
            // aapId,SDK 或 API 编号
            String sdkAppId = wxConfig.getString("app_id");
            // 交易类型,1009
            String txnType = "1009";
            // 交易子类型,100900
            String txnSubType = "100900";
            // 商户编号,普通商户或一级商户的商户号
            String merId = wxConfig.getString("mer_id");
            // 原始商户交易流水号
            String origTxnOrderId = jsonObject.getString("out_trade_no");
            // 原始商户交易发送时间
            String origTxnOrderTime = jsonObject.getString("f_send_time");
            Map<String,Object> map = new HashMap<>();
            map.put("encoding", encoding);
            map.put("signMethod", signMethod);
            map.put("sdkAppId", sdkAppId);
            map.put("txnType", txnType);
            map.put("txnSubType", txnSubType);
            map.put("merId", merId);
            map.put("origTxnOrderId", origTxnOrderId);
            map.put("origTxnOrderTime", origTxnOrderTime);

            Gson gson = new Gson();
            // 证书路径
            String crePath = wxConfig.getString("crePath");
            String pfxPath = wxConfig.getString("pfxPath");
            String pfxPassWord = wxConfig.getString("pfxPassWord");

            boolean rsaSigndata = IfspSdkSecurityAtureUtil.RSASigndata(map, pfxPath, pfxPassWord);
            log.debug("rsaSigndata:" + rsaSigndata);
            String signature = (String) map.get(IfspSdkConstants.param_signature);
            log.debug("signature:" + signature);
            String requestMsg = JSON.toJSON(map).toString();
            Map respMsg = JSON.parseObject(requestMsg, Map.class);
            boolean rsaValidata= IfspSdkSecurityAtureUtil.RSAValidata(respMsg, crePath);
            log.debug("rsaValidata:" + rsaValidata);
            JSONObject jsonParams = new JSONObject(gson.toJson(map));
            HttpClient httpclient = new SSLClient();
            // 下单请求地址
            String queryUrl = wxConfig.getString("queryUrl");
            log.debug("邢台银行查询地址: {},查询参数: {}", queryUrl, jsonParams);
            HttpPost postRequest = new HttpPost(queryUrl);
            postRequest.setEntity(new StringEntity(jsonParams.toString(), "UTF-8"));
            HttpResponse httpResponse = httpclient.execute(postRequest);
            log.debug("httpResponse====>" + httpResponse.getStatusLine());
            int StatusCode = httpResponse.getStatusLine().getStatusCode();
            if (StatusCode != 200) {
                log.debug("邢台银行服务平台连接错误，错误代码:" + StatusCode);
                result.put("code", StatusCode);
                result.put("error", "邢台银行服务平台连接错误，错误代码:" + StatusCode);
                return result.toString();
            }
            HttpEntity entity = httpResponse.getEntity();
            String rs = EntityUtils.toString(entity, "UTF-8");
            log.debug("同步返回结果："+rs);
            JSONObject responseJson = new JSONObject(rs);
            log.debug("邢台银行查询返回结果：" + responseJson);

            if ("0000".equals(responseJson.get("respCode")) ) {
                // 0000-交易成功;0007/0005-待支付，0006-交易已关闭
                if ("0000".equals(responseJson.get("origRespCode"))) {
                    result.put("result_code", "SUCCESS");
                    result.put("trade_state", "SUCCESS");
                    // 订单号
                    result.put("transaction_id", responseJson.get("origRespTxnSsn"));
                    // 交易日期
                    result.put("time_end", responseJson.get("origTxnOrderTime"));
                    // 交易金额
                    result.put("total_fee",jsonObject.get("f_total_fee"));
                } else {
                    result.put("result_code", "FAIL");
                    result.put("return_msg", responseJson.opt("origRespMsg"));
                    log.debug("订单状态不等于已支付：" + responseJson.get("origRespCode"));
                }
            } else {
                result.put("result_code", "FAIL");
                result.put("return_msg", responseJson.get("respCode"));
                log.debug("查询订单异常：" + responseJson.get("respMsg"));
            }
        } catch (Exception e) {
            result.put("trade_state", "FAIL");
            log.debug("邢台银行查询订单异常：" + e);
        }
        return result.toString();
    }
}
