package com.aote.pay.psbc.mengzhou;

import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

public class HttpService {


    private RestTemplate restTemplate = new RestTemplate();

    public HttpEntity<Map<String, String>> generatePostJson(Map<String, String> jsonMap) {
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json;charset=UTF-8");
        httpHeaders.setContentType(type);
        return new HttpEntity<>(jsonMap, httpHeaders);
    }

    public String sendJsonPost(String uri, Map<String, String> jsonMap) {
        ResponseEntity<String> apiResponse = restTemplate.postForEntity(uri, generatePostJson(jsonMap), String.class);
        return apiResponse.getBody();
    }

    public String sendPost(String uri, String param) {
        ResponseEntity<String> apiResponse = restTemplate.postForEntity(uri, param, String.class);
        return apiResponse.getBody();
    }
}
