package com.aote.pay.icbc.weinan;

import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.util.PayUtil;
import com.aote.util.SignUtils;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@Slf4j
@Component
public class JsApiWeinan implements PaySuper {
    @Autowired
    private LogicServer logicServer;
    

    /**
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");

        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        String result = "";
        try {
            // 支付订单号
            String outTradeNo = PayUtil.getOutTradeNo();
            // 商户号
            String mchntNo = wxConfig.getString("mchnt_no");
            // 渠道ID
            String channelId = wxConfig.getString("channel_id");
            // 订单金额，单位为分
            String totalFee = String.valueOf(PayUtil.yuan2FenInt(money));
            // 支付方式
            String payCardType = wxConfig.getString("pay_card_type");

            Map<String, String> sqMap = new HashMap<>();
            sqMap.put("ORDER_NO", outTradeNo);
            sqMap.put("MCHNT_NO", mchntNo);
            sqMap.put("CHANNEL_ID", channelId);
            sqMap.put("PAY_AMT", totalFee);
            sqMap.put("PAY_CARD_TYPE", payCardType);
            sqMap.put("OPEN_ID", openid);

            // 签名原文
            String plain = SignUtils.plainStr(sqMap);
            log.debug("plain:" + plain);
            plain = URLEncoder.encode(plain, "UTF-8");

            // 签名
            SDKConfig paySDKConfig = new SDKConfig();
            // 签名证书路径
            String signCertPath = wxConfig.getString("sign_cert_path");
            // 签名证书名称
            String signCertName = wxConfig.getString("sign_cert_name");
            paySDKConfig.loadPropertiesFromPath(signCertPath, signCertName);
            CertUtil payCertUtil = new CertUtil(paySDKConfig, "");
            // 签名值
            SDKUtil.sign(sqMap, "UTF-8", payCertUtil);
            log.debug("initial signature:"+sqMap.get("signature"));

            String signature = sqMap.get("signature");
            // 公钥
            String signCertPub = wxConfig.getString("sign_cert_pub");
            // 请求路径
            String payUrl = wxConfig.getString("payUrl");
            sqMap.put(SDKConstants.param_signature, signature);
            try {
                boolean verSignResult = SDKUtil.validate(sqMap, "UTF-8", signCertPub);
                if (verSignResult) {
                    signature = URLEncoder.encode(signature, "UTF-8");
                    result = payUrl+plain+"&SIGNATURE="+signature;
                    log.debug("payUrl:" + result);

                    JSONObject saveOrder = new JSONObject();
                    saveOrder.put("f_out_trade_no", outTradeNo);
                    saveOrder.put("f_attach", attach);
                    saveOrder.put("f_openid", openid);
                    saveOrder.put("f_order_state", "已下单");
                    saveOrder.put("f_order_type", "燃气收费");
                    saveOrder.put("flag", "JsApiWeinan");
                    saveOrder.put("f_trade_type", "JSAPI");
                    saveOrder.put("f_filiale", filiale);
                    saveOrder.put("f_total_fee", totalFee);
                    // 保存分公司id
                    JSONObject clientConfig = Config.getClientConfig(filiale);
                    saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                    logicServer.run("savewxreturnxml", saveOrder);
                } else {
                    log.debug("验签失败");
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }catch (Exception e){
            log.debug("渭南西安银行下单异常错误", e);
        }
        return result;
    }

    /**
     * 查询订单是否支付成功
     *
     * @param value
     * @return 订单支付结果
     */
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            // 商户号
            String mchntNo = wxConfig.getString("mchnt_no");
            // 支付订单号
            String orderNo = jsonObject.getString("out_trade_no");
            // 查询地址
            String queryUrl = wxConfig.getString("queryUrl");
            Map<String, String>  sqMap = new HashMap<>();
            sqMap.put("ORDER_NO", orderNo);
            sqMap.put("MCHNT_NO", mchntNo);
            // 签名
            SDKConfig paySDKConfig = new SDKConfig();
            // 签名证书路径
            String signCertPath = wxConfig.getString("sign_cert_path");
            // 签名证书名称
            String signCertName = wxConfig.getString("sign_cert_name");
            paySDKConfig.loadPropertiesFromPath(signCertPath, signCertName);
            CertUtil payCertUtil = new CertUtil(paySDKConfig, "");
            // 签名值
            SDKUtil.sign(sqMap, "UTF-8", payCertUtil);

            String sendMsg = "{'ORDER_NO':'" + orderNo + "','MCHNT_NO':'" + mchntNo + "','SIGNATURE':'" + sqMap.get("signature") + "'}";
            log.debug("渭南西安银行查询参数:" + sendMsg);

            URL url = new URL(queryUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/xml");
            connection.setRequestProperty("Connection", "Keep-Alive");
            connection.setRequestProperty("Charset", "UTF-8");
            DataOutputStream dos = new DataOutputStream(connection.getOutputStream());
            dos.writeBytes(sendMsg);
            dos.flush();
            dos.close();
            int resultCode = connection.getResponseCode();
            log.debug("resultCode:" + resultCode);
            if(HttpURLConnection.HTTP_OK==resultCode){
                StringBuffer sb = new StringBuffer();
                String readLine = new String();
                BufferedReader responseReader=new BufferedReader(new InputStreamReader(connection.getInputStream(),"UTF-8"));
                while((readLine=responseReader.readLine())!=null){
                    sb.append(readLine).append("\n");
                }
                responseReader.close();
                log.debug("返回信息: {}", sb.toString());
                JSONObject jsonResult = new JSONObject(sb.toString());
                if ("0000".equals(jsonResult.get("H_RSP_CODE"))) {
                    // ORDER_STATUS订单状态
                    // 0:正在支付（可疑）1:支付成功 2:支付失败 3:正在撤销/退款 4:已退款 5:已撤销 6:已关闭 7:未支付 8:部分退款
                    if ("1".equals(jsonResult.get("ORDER_STATUS"))) {
                        result.put("result_code", "SUCCESS");
                        result.put("trade_state", "SUCCESS");
                        // 订单号
                        result.put("transaction_id", jsonResult.get("PAY_LOG_ID"));
                        // 交易日期
                        result.put("time_end",  jsonResult.get("PAY_TIME"));
                        // 交易金额
                        result.put("total_fee", jsonResult.get("ORDER_AMT"));
                    } else {
                        result.put("result_code", "FAIL");
                        result.put("return_msg", jsonResult.get("H_RSP_MSG"));
                        log.debug("订单状态不等于已支付：" + jsonResult.get("ORDER_STATUS"));
                    }
                } else {
                    result.put("result_code", "FAIL");
                    result.put("return_msg", jsonResult.get("H_RSP_MSG"));
                    log.debug("操作失败原因：" + jsonResult.get("H_RSP_MSG"));
                }
            }
        }catch (Exception e) {
            result.put("trade_state", "FAIL");
            log.debug("西安银行查询订单异常：" + e);
        }
        log.debug("最终结果信息: {}", result.toString());
        return result.toString();
    }
}
