package com.aote.pay.icbc.shanggaoshunming;


import TestClass.HttpRequest;
import TestClass.Signature;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.sql.SqlServer;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;


@Slf4j
@Component
public class JsApiShunMing implements PaySuper, RefundSuper {

    @Autowired
    private LogicServer logicServer;

    @Autowired
    private SqlServer sqlServer;
    

    // 版本号,固定填写
    String version = "1.0.0";
    // 编码方式,固定填写
    String encode = "UTF-8";

    /**
     * 上高顺民 - 江西银行
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        String userfilesid = json.getString("userfilesid");

        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            // 交易代码,固定填写
            String trtype = "GP00011";
            // 交易日期，格式为yyyyMMdd
            String trdate = new SimpleDateFormat("yyyyMMdd").format(new Date());
            // 交易时间，格式为hhmmss
            String trtime = new SimpleDateFormat("hhmmss").format(new Date());
            String subcode = "guokai.gpay.busConsumeByParam";
            // 交易流水号
            String serialno = PayUtil.getOutTradeNo();
            // 商户号
            String busino = wxConfig.getString("busino");
            // 0-小程序 1-公众号
            String param_type = wxConfig.getString("param_type");
            // 商户的公众号/小程序appid
            String sub_appid = wxConfig.getString("appId");
            // 商户订单号，商户端保证唯一
            String orderno = PayUtil.getOrderNoByNumber();
            // 订单金额，单位为分
            String amt_trans = String.valueOf(PayUtil.yuan2FenInt(money));
            // 货币代码，默认156
            String currency = "156";
            // 订单主题
            String ordertitle = wxConfig.getString("ordertitle");
            // 商品描述
            String orderdesc = wxConfig.getString("orderdesc");
            // 前台返回商户结果时使用
            String return_url = wxConfig.getString("return_url");
            // 异步通知商户URL，端口必须 为443或80
            String notify_url = wxConfig.getString("wechatNotify");
            // 渠道类型,07-PC 08-WAP
            String channel_type = wxConfig.getString("channel_type");
            // 确认收货标志, 0线上确认收货，8线上待收货(暂不启用)，9线下免确认收货 默认请填9
            String confflag = wxConfig.getString("confflag");
            // 签名方式，固定填写
            String sign_type = "RSA";

            // 验签字段
            Map<String, String> map = new HashMap<>();
            map.put("version", version);
            map.put("encode", encode);
            map.put("trdate", trdate);
            map.put("trtime", trtime);
            map.put("trtype", trtype);
            map.put("subcode", subcode);
            map.put("serialno", serialno);
            map.put("busino", busino);
            map.put("param_type", param_type);
            map.put("sub_appid", sub_appid);
            map.put("sub_openid", openid);
            map.put("orderno", orderno);
            map.put("amt_trans", amt_trans);
            map.put("currency", currency);
            map.put("ordertitle", ordertitle);
            map.put("orderdesc", orderdesc);
            map.put("notify_url", notify_url);
            map.put("return_url", return_url);
            map.put("channel_type", channel_type);
            map.put("confflag", confflag);
            map.put("sign_type", sign_type);

            // 公钥
            String publicKey = wxConfig.getString("publicKey");
            // 私钥
            String privateKey = wxConfig.getString("privateKey");
            //
            String apiKey = wxConfig.getString("apiKey");

            Signature signature = new Signature();
            String signMsg = signature.rsa256Sign(map, apiKey, privateKey);
            if (!signMsg.isEmpty()) {
                log.debug("报文加签成功，签名值：" + signMsg);
            } else {
                log.debug("报文加签失败！！");
            }
            map.put("sign", signMsg);
            // 下单地址
            String payUrl = wxConfig.getString("payUrl");
            log.debug("江西银行下单地址: {},下单参数: {}", payUrl, HttpRequest.getParamStr(map));
            try {
                String response = HttpRequest.sendPost(payUrl, HttpRequest.getParamStr(map));
                JSONObject responsejson = new JSONObject();
                String[] res = response.split("&");
                for (String re : res) {
                    int split = re.indexOf('=');
                    String key = re.substring(0, split);
                    String value = re.substring(split + 1);
                    responsejson.put(key, value);
                }
                log.debug("江西银行下单返回数据: {}", responsejson);
                if ("00000".equals(responsejson.getString("respcode"))) {
                    JSONObject saveOrder = new JSONObject();
                    saveOrder.put("f_out_trade_no", orderno);
                    saveOrder.put("f_serialno", serialno);
                    saveOrder.put("f_attach", attach);
                    saveOrder.put("f_openid", openid);
                    saveOrder.put("f_order_state", "已下单");
                    saveOrder.put("f_order_type", "燃气收费");
                    saveOrder.put("f_trdate", trdate);
                    saveOrder.put("f_trtime", trdate);
                    saveOrder.put("flag", "JsApiShunMing");
                    saveOrder.put("f_trade_type", "JSAPI");
                    saveOrder.put("f_filiale", filiale);
                    saveOrder.put("f_total_fee", String.valueOf(PayUtil.yuan2FenInt(money)));
                    saveOrder.put("f_userfiles_id", userfilesid);
                    // 保存分公司id
                    JSONObject clientConfig = Config.getClientConfig(filiale);
                    saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                    logicServer.run("savewxreturnxml", saveOrder);

                    result.put("appId", responsejson.getString("appId"));
                    result.put("timeStamp", responsejson.getString("timeStamp"));
                    result.put("signType", responsejson.getString("signType"));
                    result.put("package", "prepay_id=" + responsejson.getString("package"));
                    result.put("nonceStr",responsejson.getString("nonceStr"));
                    result.put("paySign", responsejson.getString("paySign"));
                    result.put("out_trade_no", responsejson.getString("orderno"));
                }
            } catch (Exception var9) {
                var9.printStackTrace();
            }
        } catch (Exception e) {
            log.debug("江西银行下单异常错误", e);
        }
        return result.toString();
    }
    /**
     * 查询订单是否支付成功
     *
     * @param value
     * @return 订单支付结果
     */
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));

            Integer id = jsonObject.getInt("id");
            // 交易代码,固定填写
            String trtype = "GP00063";
            // 交易日期，格式为yyyyMMdd
            String trdate = jsonObject.getString("f_trdate");
            // 交易时间，格式为hhmmss
            String trtime = jsonObject.getString("f_trtime");
            // 固定
            String subcode = "guokai.gpay.consumeQuery";
            // 交易流水号
            String serialno = jsonObject.getString("f_serialno");
            // 商户号
            String busino = wxConfig.getString("busino");
            // 商户订单号
            String orderno = jsonObject.getString("out_trade_no");

            // 签名方式，固定填写
            String sign_type = "RSA";

            // 验签字段
            LinkedHashMap<String, String> map = new LinkedHashMap<>();
            map.put("version", version);
            map.put("encode", encode);
            map.put("trdate", trdate);
            map.put("trtime", trtime);
            map.put("trtype", trtype);
            map.put("subcode", subcode);
            map.put("serialno", serialno);
            map.put("busino", busino);
            map.put("orderno", orderno);
            map.put("sign_type", sign_type);

            // 公钥
            String publicKey = wxConfig.getString("publicKey");
            // 私钥
            String privateKey = wxConfig.getString("privateKey");
            //
            String apiKey = wxConfig.getString("apiKey");

            Signature signature = new Signature();
            String signMsg = signature.rsa256Sign(map, apiKey, privateKey);
            if (!signMsg.isEmpty()) {
                log.debug("报文加签成功，签名值：" + signMsg);
            } else {
                log.debug("报文加签失败！！");
            }
            map.put("sign", signMsg);

            // 下单地址
            String queryUrl = wxConfig.getString("queryUrl");
            log.debug("江西银行查询地址: {},查询参数: {}", queryUrl, new JSONObject(map));

            try {
                String response = HttpRequest.sendPost(queryUrl, HttpRequest.getParamStr(map));
                JSONObject responsejson = new JSONObject();
                String[] res = response.split("&");
                for (String re : res) {
                    int split = re.indexOf('=');
                    String key = re.substring(0, split);
                    String val = re.substring(split + 1);
                    responsejson.put(key, val);
                }
                log.debug("江西银行查询返回信息: {}", responsejson);
                if ("00000".equals(responsejson.getString("respcode"))) {
                    // 支付状态，0 处理成功  9 初始状态  1待支付返回/状态未知  4-支付结果为失败
                    if ("0".equals(responsejson.getString("status"))) {
                        result.put("result_code", "SUCCESS");
                        result.put("trade_state", "SUCCESS");
                        this.sqlServer.runSQL("update t_weixinreturnxml set f_imp_tradeno ='"+responsejson.getString("imp_tradeno")+"',f_transno = '" + responsejson.getString("transno") + "' where id = '" + id + "'");
                        // 订单号
                        result.put("transaction_id", orderno);
                        // 交易日期
                        result.put("time_end", responsejson.getString("transdate") + responsejson.getString("transtime"));
                        // 交易金额
                        result.put("total_fee", responsejson.getString("amt_trans"));
                    } else {
                        result.put("result_code", "FAIL");
                        result.put("return_msg", responsejson.getString("status"));
                        log.debug("订单状态不等于已支付：" + responsejson.getString("status"));
                    }
                } else {
                    result.put("result_code", "FAIL");
                    result.put("return_msg", responsejson.getString("respmsg"));
                    log.debug("查询失败", responsejson.getString("respmsg"));
                }
            } catch (Exception var9) {
                log.error("操作失败：原因" + var9.getMessage());
                result.put("result_code", "FAIL");
                result.put("return_msg", "系统异常");
                var9.printStackTrace();
            }
        } catch (Exception e) {
            result.put("trade_state", "FAIL");
            log.debug("工行查询订单异常：" + e);
        }
        return result.toString();
    }

    @Override
    public String refund(JSONObject json) {
        String filiale = json.getString("f_filiale");
        Integer id = json.getInt("id");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            // 交易代码,固定填写
            String trtype = "GP00011";
            // 交易日期，格式为yyyyMMdd
            String trdate = new SimpleDateFormat("yyyyMMdd").format(new Date());
            // 交易时间，格式为hhmmss
            String trtime = new SimpleDateFormat("hhmmss").format(new Date());
            String subcode = "guokai.gpay.refund";
            // 交易流水号
            String serialno =  PayUtil.getOutTradeNo();
            // 商户号
            String busino = wxConfig.getString("busino");
            // 商户订单号，商户端保证唯一
            String orderno = json.getString("f_out_trade_no");
            // 商户退款单号，商户端保证唯一
            String refundno =  PayUtil.getOrderNoByNumber();
            // 原交易平台返回的流水号
            String prv_tradeno = json.getString("f_imp_tradeno");
            // 原交易平台返回的订单号
            String prv_transno = json.getString("f_transno");
            // 原交易时间
            String prv_trdate = json.getString("f_trdate");
            // 原交易金额
            Integer prv_tramt = json.getInt("f_total_fee");
            // 操作类型 1 撤销交易当天全额退款 2.退货退款可分批退
            String opertype = "2";
            // 退款金额
            Integer refund_amt  = json.getInt("f_total_fee");
            // 货币代码，默认156
            String currency = "156";
            // 签名方式，固定填写
            String sign_type = "RSA";
            // 验签字段
            Map<String, String> map = new HashMap<>();
            map.put("version", version);
            map.put("encode", encode);
            map.put("trdate", trdate);
            map.put("trtime", trtime);
            map.put("trtype", trtype);
            map.put("subcode", subcode);
            map.put("serialno", serialno);
            map.put("busino", busino);
            map.put("orderno", orderno);
            map.put("refundno",refundno);
            map.put("prv_transno",prv_transno);
            map.put("prv_tradeno",prv_tradeno);
            map.put("prv_trdate",prv_trdate);
            map.put("prv_tramt",prv_tramt.toString());
            map.put("opertype",opertype);
            map.put("refund_amt",refund_amt.toString());
            map.put("currency", currency);
            map.put("sign_type", sign_type);
            // 公钥
            String publicKey = wxConfig.getString("publicKey");
            // 私钥
            String privateKey = wxConfig.getString("privateKey");
            //
            String apiKey = wxConfig.getString("apiKey");

            Signature signature = new Signature();
            String signMsg = signature.rsa256Sign(map, apiKey, privateKey);
            if (!signMsg.isEmpty()) {
                log.debug("报文加签成功，签名值：" + signMsg);
            } else {
                log.debug("报文加签失败！！");
            }
            map.put("sign", signMsg);
            // 下单地址
            String refundUrl = wxConfig.getString("refundUrl");
            log.debug("江西银行退款地址: {},退款参数: {}", refundUrl, HttpRequest.getParamStr(map));
            try {
                String response = HttpRequest.sendPost(refundUrl, HttpRequest.getParamStr(map));
                JSONObject responsejson = new JSONObject();
                String[] res = response.split("&");
                for (String re : res) {
                    int split = re.indexOf('=');
                    String key = re.substring(0, split);
                    String value = re.substring(split + 1);
                    responsejson.put(key, value);
                }
                log.debug("江西银行退款返回数据: {}", responsejson);

                if ("4".equals(responsejson.getString("refund_status"))) {
                    result.put("result_msg", "退款失败");
                    result.put("trade_state", "N");

                } else  {
                    JSONObject saveOrder = new JSONObject();
                    saveOrder.put("id", id);
                    saveOrder.put("f_refund_no",refundno);
                    saveOrder.put("f_serialno", serialno);
                    saveOrder.put("f_trdate", trdate);
                    saveOrder.put("f_trtime", trdate);

                    switch (responsejson.getString("refund_status")) {
                        case "0":
                            result.put("result_msg", "退款成功");
                            result.put("trade_state", "Y");
                            saveOrder.put("f_order_state", "已退款");
                            break;
                        default:
                            result.put("result_msg", "退款中");
                            result.put("trade_state", "Y");
                            saveOrder.put("f_order_state", "退款中");
                    }

                    logicServer.run("savewxreturnxml", saveOrder);
                }
            } catch (Exception var9) {
                var9.printStackTrace();
            }
        } catch (Exception e) {
            log.debug("江西银行退款异常错误", e);
        }
        return result.toString();
    }


    /**
     * 查询订单是否退款成功
     *
     * @param value
     * @return 订单退款结果
     */
    @Override
    public String refundOrderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询退款订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));

            // 交易代码,固定填写
            String trtype = "GP00063";
            // 交易日期，格式为yyyyMMdd
            String trdate = jsonObject.getString("f_trdate");
            // 交易时间，格式为hhmmss
            String trtime = jsonObject.getString("f_trtime");
            // 固定
            String subcode = "guokai.gpay.refundquery";
            // 交易流水号
            String serialno = jsonObject.getString("f_serialno");
            // 商户号
            String busino = wxConfig.getString("busino");
            String refundno = jsonObject.getString("f_refund_no");
            // 商户订单号
            String orderno = jsonObject.getString("f_out_trade_no");
            // 平台原订单号
            String prv_transno = jsonObject.getString("f_transno");

            Integer id = jsonObject.getInt("id");

            // 签名方式，固定填写
            String sign_type = "RSA";

            // 验签字段
            LinkedHashMap<String, String> map = new LinkedHashMap<>();
            map.put("version", version);
            map.put("encode", encode);
            map.put("trdate", trdate);
            map.put("trtime", trtime);
            map.put("trtype", trtype);
            map.put("subcode", subcode);
            map.put("serialno", serialno);
            map.put("busino", busino);
            map.put("refundno", refundno);
            map.put("orderno", orderno);
            map.put("prv_transno", prv_transno);
            map.put("sign_type", sign_type);

            // 公钥
            String publicKey = wxConfig.getString("publicKey");
            // 私钥
            String privateKey = wxConfig.getString("privateKey");
            //
            String apiKey = wxConfig.getString("apiKey");

            Signature signature = new Signature();
            String signMsg = signature.rsa256Sign(map, apiKey, privateKey);
            if (!signMsg.isEmpty()) {
                log.debug("报文加签成功，签名值：" + signMsg);
            } else {
                log.debug("报文加签失败！！");
            }
            map.put("sign", signMsg);

            // 下单地址
            String queryUrl = wxConfig.getString("queryUrl");
            log.debug("江西银行查询地址: {},查询参数: {}", queryUrl, new JSONObject(map));

            try {
                String response = HttpRequest.sendPost(queryUrl, HttpRequest.getParamStr(map));
                JSONObject responsejson = new JSONObject();
                String[] res = response.split("&");
                for (String re : res) {
                    int split = re.indexOf('=');
                    String key = re.substring(0, split);
                    String val = re.substring(split + 1);
                    responsejson.put(key, val);
                }
                log.debug("江西银行查询返回信息: {}", responsejson);
                if ("00000".equals(responsejson.getString("respcode"))) {
                    // 支付状态，0 处理成功  9 初始状态  1待支付返回/状态未知  4-支付结果为失败
                    if ("0".equals(responsejson.getString("status"))) {
                        this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已退款' where id = '" + id + "'");
                        this.sqlServer.runSQL("update t_bank_payment set f_state ='无效' where f_trade_number = '"+ jsonObject.getString("f_out_trade_no") +"'");
                        result.put("result_msg", "退款成功");
                        result.put("result_msg", "退款成功");
                        // 订单号
                        result.put("transaction_id", responsejson.getString("chn_tradeno"));
                        // 交易日期
                        result.put("time_end", responsejson.getString("transdate") + responsejson.getString("transtime"));
                        // 交易金额
                        result.put("total_fee", responsejson.getString("amt_trans"));
                        log.debug(result.toString());
                    } else if ("1".equals(responsejson.getString("status"))||"9".equals(responsejson.getString("status"))) {
                        result.put("return_msg", "退款处理中");
                        log.debug("订单状态不等于已支付：" + responsejson.getString("status"));
                    } else if ("4".equals(responsejson.getString("status"))) {
                        this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已支付' where id = '" + id + "'");
                        result.put("return_msg", "退款失败");
                    }
                } else {
                    this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已支付' where id = '" + id + "'");
                    result.put("return_msg", responsejson.getString("respmsg"));
                    log.debug("查询失败", responsejson.getString("respmsg"));
                }
            } catch (Exception var9) {
                this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已支付' where id = '" + id + "'");
                log.error("操作失败：原因" + var9.getMessage());
                result.put("return_msg", "系统异常");
                var9.printStackTrace();
            }
        } catch (Exception e) {
            result.put("return_msg", "查询失败");
            log.debug("工行查询订单异常：" + e);
        }
        return result.toString();
    }

    @Override
    public JSONObject getRecordFile(JSONObject json) {
        return null;
    }
}
