package com.aote.pay.icbc.meitan;


import com.alibaba.fastjson.JSON;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;


@Slf4j
@Component
public class JsApiMeitan implements PaySuper {

    @Autowired
    private LogicServer logicServer;
    

    /**
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        String userfilesid = json.getString("userfilesid");
//        String userinfoCode = json.getString("userinfoCode");
//        String username = json.getString("username");
//        String phone= json.getString("phone");

        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        String result = "";
        try {
            // 发起渠道编号(由建行指定)
            String ittPartyStmID = wxConfig.getString("ittPartyStmID");
            // 发起方时间戳(yyyymmddhhmmssfff年月日时分秒毫秒)
            String timestamp = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            // 商户订单号
            String outTradeNo = PayUtil.getOutTradeNo();
            log.debug("outTradeNo:" + outTradeNo);
            // 支付渠道代码(1PC网站 2APP 3H5 4大厅收银台 5自助终端 8微信小程序 d支付宝小程序）
            String pyChnlCd = "1";
            // 请求支付类型(0-收银台 1-二维码串 2-支付参数JSON串（非空时参与验签支付渠道为8或d时上送）)
            String rqsPyTp = "0";
            // 线上线下标志代码(1-线上支付 2-线下支付（POS、现金）)
            String onLnOflnIndCd = "1";
            // 商品订单号
            String cmdtyOrdrNo = PayUtil.getOutTradeNo() + "110";
            log.debug("cmdtyOrdrNo:" + cmdtyOrdrNo);
            // 支付完跳转链接
            String returnUrl = wxConfig.getString("returnUrl") + openid + "&filiale=" + filiale;
            // 总金额
            BigDecimal tAmt = new BigDecimal(money);
            // 公钥
            String pubkey = wxConfig.getString("pubKey");
            // 私钥
            String privekey = wxConfig.getString("priveKey");

            //创建下单对象
            PayMentInVo payMentInVo = new PayMentInVo();
            payMentInVo.setIttPartyStmId(ittPartyStmID);
            payMentInVo.setIttPartyTms(timestamp);
            payMentInVo.setIttPartyJrnlNo(outTradeNo);
            payMentInVo.setPyChnlCd(pyChnlCd);
            payMentInVo.setRqsPyTp(rqsPyTp);
            payMentInVo.setOnlnOflnIndCd(onLnOflnIndCd);
            payMentInVo.setCmdtyOrdrNo(cmdtyOrdrNo);
            payMentInVo.setPgFcRetUrlAdr(returnUrl);
            payMentInVo.settAmt(tAmt);
            //  不传这个三个参数了
//            payMentInVo.setUsrId(userinfoCode);
//            payMentInVo.setCstNm(username);
//            payMentInVo.setMblPhNo(phone);

            // 序号
            String sn = "1";
            // 费项代码
            String feeItmCd = wxConfig.getString("feeItmCd");

            // 子订单
            List<FeeGrpVo> feeGrpVos = new ArrayList<>();
            FeeGrpVo feeGrpVo1 = new FeeGrpVo();
            feeGrpVo1.setSn(sn);
            feeGrpVo1.setFeeItmCd(feeItmCd);
            feeGrpVo1.setFeeItmPrjAmt(tAmt);
            feeGrpVos.add(feeGrpVo1);
            payMentInVo.setFeeGrpVoList(feeGrpVos);

            Set<String> set = new HashSet<>();
            set.add("FEEGRP");

            // 加密签名
            String[] sign = EncryDemo.newRequestZrzfDncryptParam(JSON.toJSONString(payMentInVo), set, privekey, pubkey);
            // 封装发送实体
            BaseVo baseVo = new BaseVo();
            // 发起方渠道编号  即政融分配的多实体
            baseVo.setIttPartySysId(ittPartyStmID);
            baseVo.setBsnData(sign[0]);
            baseVo.setTprtParm(sign[1]);
            // 下单地址
            String payUrl = wxConfig.getString("payUrl");
            log.debug("政融下单地址: {},加密前下单参数: {}", payUrl, new JSONObject(payMentInVo));
            // 发送请求下单
            String responseStr = HttpUtil.doJsonPost(payUrl, JSON.toJSONString(baseVo));

            // 解密验签
            Set<String> setRe = new HashSet<>();
            com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject(responseStr);
            String response = EncryDemo.decryption(jsonObject.getString("Tprt_Parm"), setRe, jsonObject.getString("Bsn_Data"), privekey, pubkey);
            JSONObject responsejson = new JSONObject(response);
            log.debug("政融支付下单返回信息: {}", responsejson);
            if ("00".equals(responsejson.getString("Svc_Rsp_St"))) {
                result = responsejson.getString("Py_URL");
                JSONObject saveOrder = new JSONObject();
                saveOrder.put("f_out_trade_no", cmdtyOrdrNo);
                saveOrder.put("f_attach", attach);
                saveOrder.put("f_openid", openid);
                saveOrder.put("f_order_state", "已下单");
                saveOrder.put("f_order_type", "燃气收费");
                saveOrder.put("flag", "JsApiMeitan");
                saveOrder.put("f_trade_type", "JSAPI");
                saveOrder.put("f_filiale", filiale);
                saveOrder.put("f_total_fee", String.valueOf(PayUtil.yuan2FenInt(money)));
                saveOrder.put("f_userfiles_id", userfilesid);
                // 保存分公司id
                JSONObject clientConfig = Config.getClientConfig(filiale);
                saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                logicServer.run("savewxreturnxml", saveOrder);
            }
        } catch (Exception e) {
            log.debug("政融支付下单异常错误", e);
        }
        return result;
    }


    /**
     * 查询订单是否支付成功
     *
     * @param value
     * @return 订单支付结果
     */
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            // 商户订单号
            String cmdtyOrdrNo = jsonObject.getString("out_trade_no");
            PayResultVo payResult = new PayResultVo();
            payResult.setCmdtyOrdrNo(cmdtyOrdrNo);

            // 公钥
            String pubkey = wxConfig.getString("pubKey");
            // 私钥
            String privekey = wxConfig.getString("priveKey");
            // 发起渠道编号(由建行指定)
            String ittPartyStmID = wxConfig.getString("ittPartyStmID");

            Set<String> set = new HashSet<>();
            //加密签名
            String[] sign = EncryDemo.newRequestZrzfDncryptParam(JSON.toJSONString(payResult), set, privekey, pubkey);

            //封装发送实体
            BaseVo baseVo = new BaseVo();
            //发起方渠道编号  即政融分配的多实体
            baseVo.setIttPartySysId(ittPartyStmID);
            baseVo.setBsnData(sign[0]);
            baseVo.setTprtParm(sign[1]);
            // 查询地址
            String queryUrl = wxConfig.getString("queryUrl");
            log.debug("政融查询地址: {},查询参数: {}", queryUrl, new JSONObject(payResult));

            //发送请求下单
            String responseStr = HttpUtil.doJsonPost(queryUrl, JSON.toJSONString(baseVo));

            //解密验签
            Set<String> setRe = new HashSet<>();
            setRe.add("LIST1");
            com.alibaba.fastjson.JSONObject json = JSON.parseObject(responseStr);
            String response = EncryDemo.decryption(json.getString("Tprt_Parm"), setRe, json.getString("Bsn_Data"), privekey, pubkey);
            JSONObject responsejson = new JSONObject(response);
            log.debug("政融支付查询返回信息: {}", responsejson);
            // 服务响应状态 00成功  01失败
            if ("00".equals(responsejson.getString("Svc_Rsp_St"))) {
                // 支付状态代码 1待支付 2成功 3失败 4不确定
                if ("2".equals(responsejson.getString("Py_StCd"))) {
                    // 订单状态代码 1-待缴费 2-成功 3-失败 4-全部退费 5-部分退费 6-失效 9-取消 a-处理中 b-待冲正 c-待系统退款 d-已落地
                    if ("2".equals(responsejson.getString("Ordr_StCd"))) {
                        result.put("result_code", "SUCCESS");
                        result.put("trade_state", "SUCCESS");
                        // 订单号
                        result.put("transaction_id", responsejson.getString("Py_Ordr_No"));
                        // 交易日期
                        result.put("time_end", responsejson.getString("Ordr_Gen_Tm"));
                        // 交易金额
                        String TAmt = String.valueOf(responsejson.get("TAmt"));
                        String money = String.valueOf(PayUtil.yuan2FenInt(TAmt));
                        result.put("total_fee", money);
                    } else {
                        result.put("result_code", "FAIL");
                        result.put("return_msg", responsejson.getString("Ordr_StCd"));
                        log.debug("订单状态不等于已支付：" + responsejson.getString("Ordr_StCd"));
                    }
                } else {
                    result.put("result_code", "FAIL");
                    result.put("return_msg", responsejson.getString("Py_StCd"));
                    log.debug("支付状态不等于已支付：" + responsejson.getString("Py_StCd"));
                }
            } else {
                result.put("result_code", "FAIL");
                result.put("return_msg", responsejson.getString("Rsp_Inf"));
                log.debug("服务响应状态失败，响应码为:" + responsejson.getString("Svc_Rsp_St"));
            }
        } catch (Exception e) {
            result.put("trade_state", "FAIL");
            log.debug("政融支付查询订单异常：" + e);
        }
        return result.toString();
    }
}
