package com.aote.pay.icbc.gaomi;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.sql.SqlServer;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcApiException;
import com.icbc.api.IcbcConstants;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONArray;
import com.icbc.api.request.MybankPayQrcodeScannedPayRequestV2;
import com.icbc.api.request.MybankPayQrcodeScannedPaystatusRequestV2;
import com.icbc.api.response.MybankPayQrcodeScannedPaystatusResponseV2;
import com.icbc.api.response.MybankQrcodeScannedPayResponseV2;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @Author 张琪
 * @Date 2021/3/16 18:46
 * @Version 1.0
 * @describe icbc-高密被扫
 */
@Slf4j
@Component
public class MicroPayGaoMi implements PaySuper {

    @Autowired
    private LogicServer logicServer;

    @Autowired
    private SqlServer sqlServer;
    

    /**
     * 高密被扫支付接口
     * @param json 包含授权码等相关信息的json对象
     * @return 订单状态
     */
    @Override
    public String prePay(JSONObject json) {
//        分公司名称, 最终传入为 gaomi
        String filiale = String.valueOf(json.get("filiale"));

        if (filiale == null || filiale.length() == 0) {
            throw new RuntimeException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
//         私钥
        String MY_PRIVATE_KEY = wxConfig.getString("privateKey");
        System.out.println("私钥" + MY_PRIVATE_KEY);
//         公钥
        String APIGW_PUBLIC_KEY = wxConfig.getString("pubKey");
        System.out.println("公钥" + APIGW_PUBLIC_KEY);
//         APP_ID
        String APP_ID =  wxConfig.getString("app_id");
        System.out.println("app_id" + APP_ID);
//         签名类型为RSA2时，需传入appid，私钥和网关公钥，签名类型使用定值IcbcConstants.SIGN_TYPE_RSA2，其他参数使用缺省值
        DefaultIcbcClient client = new DefaultIcbcClient(APP_ID, IcbcConstants.SIGN_TYPE_RSA2, MY_PRIVATE_KEY, APIGW_PUBLIC_KEY);
        MybankPayQrcodeScannedPayRequestV2 request = new MybankPayQrcodeScannedPayRequestV2();
//         根据测试环境和生产环境替换相应ip和端口
        request.setServiceUrl(wxConfig.getString("requestUrl"));

//        组织请求参数
        String merId = wxConfig.getString("mer_id");

//        用户付款码
        String authCode = String.valueOf(json.get("auth_code"));

//        订单号
        String outTradeNo = PayUtil.getOutTradeNo();

//        交易日期
        String tradeDate = new SimpleDateFormat("yyyyMMdd").format(new Date());

//        交易时间
        String tradeTime = new SimpleDateFormat("hhmmss").format(new Date());

//        附加信息, 非必填(这里为表具传来的信息)
        String attach = String.valueOf(json.get("attach"));;

//        交易金额, 单位为分(传递过来的金额为元, 在这里转化为分)
        String money = String.valueOf(json.get("money"));
        String orderAmt = new BigDecimal(money).multiply(new BigDecimal("100")).setScale(0).toString();

//        子商户应用号, 非必填
        String subAppId = "";

//        订单优惠标识, 非必填
        String goodsTag = "";

//        单品优惠活动
        JSONArray goodsDetail = null;

//         请对照接口文档用bizContent.setxxx()方法对业务上送数据进行赋值
        MybankPayQrcodeScannedPayRequestV2.MybankPayQrcodeScannedPayRequestV2Biz bizContent = new MybankPayQrcodeScannedPayRequestV2.MybankPayQrcodeScannedPayRequestV2Biz();
        bizContent.setMerId(merId); //商户编号
        bizContent.setQrCode(authCode); //付款码
        bizContent.setOutTradeNo(outTradeNo); //外部订单号
        bizContent.setTradeDate(tradeDate); //交易日期  格式:YYYYMMDD
        bizContent.setTradeTime(tradeTime); //交易时间 hhmmss
//        bizContent.setAttach(attach); //商户附加信息, 非必填
        bizContent.setOrderAmt(orderAmt); //交易金额
//        bizContent.setSubAppId(subAppId); //子商户应用号, 非必填
//        bizContent.setGoodsTag(goodsTag);  //优惠标志, 非必填
//        bizContent.setGoodsDetail(goodsDetail);//单品优惠活动, 非必填
        request.setBizContent(bizContent);
        ObjectMapper mapper = new ObjectMapper();
        try {
            String requestJson = mapper.writeValueAsString(request);
            log.debug("请求信息为:{}",requestJson);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        MybankQrcodeScannedPayResponseV2 response;
//        作为结果返回给调用者
        JSONObject result = new JSONObject();
        try {
            response = client.execute(request, "msgId3");//msgId消息通讯唯一编号，要求每次调用独立生成，APP级唯一
            String responseJson = mapper.writeValueAsString(response);
            log.info("响应为:{}",responseJson);
            log.debug("响应码为: {}, 响应信息为:{}",response.getReturnCode(), response.getReturnMsg());
            if (response.getReturnCode() == 0) {
//                业务成功处理
                log.debug("response:" + JSON.toJSONString(response));
                result.put("f_out_trade_no", outTradeNo);
                JSONObject saveOrder = new JSONObject();
//                订单状态
                switch (response.getPayStatus()){
                    case -1:
//                        下单失败
                        throw new RuntimeException("付款码下单失败,银行返回信息:" + response);
                    case 0:
//                        支付中
                        saveOrder.put("f_order_state", "待查询");
                        result.put("result_msg", "支付结果未知");
                        break;
                    case 1:
//                        支付成功
                        saveOrder.put("f_order_state", "已支付");
                        result.put("result_msg", "支付确认成功");
                        break;
                    case 2:
//                        支付失败
                        result.put("result_msg", "支付确认失败");
                        break;
                }
//                二维码状态
                String channel = null;
                switch (response.getChannel()){
                    case 91:
                        channel = "微信";break;
                    case 92:
                        channel = "支付宝";break;
                    case 93:
                        channel = "银联";break;
                    case 99:
                        channel = "工银";break;
                    case 94:
                        channel = "数字人民币";break;
                    default:
                        channel = "未知";
                }
                result.put("qrcodetype", channel);
//                保存订单相关信息到中间表
                JSONObject param = new JSONObject(attach);
                String userFilesId = param.optString("f_userfiles_id", "");
                saveOrder.put("f_out_trade_no", outTradeNo);
                saveOrder.put("f_transaction_id", outTradeNo);
                saveOrder.put("f_attach", attach);
                saveOrder.put("f_order_type", "燃气收费");
                saveOrder.put("flag", "MicroPayGaoMi");
                saveOrder.put("f_trade_type", "MICROPAY");
                saveOrder.put("f_bank_type", channel);
                saveOrder.put("f_filiale", filiale);
                saveOrder.put("f_userfiles_id", userFilesId);
                saveOrder.put("f_total_fee", orderAmt);
                // 保存分公司id
                JSONObject clientConfig = Config.getClientConfig(filiale);
                saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                logicServer.run("savewxreturnxml", saveOrder);

            } else {
                // 失败, 返回码非0
                result.put("result_msg", response.getPayStatus() + ":" + response.getReturnMsg());
            }
        } catch (IcbcApiException e) {
            log.debug("巩义建行付款码下单异常错误", e);
            result.put("result_msg", "支付确认失败");
            result.put("err_msg", e.getMessage());
        } catch (Exception e) {
//            向中间表存储过程中出现错误
            log.debug("错误信息为: {}", e.getMessage());
        }
        log.debug("高密工行付款码下单返回: {}", result.toString());
        return result.toString();
    }

    /**
     * 高密被扫支付订单状态查询
     * @param value
     * @return
     */
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        JSONObject jsonObject = new JSONObject(value);
        JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
//         私钥
        String MY_PRIVATE_KEY = wxConfig.getString("privateKey");
//         公钥
        String APIGW_PUBLIC_KEY = wxConfig.getString("pubKey");
//         APP_ID
        String APP_ID =  wxConfig.getString("app_id");

        DefaultIcbcClient client = new DefaultIcbcClient(APP_ID, IcbcConstants.SIGN_TYPE_RSA2, MY_PRIVATE_KEY, APIGW_PUBLIC_KEY);
        MybankPayQrcodeScannedPaystatusRequestV2 request = new MybankPayQrcodeScannedPaystatusRequestV2();
        //4、根据测试环境和生产环境替换相应ip和端口
        request.setServiceUrl(wxConfig.getString("queryUrl"));
        //5、请对照接口文档用bizContent.setxxx()方法对业务上送数据进行赋值
        MybankPayQrcodeScannedPaystatusRequestV2.MybankPayQrcodeScannedPaystatusRequestV2Biz bizContent = new MybankPayQrcodeScannedPaystatusRequestV2.MybankPayQrcodeScannedPaystatusRequestV2Biz();

//        商户编号
        String merId = wxConfig.getString("mer_id");

//        订单号
        String outTradeNo = jsonObject.getString("out_trade_no");

//        交易日期
//        String tradeDate = new SimpleDateFormat("YYYYMMDD").format(new Date());

//        工行系统单号
        String orderId = "";

//        outTradeNo 与 orderId 只用传输一个即可, 这里串outTradeNo
        bizContent.setMerId(merId); //商户编号
        bizContent.setOutTradeNo(outTradeNo); //外部订单号
//        bizContent.setTradeDate(tradeDate); //交易日期  格式:YYYYMMDD
//        bizContent.setOrderId("");  //工行系统单号
        request.setBizContent(bizContent);
        MybankPayQrcodeScannedPaystatusResponseV2 response;
        try {
            response = client.execute(request, "msgId3");//msgId消息通讯唯一编号，要求每次调用独立生成，APP级唯一
            String responseJson = new ObjectMapper().writeValueAsString(response);
            log.info("查询接口相应信息为: {}",responseJson);
            if (response.getReturnCode() == 0) {
                switch (response.getPayStatus()){
                    case "0":
//                        支付中请稍后查询
                        log.info("支付结果未知");
                        result.put("result_msg", "支付结果未知");
                        break;
                    case "1":
//                        支付成功
                        log.info("支付确认成功");
                        result.put("result_msg", "支付确认成功");
                        result.put("f_out_trade_no",outTradeNo);
                        String f_time_end = DateUtil.format(DateUtil.date(), DatePattern.PURE_DATETIME_PATTERN);
                        this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state = '已支付',f_time_end = '" + f_time_end + "' where f_out_trade_no = '" + outTradeNo + "'");
                        break;
                    case "2":
//                        支付失败
                        log.info("支付确认失败");
                    case "3":
//                        已撤销
                        log.info("支付已撤销");
                        break;
                    default:
                        result.put("result_msg", "支付确认失败");
                }
            } else {
                result.put("result_msg", response.getPayStatus() + ":" + response.getReturnMsg());
            }
        } catch (IcbcApiException | JsonProcessingException e) {
            log.debug("高密工行付款码查询异常错误", e);
            result.put("result_msg", "支付确认失败");
            result.put("err_msg", e.getMessage());
        }
        log.debug("高密工行付款码查询返回{}", result);
        return result.toString();
    }
}
