package com.aote.pay.icbc.chengran;


import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.util.GetUserIp;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcApiException;
import com.icbc.api.IcbcConstants;
import com.icbc.api.UiIcbcClient;
import com.icbc.api.request.AggregatePaymentRequestV2;
import com.icbc.api.request.CardbusinessAggregatepayB2cOnlineOrderqryRequestV1;
import com.icbc.api.response.CardbusinessAggregatepayB2cOnlineOrderqryResponseV1;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Date;


@Slf4j
@Component
public class JsApiWxIcbcAggregatePay implements PaySuper {

    @Autowired
    private LogicServer logicServer;
    

    /**
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        String userfilesid = json.getString("userfilesid");
        HttpServletRequest req = (HttpServletRequest) json.get("request");

        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        String result = "";
        try {
            // 在API开放平台注册时生成
            String APP_ID = wxConfig.getString("apply_app_id");

            // biz_content请求参数的集合

            // 接口号，目前仅支持上送1.0.0.1
            String interface_version = "1.0.0.1";
            // 商户编号
            String merId = wxConfig.getString("apply_mer_id");
            // 渠道商号；商户通过渠道商接入时必送。目前暂不支持上送
            String channel_id = "";
            // 第三方应用ID；商户在微信公众号内接入时必送，上送微信分配的公众账号ID；商户通过支付宝生活号接入时必送，上送支付宝分配的应用ID。目前暂不支持上送
            String tp_app_id = wxConfig.getString("appId");
            // 商户订单号；需保证商户系统唯一
            String out_trade_no = PayUtil.getOutTradeNo();
            // 交易类型。用于区分交易场景为线上支付还是线下支付，对应数据字典：OfflinePay-线下支付，OnlinePay-线上支付。商户需按实际交易场景上送，如上送错误可能影响后续交易的进行；比如线上支付场景，上送OfflinePay-线下支付，使用微信支付时，微信会对实际交易场景进行检查，一旦发现不符，微信侧会拒绝对应交易请求
            String tran_type = wxConfig.getString("apply_tran_type");
            // 交易提交时间， 格式为：YYYYMMDDHHmmss
            String order_date = new SimpleDateFormat("YYYYMMDDHHmmss").format(new Date());
            // 交易过期时间，格式为：YYYYMMDDHHmmss。建议上送为order_date之后的五分钟或者固定为每晚11点这种形式
            String end_time = "";
            // 商品描述
            String goods_body = wxConfig.getString("apply_goods_body");
            // 商品详情
            String goods_detail = userfilesid;
            // 总金额（单位：分）
            String order_amount = String.valueOf(PayUtil.yuan2FenInt(money));
            // 终端ip
            String spbill_create_ip = GetUserIp.getIpAdrress(req);
            // 分期期数。目前仅支持1-不分期
            String install_times = "1";
            // 支付成功回显页面。支付成功后，客户端引导跳转至该页面显示
            String return_url = wxConfig.getString("apply_return_url");
            // 支付方式限定；上送”no_credit“表示不支持信用卡支付；不上送或上送空表示无限制；上送“no_balance”表示仅支持银行卡支付（需要微信审批通过后可以接入）
            String pay_limit = "";
            // 支付结果通知地址；上送互联网可访问的完整URL地址（必须包含协议）；应支持受理同一笔订单的多次通知场景
            String notify_url = wxConfig.getString("wechatNotify");
            // 通知类型，“HS”：主动发送交易给商户；“AG”：在交易完成后不通知商户
            String notify_type = "HS";
            // 取值“0”：无论支付成功或者失败，交易结果都传，"1"，只发送交易成功结果，默认0
            String result_type = "0";
            // 附加数据，在查询API和支付通 知中原样返回
            int len = 127;
            if(attach.length() > len) {
                attach = attach.substring(0, len);
            }

            AggregatePaymentRequestV2.AggregatePaymentRequestV2Biz bizContent = new AggregatePaymentRequestV2.AggregatePaymentRequestV2Biz();
            bizContent.setMerId(merId);
            bizContent.setChannelId(channel_id);
            bizContent.setOutTradeNo(out_trade_no);
            bizContent.setTranType(tran_type);
            bizContent.setOrderDate(order_date);
            bizContent.setEndTime(end_time);
            bizContent.setGoodsBody(goods_body);
            bizContent.setGoodsDetail(goods_detail);
            bizContent.setAttach(attach);
            bizContent.setOrderAmount(order_amount);
            bizContent.setSpbillCreateIp(spbill_create_ip);
            bizContent.setNotifyUrl(notify_url);
            bizContent.setResultType(result_type);
            bizContent.setReturnUrl(return_url);
            bizContent.setNotifyType(notify_type);
            bizContent.setInterfaceVersion(interface_version);
            bizContent.setInstallTimes(install_times);
            bizContent.setPayLimit(pay_limit);


            // 私钥
            String MY_PRIVATE_KEY = wxConfig.getString("apply_privateKey");
            // 私钥
            String encryptKey = wxConfig.getString("apply_encryptKey");
            // 请求地址
            String payUrl = wxConfig.getString("apply_payUrl");
            // 下单参数
            String paramMap = new JSONObject(bizContent).toString();
            log.debug("城然工行下单地址: {},下单参数: {}", payUrl, paramMap);

            UiIcbcClient client = new UiIcbcClient(APP_ID, IcbcConstants.SIGN_TYPE_RSA2, MY_PRIVATE_KEY,"UTF-8","AES",encryptKey);
            AggregatePaymentRequestV2 request = new AggregatePaymentRequestV2();
            request.setServiceUrl(payUrl);
            request.setBizContent(bizContent);
            String response;
            try {
                response = client.buildPostForm(request);
                JSONObject responseJson = new JSONObject(response);
                log.debug("工行下单返回数据: {}", responseJson.toString());
//                if (response.getReturnCode() == 0) {
//                    // 保存下单信息到中间表
//                    result = responseJson.toString();
//                    JSONObject saveOrder = new JSONObject();
//                    saveOrder.put("f_out_trade_no", outTradeNo);
//                    saveOrder.put("f_attach", attach);
//                    saveOrder.put("f_openid", openid);
//                    saveOrder.put("f_order_state", "已下单");
//                    saveOrder.put("f_order_type", "燃气收费");
//                    saveOrder.put("flag", "JsApiChengRan");
//                    saveOrder.put("f_trade_type", "JSAPI");
//                    saveOrder.put("f_filiale", filiale);
//                    saveOrder.put("f_total_fee", totalFee);
//                    saveOrder.put("f_userfiles_id", userfilesid);
//                    // 保存分公司id
//                    JSONObject clientConfig = Config.getClientConfig(filiale);
//                    saveOrder.put("f_orgid", clientConfig.get("orgStr"));
//                    logicServer.run("savewxreturnxml", saveOrder);
//                }
            } catch (IcbcApiException e) {
                e.printStackTrace();
                log.debug("诚然工行下单返回结果异常错误", e);
            }
        } catch (Exception e) {
            log.debug("诚然工行下单异常错误", e);
        }
        return result;
    }


    /**
     * 查询订单是否支付成功
     *
     * @param value
     * @return 订单支付结果
     */
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            // 在API开放平台注册时生成
            String app_id = wxConfig.getString("app_id");

            // biz_content参
            // 商户编号
            String merId = wxConfig.getString("mer_id");
            // 商户订单号
            String outTradeNo = jsonObject.getString("out_trade_no");
            // 操作标志，0-查询；1-关单
            String deal_flag = "0";
            CardbusinessAggregatepayB2cOnlineOrderqryRequestV1.CardbusinessAggregatepayB2cOnlineOrderqryRequestV1Biz bizContent = new CardbusinessAggregatepayB2cOnlineOrderqryRequestV1.CardbusinessAggregatepayB2cOnlineOrderqryRequestV1Biz();
            bizContent.setMer_id(merId);
            bizContent.setOut_trade_no(outTradeNo);
            bizContent.setDeal_flag(deal_flag);
            bizContent.setIcbc_appid(app_id);
            // 私钥
            String MY_PRIVATE_KEY = wxConfig.getString("privateKey");
            // 公钥
            String APIGW_PUBLIC_KEY = wxConfig.getString("pubKey");
            // 查询地址
            String queryUrl = wxConfig.getString("queryUrl");
            // 查询参数
            String paramMap = new JSONObject(bizContent).toString();
            log.debug("城然工行查询地址: {},查询参数: {}", queryUrl, paramMap);
            DefaultIcbcClient client = new DefaultIcbcClient(app_id, IcbcConstants.SIGN_TYPE_RSA2, MY_PRIVATE_KEY, APIGW_PUBLIC_KEY);
            CardbusinessAggregatepayB2cOnlineOrderqryRequestV1 request = new CardbusinessAggregatepayB2cOnlineOrderqryRequestV1();
            request.setBizContent(bizContent);
            request.setServiceUrl(queryUrl);
            CardbusinessAggregatepayB2cOnlineOrderqryResponseV1 response;
            try {
                // msgId消息通讯唯一编号，要求每次调用独立生成，APP级唯一
                String msgid = System.currentTimeMillis() + "";
                response = client.execute(request, msgid);
                JSONObject jsonResponse = new JSONObject(response);
                log.debug("返回信息: {}", jsonResponse.toString());
                if (response.getReturnCode() == 0) {
                    if (!"success".equals(response.getReturnMsg())) {
                        result.put("result_code", "FAIL");
                        result.put("return_msg", response.getReturnMsg());
                        log.debug("查询失败", response.getReturnMsg());
                    }
                    //获取支付状态 0-支付,2-交易状态异常
                    String paystatus = response.getPay_status();
                    if ("0".equals(paystatus)) {
                        result.put("result_code", "SUCCESS");
                        result.put("trade_state", "SUCCESS");
                        // 订单号
                        result.put("transaction_id", response.getOrder_id());
                        // 交易日期
                        result.put("time_end", response.getPay_time());
                        // 交易金额
                        result.put("total_fee", response.getTotal_amt());
                    } else {
                        result.put("result_code", "FAIL");
                        result.put("return_msg", paystatus);
                        log.debug("订单状态不等于已支付：" + paystatus);
                    }
                } else {
                    result.put("result_code", "FAIL");
                    result.put("return_msg", response.getReturnMsg());
                    log.debug("请求结果失败:" + response.getReturnMsg());
                }
            } catch (IcbcApiException e) {
                log.error("操作失败：原因" + e.getMessage());
                result.put("result_code", "FAIL");
                result.put("return_msg", "系统异常");
            }
        } catch (Exception e) {
            result.put("trade_state", "FAIL");
            log.debug("工行查询订单异常：" + e);
        }
        return result.toString();
    }
}
