package com.aote.pay.huatong;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

/**
 *
 * @Description
 * @Author jiemin2
 * @Date 10:54 2021/4/15
 * @Param
 * @return
 **/
public class HttpUtil {

    private static Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    private static final int TIMEOUT_IN_MILLIONS_TEN = 10000;

    public static String doPost(String url, Map<String,Object> parameterData, Map<String,String> headers) throws Exception {
        //组装参数
        StringBuilder sb =new StringBuilder();
        for(Map.Entry<String, Object> entry:parameterData.entrySet()){
            sb.append("&"+entry.getKey()+"="+entry.getValue().toString());
        }
        String param="";
        if(sb.length()!=0) {
            param =  sb.toString().substring(1);
        }
        //请求开始
        URL localURL = new URL(url);
        URLConnection connection = localURL.openConnection();
        HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Accept-Charset", "utf-8");
        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpURLConnection.setRequestProperty("Content-Length", String.valueOf(param.length()));
        httpURLConnection.setConnectTimeout(TIMEOUT_IN_MILLIONS_TEN);
        httpURLConnection.setReadTimeout(TIMEOUT_IN_MILLIONS_TEN);
        for(Map.Entry<String, String> entry:headers.entrySet()){
            //设置额外的请求头信息
            httpURLConnection.setRequestProperty(entry.getKey(),entry.getValue());
        }
        OutputStream outputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader reader = null;
        StringBuffer resultBuffer = new StringBuffer();
        String tempLine = null;

        try {
            outputStream = httpURLConnection.getOutputStream();
            outputStreamWriter = new OutputStreamWriter(outputStream);

            outputStreamWriter.write(param);
            outputStreamWriter.flush();

            if (httpURLConnection.getResponseCode() >= 300) {
                logger.error("访问"+url+"失败，http返回码"+httpURLConnection.getResponseCode()+"参数"+parameterData);
                throw new Exception("HTTP Request is not success, Response code is " + httpURLConnection.getResponseCode());
            }

            inputStream = httpURLConnection.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream,"UTF-8");
            reader = new BufferedReader(inputStreamReader);

            while ((tempLine = reader.readLine()) != null) {
                resultBuffer.append(tempLine);
            }

        } finally {
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (reader != null) {
                reader.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }

        return resultBuffer.toString();
    }
}
