package com.aote.pay.cup_fanxian;

import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.util.*;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;

/**
 * 范县银联对接下单接口
 */
@Slf4j
@Component
public class JsApiFanXian implements PaySuper {

    @Autowired
    private LogicServer logicServer;
    


    /**
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        HttpServletRequest request = (HttpServletRequest) json.get("request");

        if (filiale == null || filiale.length() == 0) {
            throw new RuntimeException("公司信息不能为空！");
        }
        JSONObject result = new JSONObject();
        JSONObject wxConfig = Config.getConfig(filiale);
        //接口类型
        String service = wxConfig.getString("service");
        //商户号
        String mchId = wxConfig.getString("mchId");
        //原生js
        String isRaw = "1";
        //签名方式
        String signType = "MD5";
        //商户订单号
        String outTradeNo = WxSign.getNonceStr();
        //商品描述
        String body = wxConfig.getString("body");
        // String subOpenid = wxConfig.getString("subOpenid");
        //公众账号或小程序ID
        String subAppid = wxConfig.getString("subAppid");

        //String mchCreateIp = wxConfig.getString("mchCreateIp");
        //终端ip
        String mchCreateIp = request.getRemoteAddr();
        //通知地址
        String notifyUrl = wxConfig.getString("notifyUrl");
        //随机字符串
        String nonceStr = String.valueOf(new Date().getTime());

        String key = wxConfig.getString("key");
        //请求地址
        String reqUrl = wxConfig.getString("reqUrl");

        SortedMap<String, String> map = new TreeMap<>();
        map.put("service", service);
        map.put("mch_id", mchId);
        map.put("sign_type", signType);
        map.put("is_raw", isRaw);
        map.put("out_trade_no", outTradeNo);
        map.put("body", body);
        map.put("sub_openid", openid);
        map.put("sub_appid", subAppid);
        map.put("total_fee", Integer.toString(PayUtil.yuan2FenInt(money)));
        map.put("mch_create_ip", mchCreateIp);
        map.put("notify_url", notifyUrl);
        map.put("nonce_str", nonceStr);

        Map<String, String> params = UnionSignUtils.paraFilter(map);
        StringBuilder buf = new StringBuilder((params.size() + 1) * 10);
        UnionSignUtils.buildPayParams(buf, params, false);
        String preStr = buf.toString();
        String sign = UnionMD5.sign(preStr, "&key=" + key, "utf-8");
        map.put("sign", sign);

        log.debug("reqParams:" + UnionXmlUtils.parseXML(map));
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        String res = null;
        Map<String, String> resultMap = null;


        try {
            HttpPost httpPost = new HttpPost(reqUrl);
            StringEntity entityParams = new StringEntity(UnionXmlUtils.parseXML(map), "utf-8");
            httpPost.setEntity(entityParams);
            httpPost.setHeader("Content-Type", "text/xml;utf-8");
            client = HttpClients.createDefault();
            response = client.execute(httpPost);
            if (response != null && response.getEntity() != null) {
                resultMap = UnionXmlUtils.toMap(EntityUtils.toByteArray(response.getEntity()), "utf-8");
                res = UnionXmlUtils.toXml(resultMap);
                log.debug("请求结果：" + res);
                String sign1 = resultMap.get("sign");
                if (!UnionSignUtils.checkParam(resultMap, key)) {
                    res = "验证签名不通过";
                    result.put("error", "验证签名不通过");
                } else {
                    if ("0".equals(resultMap.get("status")) && "0".equals(resultMap.get("result_code"))) {

                        JSONObject jsonObject = new JSONObject(resultMap);
                        String appid = jsonObject.get("appid").toString();
                        String signType1 = jsonObject.get("sign_type").toString();
                        String nonce_str1 = jsonObject.get("nonce_str").toString();
                        JSONObject pay_info = new JSONObject(jsonObject.getString("pay_info"));
                        pay_info.get("appId");
                        pay_info.get("timeStamp");
                        pay_info.get("nonceStr");
                        pay_info.get("package");
                        pay_info.get("signType");
                        pay_info.get("paySign");
                        log.debug("查看payinfo参数：" + pay_info);
                        pay_info.put("outTradeNo", outTradeNo);
                        pay_info.put("appId1", appid);
                        pay_info.put("signType1", signType1);
                        pay_info.put("sign1", sign1);
                        pay_info.put("nonce_str1", nonce_str1);
                        result.put("date", pay_info);
                        res = "ok";
                        // 保存下单信息到中间表
                        JSONObject saveOrder = new JSONObject();
                        saveOrder.put("f_out_trade_no", outTradeNo);
                        saveOrder.put("f_attach", attach);
                        saveOrder.put("f_openid", openid);
                        saveOrder.put("flag", "JsApiFanXian");
                        saveOrder.put("f_order_state", "已下单");
                        saveOrder.put("f_order_type", "燃气收费");
                        saveOrder.put("f_filiale", filiale);
                        saveOrder.put("f_total_fee", PayUtil.yuan2FenInt(money));
                        // 保存分公司id
                        JSONObject clientConfig = Config.getClientConfig(filiale);
                        saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                        logicServer.run("savewxreturnxml", saveOrder);
                    }
                }
            } else {
                result.put("error", "操作失败");
            }
        } catch (Exception e) {
            log.error("操作失败，原因：", e);
            res = "系统异常";
            result.put("error", "系统异常");
        } finally {
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (client != null) {
                try {
                    client.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result.toString();
    }

    @Override
    public String orderStatus(String value) {
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            String outTradeNo = jsonObject.getString("out_trade_no");
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            String mchId = wxConfig.getString("mchId");
            String key = wxConfig.getString("key");
            String reqUrl = wxConfig.getString("reqUrl");

            SortedMap<String, String> map = new TreeMap<>();
            map.put("service", "unified.trade.query");
            map.put("mch_id", mchId);
            map.put("out_trade_no", outTradeNo);
            map.put("nonce_str", String.valueOf(new Date().getTime()));

            Map<String, String> params = UnionSignUtils.paraFilter(map);
            StringBuilder buf = new StringBuilder((params.size() + 1) * 10);
            UnionSignUtils.buildPayParams(buf, params, false);
            String preStr = buf.toString();
            String sign = UnionMD5.sign(preStr, "&key=" + key, "utf-8");
            map.put("sign", sign);
            log.debug("reqUrl:" + reqUrl);
            CloseableHttpResponse response = null;
            CloseableHttpClient client = null;
            String res = null;
            Map<String, String> result = new HashMap<String, String>();
            try {
                HttpPost httpPost = new HttpPost(reqUrl);
                StringEntity entityParams = new StringEntity(UnionXmlUtils.parseXML(map), "utf-8");
                httpPost.setEntity(entityParams);
                httpPost.setHeader("Content-Type", "text/xml;utf-8");
                client = HttpClients.createDefault();
                response = client.execute(httpPost);
                if (response != null && response.getEntity() != null) {
                    Map<String, String> resultMap = UnionXmlUtils.toMap(EntityUtils.toByteArray(response.getEntity()), "utf-8");
                    JSONObject resTemp = new JSONObject(resultMap);
                    res = UnionXmlUtils.toXml(resultMap);
                    log.debug("请求结果：" + res);
                    if (!UnionSignUtils.checkParam(resultMap, key)) {
                        res = "验证签名不通过";
                    } else {
                        if ("0".equals(resultMap.get("status"))) {
                            if ("0".equals(resultMap.get("result_code"))) {
                                log.debug("业务成功，在这里做相应的逻辑处理");

                                String trade_state = resultMap.get("trade_state");
                                log.debug("订单状态trade_state : " + trade_state);
                                result.put("trade_state", trade_state);
                                log.debug("JSON数据  001  =====> : " + resTemp);
                                if ("SUCCESS".equals(trade_state)) {
                                    String transaction_id = resTemp.getString("transaction_id");
                                    String time_end = resTemp.getString("time_end");
                                    String total_fee = resTemp.getString("total_fee");
                                    result.put("total_fee", total_fee);
                                    result.put("transaction_id", transaction_id);
                                    result.put("time_end", time_end);
                                    log.debug("交易金额total_fee : " + total_fee);
                                    log.debug("订单号f_transaction_id : " + transaction_id);
                                    log.debug("交易日期time_end : " + time_end);
                                }


                            } else {
                                log.debug("业务失败，尝试重新请求，并查看错误代码描叙");
                            }
                        } else {
                            log.debug("这里是请求参数有问题...");
                        }
                    }
                } else {
                    res = "操作失败!";
                }
            } catch (Exception e) {
                log.error("操作失败，原因：", e);
                res = "操作失败";
            }
            if (res.startsWith("<")) {
                result.put("msg", "操作成功，请在日志文件中查看");
            } else {
                result.put("status", "500");
                result.put("msg", res);
            }
            return new JSONObject(result).toString();
        } catch (Exception e) {
            log.debug("查询订单出错:" + e);

            return "{}";
        }
    }

}
