package com.aote.pay.cmsb.kelai;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.sql.SqlServer;
import com.aote.util.CMSBUtil;
import com.aote.util.FileUtils;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;

@Slf4j
@Component
public class JsApiKeLai  implements PaySuper, RefundSuper {
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private SqlServer sqlServer;
    
    /**
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        log.debug("进入");
        JSONObject result = new JSONObject();
        try {
            String money = String.valueOf(json.get("money"));
            String openid = json.getString("openid");
            String attach = String.valueOf(json.get("attach"));
            String filiale = json.getString("filiale");
            String otherType = json.optString("othertype","燃气收费");
            if (filiale == null || filiale.length() == 0) {
                throw new RuntimeException("公司信息不能为空！");
            }

            JSONObject wxConfig = Config.getConfig(filiale);
            String payUrl =wxConfig.getString("payUrl");
            String platformId = wxConfig.getString("platformId");
            String merchantNo = wxConfig.getString("merchantNo");
            String selectTradeType = "H5_WXJSAPI";
            String amount = String.valueOf(PayUtil.yuan2FenInt(money));
            String orderInfo = otherType;
            String merchantSeq = PayUtil.getOrderNoByNumber50();
            String inateMeroChannelSerialNo = PayUtil.getOrderNoByNumber50();
            Date date = new Date();
            String transDate =  new SimpleDateFormat("yyyyMMdd").format(date);
            String transTime = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(date);
            String notifyUrl = wxConfig.getString("wechatNotify");
            String subAppId = wxConfig.getString("appId");
            String subOpenId = openid;
            String spbillCreateIp = "220.194.141.253";


            JSONObject jsonObject = new JSONObject();
            jsonObject.put("platformId",platformId);
            jsonObject.put("merchantNo",merchantNo);

            jsonObject.put("selectTradeType",selectTradeType);
            jsonObject.put("amount",amount);
            jsonObject.put("orderInfo",orderInfo);
            jsonObject.put("merchantSeq",merchantSeq);
            jsonObject.put("transDate",transDate);
            jsonObject.put("transTime",transTime);
            jsonObject.put("notifyUrl",notifyUrl);
            jsonObject.put("spbillCreateIp",spbillCreateIp);
            jsonObject.put("subAppId",subAppId);
            jsonObject.put("subOpenId",subOpenId);

            String inForm  = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
                    "<InFormBody>" +
                    "<draweeAccNo>"+subOpenId+"</draweeAccNo>" +
                    "<isLockCard>1</isLockCard>" +
                    "<draweeAccName></draweeAccName>" +
                    "<draweeCertType></draweeCertType>" +
                    "<draweePartyId></draweePartyId>" +
                    "<draweeAccType></draweeAccType>" +
                    "<draweeCertNo></draweeCertNo>" +
                    "<draweeProtocolId></draweeProtocolId>" +
                    "<orderType>10</orderType>" +
                    "<specific3></specific3>" +
                    "<postscript></postscript>" +
                    "<summary></summary>" +
                    "<recNum>1</recNum>" +
                    "<prodList>" +
                    "<inateMeroChannelSerialNo>"+inateMeroChannelSerialNo+"</inateMeroChannelSerialNo>" +
                    "<prodAmt>"+amount+"</prodAmt>" +
                    "<prodId>01</prodId>" +
                    "<prodName>天然气</prodName>" +
                    "<prodCount>1</prodCount>" +
                    "<agtContractId></agtContractId>" +
                    "</prodList>" +
                    "</InFormBody>";
            log.debug(Base64.encode(inForm));
            jsonObject.put("inForm",Base64.encode(inForm));
            CMSBUtil.merchantPrivateKey = wxConfig.getString("merchantPrivateKey");
            CMSBUtil.merchantPwd = wxConfig.getString("merchantPwd");
            CMSBUtil.bankPublicKey = wxConfig.getString("bankPublicKey");
            log.debug("科莱民银行下单地址: {},下单参数: {}", payUrl, jsonObject);

           JSONObject response = new JSONObject();
            String res = CMSBUtil.execute(jsonObject.toString(),payUrl);
            log.debug("科莱民银行下单返回:"+res);
            String res1 = new JSONObject(res).getString("body");
            JSONObject body = new JSONObject(res1);
            if ("R".equals(body.getString("tradeStatus"))) {
                String line =  body.getString("payInfo");
                String[] lineValues = line.split("\\|");
                log.debug("每行数据的参数:" + Arrays.toString(lineValues));
                for (int i = 0; i<lineValues.length; i++) {
                    int a = lineValues[i].indexOf("=");
                    response.put(lineValues[i].substring(0,a),lineValues[i].substring(a+1));
                }
                log.debug("返回的参数:" + response);
                // 保存下单信息到中间表
                JSONObject param = new JSONObject(attach);
                String userFilesId = param.optString("f_userfiles_id", "");
                JSONObject saveOrder = new JSONObject();
                saveOrder.put("f_out_trade_no", merchantSeq);
                saveOrder.put("f_mero_channel_serialNo",inateMeroChannelSerialNo);
                saveOrder.put("f_attach", attach);
                saveOrder.put("f_openid", openid);
                saveOrder.put("f_order_state", "已下单");
                saveOrder.put("f_order_type",  otherType);
                saveOrder.put("flag", "JsApiKeLai");
                saveOrder.put("f_trade_type", "JSAPI");
                saveOrder.put("f_filiale", filiale);
                saveOrder.put("f_userfiles_id", userFilesId);
                saveOrder.put("f_total_fee", PayUtil.yuan2FenInt(money));
                // 保存分公司id
                JSONObject clientConfig = Config.getClientConfig(filiale);
                saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                logicServer.run("savewxreturnxml", saveOrder);
                return  response.toString();
            }
        } catch (Exception e) {
            log.debug(e.toString());
        }
        return result.toString();
    }

    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));

            // 一级签约编码
            String merchantNo = wxConfig.getString("merchantNo");
            // 一级商户号
            String platformId = wxConfig.getString("platformId");
            // 商户订单号
            String merchantSeq =  jsonObject.getString("out_trade_no");
            // 商户流水号
            String mchSeqNo =  PayUtil.getOrderNoByNumber50();
            // 查询流水号
            String querySeq =  jsonObject.getString("out_trade_no");

            String selectUrl = wxConfig.getString("selectUrl");

            String payDate = jsonObject.getString("f_create_date");

            JSONObject parem = new JSONObject();

            parem.put("merchantNo",merchantNo);
            parem.put("platformId",platformId);
            parem.put("merchantSeq",merchantSeq);
            parem.put("mchSeqNo",mchSeqNo);
            parem.put("querySeq",querySeq);
            CMSBUtil.merchantPrivateKey = wxConfig.getString("merchantPrivateKey");
            CMSBUtil.merchantPwd = wxConfig.getString("merchantPwd");
            CMSBUtil.bankPublicKey = wxConfig.getString("bankPublicKey");
            log.debug("科莱民银行下单地址: {},下单参数: {}", selectUrl, jsonObject);
            String res = CMSBUtil.execute(parem.toString(),selectUrl);
            log.debug("科莱民银行查询返回:"+res);
            String res1 = new JSONObject(res).getString("body");
            JSONObject body = new JSONObject(res1);
            if ("S".equals(  body.getString("tradeStatus"))) {
                result.put("result_code", "SUCCESS");
                result.put("trade_state", "SUCCESS");
                // 订单号
                result.put("transaction_id", body.getString("centerSeqId"));

                result.put("total_fee", body.getString("amount"));

                Date date = DateUtil.parseDateTime(payDate);

                result.put("time_end", new DateTime(date).toString("yyyyMMddHHmmss"));
            } else {
                result.put("result_code", "FAIL");
                result.put("result_msg", "");
            }
        } catch (Exception e) {
            log.debug("巩义查询订单异常", e);
            result.put("result_code", "FAIL");
            result.put("trade_state", "FAIL");
            result.put("result_msg", e.getMessage());
        }
        log.debug("查询订单返回: {}", result.toString());
        return result.toString();
    }

    @Override
    public String refund(JSONObject json) {
        String filiale = json.getString("f_filiale");
        Integer id = json.getInt("id");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        log.debug("进入");
        JSONObject result = new JSONObject();

        try {
            String refundUrl =wxConfig.getString("refundUrl");
            String platformId = wxConfig.getString("platformId");
            String merchantNo = wxConfig.getString("merchantNo");
            String orderAmount = json.getString("f_total_fee");
            String merchantSeq = json.getString("f_out_trade_no");
            String mchSeqNo = PayUtil.getOrderNoByNumber50();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("platformId",platformId);
            jsonObject.put("merchantNo",merchantNo);
            jsonObject.put("merchantSeq",merchantSeq);
            jsonObject.put("mchSeqNo",mchSeqNo);
            jsonObject.put("orderAmount",orderAmount);
            String inateMeroChannelSerialNo = PayUtil.getOrderNoByNumber50();
            String inForm = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
                    "<prodListBody>" +
                    "<recNum>1</recNum>" +
                    "<postscript></postscript>" +
                    "<prodList>" +
                    "<orgInateMeroChannelSerialNo>" + inateMeroChannelSerialNo + "</orgInateMeroChannelSerialNo>" +
                    "<prodAmt>"+orderAmount+"</prodAmt>" +
                    "<prodId>01</prodId>" +
                    "<prodName>天然气</prodName>" +
                    "<prodCount>1</prodCount>" +
                    "<agtContractId></agtContractId>" +
                    "</prodList>" +
                    "</prodListBody>";
            log.debug(Base64.encode(inForm));
            jsonObject.put("inForm",Base64.encode(inForm));
            CMSBUtil.merchantPrivateKey = wxConfig.getString("merchantPrivateKey");
            CMSBUtil.merchantPwd = wxConfig.getString("merchantPwd");
            CMSBUtil.bankPublicKey = wxConfig.getString("bankPublicKey");
            log.debug("科莱民银行退款地址: {},退款参数: {}", refundUrl, jsonObject);

            String res = CMSBUtil.execute(jsonObject.toString(),refundUrl);
            log.debug("科莱民银行退款返回:"+res);
            String res1 = new JSONObject(res).getString("body");
            JSONObject body = new JSONObject(res1);
            JSONObject saveOrder = new JSONObject();
            saveOrder.put("id", id);
            saveOrder.put("f_refund_no",body.getString("bankTradeNo"));
            if ("S".equals(body.getString("tradeStatus"))) {
                result.put("result_msg", "退款成功");
                result.put("trade_state", "Y");
                saveOrder.put("f_order_state", "退款");
            }  else if ("E".equals(body.getString("tradeStatus"))) {
                result.put("result_msg", "退款失败");
                result.put("trade_state", "N");
            }  else {
                result.put("result_msg", "退款中");
                result.put("trade_state", "Y");
                saveOrder.put("f_order_state", "退款中");
            }
            logicServer.run("savewxreturnxml", saveOrder);
        } catch (Exception e) {
            log.debug(e.toString());
        }
        return result.toString();
    }

    @Override
    public String refundOrderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));

            // 一级签约编码
            String merchantNo = wxConfig.getString("merchantNo");
            // 一级商户号
            String platformId = wxConfig.getString("platformId");
            // 商户订单号
            String merchantSeq =  jsonObject.getString("out_trade_no");
            // 商户流水号
            String mchSeqNo =  PayUtil.getOrderNoByNumber50();
            // 查询流水号
            String querySeq =  jsonObject.getString("f_refund_no");

            String selectUrl = wxConfig.getString("selectUrl");

            Integer id = jsonObject.getInt("id");

            JSONObject parem = new JSONObject();

            parem.put("merchantNo",merchantNo);
            parem.put("platformId",platformId);
            parem.put("merchantSeq",merchantSeq);
            parem.put("mchSeqNo",mchSeqNo);
            parem.put("querySeq",querySeq);
            CMSBUtil.merchantPrivateKey = wxConfig.getString("merchantPrivateKey");
            CMSBUtil.merchantPwd = wxConfig.getString("merchantPwd");
            CMSBUtil.bankPublicKey = wxConfig.getString("bankPublicKey");
            log.debug("科莱民银行下单地址: {},下单参数: {}", selectUrl, jsonObject);
            String res = CMSBUtil.execute(parem.toString(),selectUrl);
            log.debug("科莱民银行查询返回:"+res);
            String res1 = new JSONObject(res).getString("body");
            JSONObject body = new JSONObject(res1);
            if ("S".equals(  body.getString("tradeStatus"))) {
                this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已退款' where id = '" + id + "'");
                result.put("result_msg", "退款成功");
                log.debug(result.toString());
            } else if ("R".equals(  body.getString("tradeStatus"))) {
                result.put("return_msg", "退款处理中");
            } else {
                this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已支付' where id = '" + id + "'");
                result.put("return_msg", "退款失败");
            }
        } catch (Exception e) {
            result.put("return_msg", "查询失败");
            log.debug("查询订单异常：" + e);
        }
        log.debug("查询订单返回: {}", result);
        return result.toString();
    }

    @Override
    public JSONObject getRecordFile(JSONObject json) {
        String filiale = json.getString("f_filiale");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            // 下载对账文件地址
            String getFileUrl =  wxConfig.getString("getFileUrl");
            // 一级签约编码
            String merchantNo = wxConfig.getString("merchantNo");
            // 一级商户号
            String platformId = wxConfig.getString("platformId");
            // 交易日期
            String slcTransDate =  "20221118";
            //
            String segmentIndex = "2";
            String segmentSize = "1024";
            String reserve = "对账文件";
            String fileType = "DETAIL";
            JSONObject parem = new JSONObject();
            parem.put("merchantNo",merchantNo);
            parem.put("platformId",platformId);
            parem.put("slcTransDate",slcTransDate);
            parem.put("segmentIndex",segmentIndex);
            parem.put("segmentSize",segmentSize);
            parem.put("reserve",reserve);
            parem.put("fileType",fileType);
            CMSBUtil.merchantPrivateKey = wxConfig.getString("merchantPrivateKey");
            CMSBUtil.merchantPwd = wxConfig.getString("merchantPwd");
            CMSBUtil.bankPublicKey = wxConfig.getString("bankPublicKey");
            log.debug("科莱民银行下载对账文件地址: {},参数: {}", getFileUrl, parem);
            String res = CMSBUtil.execute(parem.toString(),getFileUrl);
            log.debug("科莱民银行下单返回:"+res);
            String res1 = new JSONObject(res).getString("body");
            JSONObject body = new JSONObject(res1);
            if ("".equals(body.optString("segmentContent",""))) {
                final String zipFilePath = Config.wechatConfig.getString("mendRecordPath") + platformId + ".zip";
                final String unzipDir = Config.wechatConfig.getString("mendRecordPath") + platformId;
                FileUtils.decodeFileContent(zipFilePath,body.getString("segmentContent"));
                FileUtils.unzip(zipFilePath, unzipDir);
                log.info("下载成功");
                // 添加到数据库
                String fileName = slcTransDate+".txt";
                File createFile = new File(unzipDir);
                File[] files = createFile.listFiles();
                if(files==null||files.length==0) {
                    log.debug("该文件没有任何东西");
                } else {
                    for(File file : files) {
                        log.debug("文件名"+file.getName());
                        // 判断是否是文件,true:是文件,false:不是文件
                        if (file.isFile() && fileName.equals(file.getName())) {
                            try {
                                List<String> lines = org.apache.commons.io.FileUtils.readLines(file, "GBK");
                                Iterator temp = lines.iterator();
                                while(temp.hasNext()) {
                                    String line = String.valueOf(temp.next());
                                    log.info("line的值是===>" + line);
                                    String[] lineValues = line.split("\\|");
                                    log.info("每行数据的参数:" + Arrays.toString(lineValues));
                                    log.info("每行数据的参数长度:" + lineValues.length);
                                    log.info("时间:" + lineValues[1]);
                                    Date sDate = new SimpleDateFormat("yyyyMMddHHmmss").parse(lineValues[1]);
                                    String f_trade_date =new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(sDate);
                                    JSONObject jsonObject = new JSONObject();
                                    //  交易时间
                                    jsonObject.put("f_trade_date", f_trade_date);
                                    // 订单号
                                    jsonObject.put("f_trade_number", lineValues[3]);
                                    // 金额
                                    jsonObject.put("f_total_charge", lineValues[9]);
                                    jsonObject.put("f_gas_fee", lineValues[9]);
                                    jsonObject.put("f_state",lineValues[13]);
                                    //银行名称
                                    jsonObject.put("f_bank_name", "中国民生银行");
                                    //付款方式
                                    jsonObject.put("f_payment", "微信公众号");

                                    log.debug(jsonObject.toString());

                                    logicServer.run("saveBankPayment", jsonObject);
                                    // 更新中间表状态

                                }
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            result.put("stute", "fail");
            result.put("respMsg", e);
            log.debug("长安银行下单异常错误", e);
        }

        return null;
    }


}
