package com.aote.pay.ceb.xinkang;

import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 *  光大银行云缴费对接下单接口
 */
@Slf4j
@Component
public class JsApiXinKang implements PaySuper {

    @Autowired
    private LogicServer logicServer;


    /**
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String money = String.valueOf(json.get("money"));
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        String userId = String.valueOf(json.get("userId"));


        JSONObject result = new JSONObject();
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        try {
            // 交易类型,缴费--01;缴费记录--02
            String transType = "01";
            // 合作商户类型,指定项目版类型为15
            String canalType = "15";
            // 渠道标识
            String canal = wxConfig.getString("canal");
            // 缴费项目编号
            String itemCode = wxConfig.getString("itemCode");
            // 机表号,如果merOrderDate和merOrderNo不为空则该字段必输
            String userNo = userId;
            // 订单号
            String merOrderNo = PayUtil.getOrderNum(itemCode);;
            // 订单日期,yyyyMMdd
            String merOrderDate = new SimpleDateFormat("yyyyMMdd").format(new Date());

            // 渠道标识,云缴费客户端分配给商户平台的渠道标识（云缴费客户端提供）
            String siteCode = wxConfig.getString("siteCode");
            // 版本号,云缴费客户端接口版本号，默认 1.0.0
            String version = "1.0.0";
            // 设备类型
            String deviceType = "5";
            // 交易码,TMRI_ORDER_GETURL获取缴费链接
            String transacCode = "TMRI_ORDER_CREATE";
            // 编码字符集,reqdata，signature 和 base64 编码中使用的字符集，仅支持 utf-8
            String charset = "utf-8";

            Map<String, String> jsonMap = new HashMap<>();
            jsonMap.put("transType", transType);
            jsonMap.put("canalType", canalType);
            jsonMap.put("canal", canal);
            jsonMap.put("itemCode", itemCode);
            jsonMap.put("userNo", userNo);
            jsonMap.put("filed1", money);
            jsonMap.put("filed3", merOrderNo);
            jsonMap.put("merOrderNo", merOrderNo);
            jsonMap.put("merOrderDate", merOrderDate);

            Gson gson = new Gson();
            //加签名用的值
            String reqdata_json = gson.toJson(jsonMap);
            // http请求上送的reqdata值
            String reqdata = new String(Base64.encodeBase64(reqdata_json.getBytes()));

            // 加签(注意：该处用到的reqdata是Base64前的json格式数据),签名内容顺序为：siteCode、version、transacCode 和 reqdata
            String sign_content = siteCode + version + transacCode + reqdata_json;
            log.debug("sign_content:" + sign_content);

            String privateKey = wxConfig.getString("privateKey");
            // 数字签名.采用 Base64 编码和 MD5withRSA 算法实现
            String signature = SignUtil.getSign(privateKey, sign_content, charset);
            log.debug("signature:" + signature);

            Map<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("siteCode",siteCode);
            sendMap.put("version", version);
            sendMap.put("deviceType", deviceType);
            sendMap.put("transacCode", transacCode);
            sendMap.put("charset", charset);
            sendMap.put("reqdata", reqdata);
            sendMap.put("signature", signature);

            // 下单请求地址
            String payUrl = wxConfig.getString("payUrl");
            log.debug("光大云缴费下单地址: {},下单参数: {}", payUrl, new JSONObject(sendMap));

            //发送请求
            String rs = HttpSendUtil.sendToOtherServer2(payUrl, sendMap);
            log.debug("光大云缴费下单返回数据: {}", rs);

            JSONObject json1 = new JSONObject(rs);
            String respData = String.valueOf(json1.get("respData"));
            String respCode = String.valueOf(json1.get("respCode"));
            String respMsg = String.valueOf(json1.get("respMsg"));
            if ("200".equals(respCode)){
                byte[] decodeBase64 = Base64.decodeBase64(respData);
                String respData_json = new String(decodeBase64);
                log.debug("respData_json====>" + respData_json);
                JSONObject resp_json  = new JSONObject(respData_json);
                if("200".equals(resp_json.get("code"))) {
                    // 保存下单信息到中间表
                    JSONObject param = new JSONObject(attach);
                    String userFilesId = param.optString("f_userfiles_id", "");

                    JSONObject saveOrder = new JSONObject();
                    saveOrder.put("f_out_trade_no", merOrderNo);
                    saveOrder.put("f_attach", attach);
                    saveOrder.put("f_openid", openid);
                    saveOrder.put("flag", "JsApiXinKang");
                    saveOrder.put("f_order_state", "已下单");
                    saveOrder.put("f_order_type", "燃气收费");
                    saveOrder.put("f_trade_type", "JSAPI");
                    saveOrder.put("f_filiale", filiale);
                    saveOrder.put("f_trdate", merOrderDate);
                    saveOrder.put("f_total_fee", PayUtil.yuan2FenInt(money));
                    saveOrder.put("f_userid", userId);
                    saveOrder.put("f_userfiles_id", userFilesId);
                    // 保存分公司id
                    JSONObject clientConfig = Config.getClientConfig(filiale);
                    saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                    logicServer.run("savewxreturnxml", saveOrder);

                    result.put("code", 200);
                    result.put("msg", "SUCCESS");
                    result.put("path", resp_json.get("path"));
                    result.put("appId", resp_json.get("appid"));
                    result.put("transType", transType);
                    result.put("canalType", canalType);
                    result.put("itemCode", itemCode);
                    result.put("originalId", wxConfig.getString("originalId"));
                } else{
                    log.debug("下单申请失败：" + resp_json.get("message"));
                    result.put("code", 500);
                    result.put("msg", "光大云缴费下单失败：" + resp_json.get("message"));
                }
            } else {
                log.debug("下单申请失败：" + respMsg);
                result.put("code", 500);
                result.put("msg", "光大云缴费下单失败：" + respMsg);
            }
        } catch (Exception e) {
            log.debug("下单异常，异常内容：" + e.getMessage());
            result.put("code", 500);
            result.put("msg", "下单异常，异常内容：" + e.getMessage());
        }
        return result.toString();
    }

    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            // 商户订单日期,调用支付请求接口时上送的商户订单 日期
            String merOrderDate = jsonObject.getString("f_trdate");
            // 商户订单号,调用支付请求接口时上送的商户订单号
            String merOrderNo = jsonObject.getString("out_trade_no");

            // 渠道标识,云缴费客户端分配给商户平台的渠道标识（云缴费客户端提供）
            String siteCode = wxConfig.getString("siteCode");
            // 版本号,云缴费客户端接口版本号，默认 1.0.0
            String version = "1.0.0";
            // 设备类型
            String deviceType = "5";
            // 交易码,TMRI_ORDER_GETURL获取缴费链接
            String transacCode = "TMRI_ORDER_CREATE";
            // 编码字符集,reqdata，signature 和 base64 编码中使用的字符集，仅支持 utf-8
            String charset = "utf-8";
            // 交易类型,缴费--01;缴费记录--02
            String transType = "02";
            // 合作商户类型,指定项目版类型为15
            String canalType = "15";
            // 渠道标识
            String canal = wxConfig.getString("canal");
            // 缴费项目编号
            String itemCode = wxConfig.getString("itemCode");
            // 机表号,如果merOrderDate和merOrderNo不为空则该字段必输
            String userNo = jsonObject.getString("f_userid");

            Map<String, String> jsonMap = new HashMap<>();
            jsonMap.put("merOrderNo", merOrderNo);
            jsonMap.put("merOrderDate", merOrderDate);

            Gson gson = new Gson();
            //加签名用的值
            String reqdata_json = gson.toJson(jsonMap);

            // http请求上送的reqdata值
            String reqdata = new String(Base64.encodeBase64(reqdata_json.getBytes()));

            // 加签(注意：该处用到的reqdata是Base64前的json格式数据),签名内容顺序为：siteCode、version、transacCode 和 reqdata
            String sign_content = siteCode + version + transacCode + reqdata_json;
            log.debug("查询sign_content:" + sign_content);

            String privateKey = wxConfig.getString("privateKey");
            // 数字签名.采用 Base64 编码和 MD5withRSA 算法实现
            String signature = SignUtil.getSign(privateKey, sign_content, charset);

            Map<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("siteCode",siteCode);
            sendMap.put("version", version);
            sendMap.put("deviceType", deviceType);
            sendMap.put("transacCode", transacCode);
            sendMap.put("charset", charset);
            sendMap.put("reqdata", reqdata);
            sendMap.put("signature", signature);

            // 查询请求地址
            String queryUrl = wxConfig.getString("queryUrl");
            log.debug("光大云缴费查询地址: {},查询参数: {}", queryUrl, new JSONObject(sendMap));

            //发送请求
            String rs = HttpSendUtil.sendToOtherServer2(queryUrl, sendMap);
            log.debug("光大云缴费查询返回数据: {}", rs);

            JSONObject json1 = new JSONObject(rs);
            if ("200".equals(String.valueOf(json1.get("respCode")))){
                byte[] decodeBase64 = Base64.decodeBase64(String.valueOf(json1.get("respData")));
                String respData_json = new String(decodeBase64);
                log.debug("respData_json====>" + respData_json);
                JSONObject resp_json  = new JSONObject(respData_json);
                // 订单状态,1---成功； 2--失败； 3--处理中
                if ("1".equals(resp_json.get("payStatus"))) {
                    // 交易金额
                    String payAmount = String.valueOf(resp_json.get("payAmount"));
                    result.put("result_code", "SUCCESS");
                    result.put("trade_state", "SUCCESS");
                    // 订单号
                    result.put("transaction_id", resp_json.getString("orderNo"));

                    Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(jsonObject.getString("f_create_time"));
                    String s = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
                    // 交易日期
                    result.put("time_end", s);


                    String money = String.valueOf(PayUtil.yuan2FenInt(payAmount));
                    result.put("total_fee", money);
                } else {
                    result.put("result_code", "FAIL");
                    result.put("return_msg", resp_json.getString("payStatus"));
                    log.debug("订单状态不等于已支付：" + resp_json.getString("payStatusText"));
                }
            } else {
                log.debug("查询申请失败：" + json1.get("respMsg"));
                result.put("code", json1.get("respCode"));
                result.put("msg", "光大云缴费查询失败：" + json1.get("respMsg"));
            }
        } catch (Exception e) {
            log.error("操作失败：原因" + e.getMessage());
            result.put("error", "系统异常");
        }
        return result.toString();
    }


}
