package com.aote.pay.ccb_gongyi.qianneng;

import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.ccb_gongyi.MD5;
import com.aote.util.PayUtil;
import com.aote.util.WxSign;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;

@Slf4j
@Component
public class JsApiQianNeng implements PaySuper {

    @Autowired
    private LogicServer logicServer;
    

    /**
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        String userinfoCode = json.getString("userinfoCode");
        HttpServletRequest request = (HttpServletRequest) json.get("request");
        String orderType = json.optString("orderType","燃气收费");
        if (filiale == null || filiale.length() == 0) {
            throw new RuntimeException("公司信息不能为空！");
        }
        String result = "";
        JSONObject wxConfig = Config.getConfig(filiale);

        try {
            // 用户唯一编号
            String userNo = userinfoCode;
            // 商户订单流水号（必须确保唯一性）
            String orderId = WxSign.getNonceStr();
            // 缴费方式1：PC，2：手机
            String payType = "2";
            // 项目唯一标识
            String projectId = wxConfig.getString("projectId");
            // 当前操作时间yyyyMMdd
            String date = new SimpleDateFormat("yyyyMMdd").format(new Date());

            JSONObject params = new JSONObject();
            params.put("userNo", userNo);
            params.put("orderId", orderId);
            params.put("payType", payType);
            params.put("deuPayAmt", money);
            params.put("projectId", projectId);
            params.put("date", date);

            String payUrl = wxConfig.getString("payUrl");

            log.debug("下单地址: {},下单参数: {}", payUrl, params);


            String key = wxConfig.getString("encryptKey");
            String data = DesCbcSecurity.encrypt(key, params.toString());
            log.debug("加密后的参数: " + data);
            log.debug("加密后的参数: " + MD5.md5Str(data));
            // 发送下单请求
            String response = HttpUtil.doJsonPost(payUrl, data);
            log.debug("response: " + response);
            String resData = DesCbcSecurity.decrypt(key, response);
            log.debug("解密后的返回报文: " + resData);
            JSONObject redJson = new JSONObject(resData);
            if ("0000".equals(redJson.get("returnCode"))) {
                result = redJson.getString("payUrl");
                JSONObject saveOrder = new JSONObject();
                JSONObject param = new JSONObject(attach);
                String userFilesId = param.optString("f_userfiles_id", "");
                saveOrder.put("f_out_trade_no", orderId);
                saveOrder.put("f_attach", attach);
                saveOrder.put("f_openid", openid);
                saveOrder.put("f_order_state", "已下单");
                saveOrder.put("f_order_type", orderType);
                saveOrder.put("flag", "JsApiQianNeng");
                saveOrder.put("f_trade_type", "JSAPI");
                saveOrder.put("f_filiale", filiale);
                saveOrder.put("f_total_fee", String.valueOf(PayUtil.yuan2FenInt(money)));
                saveOrder.put("f_userfiles_id", userFilesId);
                // 保存分公司id
                JSONObject clientConfig = Config.getClientConfig(filiale);
                saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                logicServer.run("savewxreturnxml", saveOrder);
            } else {
                log.debug("错误码为: " + redJson.get("returnCode"));
                throw new RuntimeException(redJson.getString("returnMess"));
            }
        } catch (Exception e) {
            log.debug("下单异常错误", e);
        }
        return result;
    }


    /**
     * 轮询查询
     *
     * @param value
     * @return 订单支付结果
     */
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            // 商户订单流水号（必须确保唯一性）
            String orderId = jsonObject.getString("out_trade_no");
            // 项目唯一标识
            String projectId = wxConfig.getString("projectId");
            // 交易状态（1：已缴费，2：已退款，4：已扣款）
            String stat = "4";

            // String create_time = jsonObject.getString("f_create_time");
            // Date sDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(create_time);
            // 查询支付开始时间（YYYY-MM-DD）
            // String startDate = new SimpleDateFormat("yyyy-MM-dd").format(sDate);
            // 查询支付结束时间（YYYY-MM-DD）
            // 获取当前月的最后一天
            // LocalDate date = LocalDate.now();
            // String endDate = String.valueOf(date.with(TemporalAdjusters.lastDayOfMonth()));

            JSONObject params = new JSONObject();
            params.put("orderId", orderId);
            params.put("projectId", projectId);
            params.put("stat", stat);
            // params.put("startDate", startDate);
            // params.put("endDate", endDate);

            String queryUrl = wxConfig.getString("queryUrl");

            log.debug("查询地址: {},查询参数: {}", queryUrl, params);


            String key = wxConfig.getString("encryptKey");
            String data = DesCbcSecurity.encrypt(key, params.toString());
            log.debug("加密后的参数: " + data);
            log.debug("加密后的参数: " + MD5.md5Str(data));
            // 发送下单请求
            String response = HttpUtil.doJsonPost(queryUrl, data);
            log.debug("response: " + response);
            String resData = DesCbcSecurity.decrypt(key, response);
            log.debug("解密后的返回报文: " + resData);
            JSONObject redJson = new JSONObject(resData);
            if ("0000".equals(redJson.get("returnCode"))) {
                JSONArray arrJson = (JSONArray) redJson.get("orderList");
                // 交易结果（已缴费/已退款）
                String payStat = arrJson.getJSONObject(0).getString("stat");

                if ("已缴费".equals(payStat) || "已扣款".equals(payStat)) {
                    result.put("result_code", "SUCCESS");
                    result.put("trade_state", "SUCCESS");
                    // 订单号
                    result.put("transaction_id", arrJson.getJSONObject(0).getString("bankId"));

                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String time = "";
                    try {
                        Date parse = sdf.parse(arrJson.getJSONObject(0).getString("payTime"));
                        SimpleDateFormat sdft = new SimpleDateFormat("yyyyMMddHHmmss");
                        time = sdft.format(parse);
                    } catch (Exception e) {
                        log.debug("时间格式转换错误：" + e.getMessage());
                        e.printStackTrace();
                    }
                    // 交易日期
                    result.put("time_end", time);
                    // 交易金额
                    String TAmt = String.valueOf(arrJson.getJSONObject(0).get("payAmt"));
                    String money = String.valueOf(PayUtil.yuan2FenInt(TAmt));
                    result.put("total_fee", money);
                }
            } else {
                log.debug("错误码为: " + redJson.get("returnCode"));
                throw new RuntimeException(redJson.getString("returnMess"));
            }
        } catch (Exception e) {
            result.put("trade_state", "FAIL");
            log.debug("查询订单异常：" + e);
        }
        return result.toString();
    }


}
