package com.aote.pay.ccb_gongyi.qianneng;

import com.aote.pay.ccb_gongyi.MD5;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpUtil {

    /**
     * post请求
     */
    public static String doJsonPost(String urlPath, String str) {
        String result = "";
        BufferedReader reader = null;
        OutputStream outwritestream = null;
        try {
            URL url = new URL(urlPath);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setConnectTimeout(30 * 1000);
            conn.setReadTimeout(30 * 1000);
            conn.setRequestProperty("Connection", "Keep-Alive");
            // 设置文件类型:
            conn.setRequestProperty("Content-Type","application/json;charset=UTF-8");
            // 设置接收类型
            conn.setRequestProperty("accept","*/*");
            conn.setRequestProperty("AUTH", MD5.md5Str(str).toUpperCase());
            // 往服务器里面发送数据
            if (str != null) {
                byte[] writebytes = str.getBytes();
                // 设置文件长度
                conn.setRequestProperty("Content-Length", String.valueOf(writebytes.length));
                outwritestream = conn.getOutputStream();
                outwritestream.write(str.getBytes());
                outwritestream.flush();
            }
            System.out.println("http返回码:"+conn.getResponseCode());

            if (conn.getResponseCode() == 200) {
                reader = new BufferedReader(
                        new InputStreamReader(conn.getInputStream()));
                result = reader.readLine();
            } else {
                reader = new BufferedReader(
                        new InputStreamReader(conn.getErrorStream()));
                result = reader.readLine();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try{
                if (outwritestream != null) {
                    outwritestream.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }catch(IOException e){
                e.printStackTrace();
            }
        }
        return result;
    }
}
