package com.aote.pay.ccb_gongyi;

import cn.hutool.http.HttpUtil;
import com.af.plugins.DateTools;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.ccb_gongyi.utils.SM4Tool;
import com.aote.util.PayUtil;
import com.aote.util.WxSign;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.aote.pay.ccb_gongyi.utils.MD5;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static java.util.regex.Pattern.compile;

/**
 * @description:
 * @author: 唐梓烨
 * @time: 2023/4/24 14:51
 */
@Slf4j
@Component
public class JsApiLife implements PaySuper {
    @Autowired
    private LogicServer logicServer;
    

    public static void main(String[] args) throws Exception {
//        JSONObject dataParam = new JSONObject();
//        String transID = PayUtil.liftOutTradeNo("01046");
//        //String transID = "014132023060914425619301";
//        dataParam.put("transID",transID);
//        dataParam.put("txCode","LCS00002");
//        dataParam.put("thirdSysID","01046");
//        String data = SM4Tool.encryptEcb("0771598453B91AC47A93D94E5359CE30",dataParam.toString());
//        String md5str = "01046"+"LCS00002"+data+"583WT0q2U5G2580"+transID;
//        System.out.println(md5str);
//        String auth = MD5.getMD5(md5str,"UTF-8");
//
//        System.out.println(dataParam.toString());
//        System.out.println(data);
//        System.out.println(auth);
//        System.out.println(transID);
//        String data = SM4Tool.decryptEcb("FE48250BDABD43017E6FF156BC97E9DE","c32dea9bb35c3649a11a3bccdae297cc6928719164b859f2ad6109029185412bc9411511eafc83d9b88a4f747d6c6da676f31d5080ae26bd79508322ecced27b41e06f9a97a7d826ab6e1a2081c440d0eabd35a3a0a8223ecd301ebc39f87181e870202a69b3696a3eaf2777fddd9da2d4ef5786afd3f0340a44a3354e0ddcc2b7e9ea9ff9b7e380ed7327a5138332bb");
//        System.out.println(data);
//         String data = SM4Tool.decryptEcb("0D9368DA3923A5217F13E726BD1567E2","968c2011784a93afb4f2e1c20cc1122631a8fe4f9b7a0028b6c07f470b9f4e027abedfc6a994d581c9f1f4c3a03fc25402040b006c0802891bc3fa62d5eda2228c747f5e143e2a0b6cfaadaeb87724d541ab5f22516ed4a22ee71c48fcdefa56ad57993c1692abd277ac842a2a5a0de35e8efad7699e4fc722c1d297f607710a0a73dfebff32739ece644801fd4adb8b");
//        System.out.println(data);
//         String data = SM4Tool.decryptEcb("0771598453B91AC47A93D94E5359CE30","856d4d749f35bc0d88ac8e60e95c1e9437ca7215d616b43b2505b51d3c527d2ef743827f669c0f91e9d400143b021439b51294eeb54829c3373dc8365373c91f08a930539e3f71fde8bcad7e3df2322763b4a93f62047450045233262b9e189bca09585504ac30aea2c53e25fb45f8e26cc5504e164ac137cf7f4f8a64e1f5b3c39969bbcce5dff030f3c4a3e5a8a102");
//        System.out.println(data);
    }
    @Override
    public String prePay(JSONObject json) {
        String result = "";
        try {
            String money = String.valueOf(json.get("money"));
            String openid = json.getString("openid");
            String attach = String.valueOf(json.get("attach"));
            String filiale = json.getString("filiale");
            String otherType = json.optString("othertype","");

            if (filiale == null || filiale.length() == 0) {
                throw new RuntimeException("公司信息不能为空！");
            }
            // 金额正则,可以没有小数,小数最多不超过两位
            Pattern pattern = compile("\\d+(\\.\\d{1,2})?");
            Matcher matcher = pattern.matcher(money);
            if (!matcher.matches()) {
                throw new RuntimeException("金额格式不正确，无法进行交易");
            } else if (Double.parseDouble(money) <= 0) {
                throw new RuntimeException("支付金额必须大于0");
            }
            JSONObject wxConfig = Config.getConfig(filiale);

            if (otherType == null || otherType.length() == 0) {
                otherType = "水费";
            }
            // 第三方应用id
            String thirdSysID = wxConfig.getString("thirdSysID");
            String MD5Key = wxConfig.getString("MD5Key");
            // 交易码
            /**
             * A.非缴费接口地址(第四章中的所有接口)
             * http://124.127.94.57:8006/Adapter/lcs/{txCode}
             * B.缴费接口地址(第五章中的所有接口)
             * http://124.127.94.57:8003/order/orderPay_{XXX}.jhtml
             */
            // 安全策略代码安全策略代码:由六位二进制数字组成。
            String secID = "000021";
            //统一使用thirdSysID+yyyymmddhhmiss+5位顺序号，由发送方生成。一个流水号只能使用一次（含发送/返回两次跳转），重复请求无效。
            // 交易流水号//订单号该请求流水号不可重复,建意添加随机数排重,长度在30位内
            String transID = PayUtil.liftOutTradeNo(thirdSysID);
            /**
             * {
             *     "transID": "06202103100919446152",
             *     "billSet": [
             *         {
             *             "customDetail": [
             *                 {
             *                     "id": "0000009273",
             *                     "value": "0601000006"
             *                 },
             *                 {
             *                     "id": "0000009274",
             *                     "value": "0601000006"
             *                 },
             *                 {
             *                     "id": "0000009275",
             *                     "value": "测试账户"
             *                 },
             *                 {
             *                     "id": "0000009276",
             *                     "value": "06"
             *                 },
             *                 {
             *                     "id": "0000009277",
             *                     "value": "测试地址"
             *                 },
             *                 {
             *                     "id": "0000009278",
             *                     "value": "0"
             *                 },
             *                 {
             *                     "id": "0000009279",
             *                     "value": "0.00"
             *                 },
             *                 {
             *                     "id": "0000009280",
             *                     "value": "100"
             *                 }
             *             ],
             *             "pay_amt": "0.0",
             *             "project_id": "000012742",
             *             "bill_date": "2021-03-10 09:19:44",
             *             "billDetail": [
             *                 {
             *                     "pay_amt": "0.0",
             *                     "free_amt": "0.0",
             *                     "id": "0000011636",
             *                     "duepay_amt": "100.0"
             *                 }
             *             ],
             *             "free_amt": "0.0",
             *             "merchant_org_id": "0",
             *             "is_use": "01",
             *             "billId_thirdSys": "20210310091944184374ee",
             *             "duepay_amt": "100.0",
             *             "operator": "00695"
             *         }
             *     ],
             *     "txCode": "IPSPT10003"
             * }
             */
            // 商户订单流水号（必须确保唯一性）存在缴费单中
            String orderId = WxSign.getNonceStr();
            // 要发送的参数map
            JSONObject dataParam = new JSONObject();
            dataParam.put("transID",transID);
            dataParam.put("txCode","IPSPT10003");
            //attach字段
            JSONObject param = new JSONObject(attach);
            // 必输项,账单项
            JSONArray billSet = new JSONArray();
            JSONObject billParam = new JSONObject();
            JSONArray customDetails = new JSONArray();
            JSONObject USER_ID = new JSONObject();
            //PL2  0000014138
            //PL4  0000026558
            USER_ID.put("id","0000668535");
            USER_ID.put("value",param.optString("f_user_id", ""));
            customDetails.put(USER_ID);
            //JSONObject WATER_FEE = new JSONObject();
            //WATER_FEE.put("id","0000014240");
            //WATER_FEE.put("value",money);
            //customDetails.put(WATER_FEE);
            JSONObject USER_ID2 = new JSONObject();
            // pl2 0000014139
            // pl4 0000025770
            USER_ID2.put("id","0000668550");
            USER_ID2.put("value",param.optString("f_user_id", ""));
            customDetails.put(USER_ID2);
            JSONObject USER_NAME = new JSONObject();
            // pl2 0000014140
            // pl4 0000025771
            USER_NAME.put("id","0000668536");
            USER_NAME.put("value",param.optString("f_user_name", ""));
            customDetails.put(USER_NAME);
            JSONObject USER_ADDRESS = new JSONObject();
            // pl2 0000014141
            // pl4 0000025772
            USER_ADDRESS.put("id","0000668537");
            USER_ADDRESS.put("value",param.optString("f_address", ""));
            customDetails.put(USER_ADDRESS);
            JSONObject USER_BALANCE = new JSONObject();
            // pl2 0000014142
            // pl4 0000025773
            USER_BALANCE.put("id","0000668544");
            USER_BALANCE.put("value",param.optString("f_balance_amount", ""));
            customDetails.put(USER_BALANCE);
            JSONObject FILIALE = new JSONObject();
            // pl4 0000025774
            FILIALE.put("id","0000668555");
            FILIALE.put("value","贺兰县兴源供水服务有限公司");
            customDetails.put(FILIALE);
            JSONObject PAYMENT = new JSONObject();
            // pl4 0000025775
            PAYMENT.put("id","0000668631");
            PAYMENT.put("value",money);
            customDetails.put(PAYMENT);
            String billDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            JSONObject BelongDay = new JSONObject();
            // pl4 0000025775
            BelongDay.put("id","0000668545");
            BelongDay.put("value",billDate);
            customDetails.put(BelongDay);
            String duepayAmt = money;
            String projectId = wxConfig.getString("projectId");
            JSONArray billDetails = new JSONArray();
            JSONObject billDetail = new JSONObject();
            //实缴总金额  初识0
            billDetail.put("pay_amt","0");
            //优惠金额
            billDetail.put("free_amt","0");
            //缴费明细项id
            billDetail.put("id","0000367879");
            //应缴总金额
            billDetail.put("duepay_amt",duepayAmt);
            billDetails.put(billDetail);

            billParam.put("customDetail",customDetails);
            billParam.put("pay_amt","0");
            billParam.put("project_id",projectId);
            billParam.put("bill_date",billDate);
            billParam.put("billDetail",billDetails);
            billParam.put("free_amt","0");
            //收费单位机构ID
            billParam.put("merchant_org_id","0");
            billParam.put("is_use","01");
            //修改缴费单id
            billParam.put("billId_thirdSys",orderId);
            //应缴总金额
            billParam.put("duepay_amt",duepayAmt);
            billParam.put("operator","微信公众号");
            billSet.put(billParam);
            dataParam.put("billSet",billSet);
            //加密过的密文
            String key = wxConfig.getString("sm4Key");
            log.debug("缴费单加密参数明文: {}", billParam);
            log.debug("加密前参数明文: {}", dataParam);
            String data = SM4Tool.encryptEcb(key,dataParam.toString());
            String auth = MD5.getMD5(thirdSysID+"IPSPT10003"+data+MD5Key+transID,"UTF-8");
            JSONObject paramMap = new JSONObject();
            paramMap.put("thirdSysID",thirdSysID);
            paramMap.put("txCode","IPSPT10003");
            paramMap.put("data",data);
            paramMap.put("auth",auth);
            paramMap.put("secID",secID);
            paramMap.put("transID",transID);
            // 下单地址
            String uploadBillUrl = wxConfig.getString("uploadBillUrl");
            log.debug("建行悦生活导入缴费单地址: {},下单参数: {}", uploadBillUrl, paramMap.toString());
            // 发送下单请求
            String response = HttpUtil.post(uploadBillUrl, paramMap.toString());
            log.debug("response请求返回的报文: " + response);
            JSONObject responseData = new JSONObject(response);
            response = SM4Tool.decryptEcb(key,responseData.getString("data"));
            log.debug("建行悦生活下单返回数据解密后data: {}", response);
            JSONObject jo;
            try {
                jo = new JSONObject(response);
                JSONArray billIDMap = jo.getJSONArray("billIDMap");
                JSONObject bill = (JSONObject) billIDMap.get(0);
                //  不应该在这里取
//                String billId_thirdSys = bill.getString("billId_thirdSys");
                String billId = bill.getString("billId");
                billId = SM4Tool.encryptEcb(key,billId);
                jo.put("billId",billId);
                jo.put("billId_thirdSys",thirdSysID);
                jo.put("secID","000020");
//                orderId = billId_thirdSys;
            } catch (Exception e) {
                throw new RuntimeException("下单请求建行未正常响应");
            }
            if (!"1".equals(jo.getString("status"))) {
                throw new RuntimeException("缴费单导入失败,银行返回信息:" + response);
            }
            jo.remove("billIDMap");
            jo.put("payRedirectUrl",wxConfig.getString("payRedirectUrl"));
            // 信息正确直接返回给前台
            result = jo.toString();
            // 保存下单信息到中间表

            String userFilesId = param.optString("f_userfiles_id", "");
            JSONObject saveOrder = new JSONObject();
            //存缴费单id
            saveOrder.put("f_out_trade_no", orderId);
            saveOrder.put("f_attach", attach);
            saveOrder.put("f_openid", openid);
            saveOrder.put("f_order_state", "已下单");
            saveOrder.put("f_order_type",  otherType);
            saveOrder.put("flag", "JsApiLife");
            saveOrder.put("f_trade_type", "JSAPI");
            saveOrder.put("f_filiale", filiale);
            saveOrder.put("f_userfiles_id", userFilesId);
            saveOrder.put("f_total_fee", PayUtil.yuan2FenInt(money));
            // 保存分公司id
            JSONObject clientConfig = Config.getClientConfig(filiale);
            saveOrder.put("f_orgid", clientConfig.get("orgStr"));
            logicServer.run("savewxreturnxml", saveOrder);
        } catch (Exception e) {
            log.debug("建行悦生活导入缴费单异常错误", e);
            result = "";
        }
        log.debug("建行悦生活导入缴费单返回数据: {}", result);
        return result;
    }

    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            String MD5Key = wxConfig.getString("MD5Key");
            // 商户订单流水号（必须确保唯一性）
            String orderId = jsonObject.getString("out_trade_no");
            // 项目唯一标识
            String projectId = wxConfig.getString("projectId");

            /**
             * 先获取秘钥
             * sm4秘钥
             */
            String key = wxConfig.getString("sm4Key");
            //第三方行业id
            String thirdSysID = wxConfig.getString("thirdSysID");
            // 交易码  加密 sm4
            String secID = "000021";

            //统一使用thirdSysID+yyyymmddhhmiss+5位顺序号，由发送方生成。一个流水号只能使用一次（含发送/返回两次跳转），重复请求无效。
            // 交易流水号//订单号该请求流水号不可重复,建意添加随机数排重,长度在30位内
            String transID = PayUtil.liftOutTradeNo(thirdSysID);
            //组织查询数据对数据加密
            JSONObject params = new JSONObject();
            params.put("project_id", projectId);
            params.put("billId_thirdSys", orderId);
            params.put("txCode", "IPSPT10011");
            params.put("transID", transID);
            String data = SM4Tool.encryptEcb(key,params.toString());
            String auth = MD5.getMD5(thirdSysID+"IPSPT10011"+data+MD5Key+transID,"UTF-8");
            JSONObject paramMap = new JSONObject();
            paramMap.put("thirdSysID",thirdSysID);
            paramMap.put("txCode","IPSPT10011");
            paramMap.put("data",data);
            paramMap.put("auth",auth);
            paramMap.put("secID",secID);
            paramMap.put("transID",transID);
            //加密
            String queryUrl = wxConfig.getString("queryUrl");
            log.debug("查询地址: {},查询参数: {}", queryUrl, paramMap);
            // 发送下单请求
            String queryResponse = HttpUtil.post(queryUrl, paramMap.toString());
            log.debug("queryResponse: " + queryResponse);
            JSONObject queryResponseData = new JSONObject(queryResponse);
            queryResponse = SM4Tool.decryptEcb(key,queryResponseData.getString("data"));
            log.debug("解密后的返回报文data: " + queryResponse);
            JSONObject redJson = new JSONObject(queryResponse);
            if ("1".equals(redJson.get("status"))) {
                JSONArray arrJson = (JSONArray) redJson.get("paymentFlow");
                if (arrJson.length() > 0){
                    // 交易结果（已缴费/已退款）
                    String payStat = arrJson.getJSONObject(0).getString("status");

                    if ("01".equals(payStat)) {
                        result.put("result_code", "SUCCESS");
                        result.put("trade_state", "SUCCESS");
                        // 订单号
                        result.put("transaction_id", arrJson.getJSONObject(0).getString("paymentFlowNo"));

                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String time = "";
                        try {
                            Date parse = sdf.parse(arrJson.getJSONObject(0).getString("gatewayReturnTime"));
                            SimpleDateFormat sdft = new SimpleDateFormat("yyyyMMddHHmmss");
                            time = sdft.format(parse);
                        } catch (Exception e) {
                            log.debug("时间格式转换错误：" + e.getMessage());
                            e.printStackTrace();
                        }
                        // 交易日期
                        result.put("time_end", time);
                        // 交易金额
                        String TAmt = String.valueOf(arrJson.getJSONObject(0).get("txnamt"));
                        String money = String.valueOf(PayUtil.yuan2FenInt(TAmt));
                        result.put("total_fee", money);
                    }
                }
            } else {
                log.debug("错误码为: " + redJson.get("returnCode"));
                throw new RuntimeException(redJson.getString("returnMess"));
            }
        } catch (Exception e) {
            result.put("trade_state", "FAIL");
            log.debug("查询订单异常：" + e);
        }
        return result.toString();
    }
}
