package com.aote.pay.ccb_gongyi;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.http.HttpUtil;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.json.XML;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.*;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;

import static java.util.regex.Pattern.compile;

/**
 * @Author: JoeCdy
 * @Description: 巩义建行 公众号/小程序下单支付
 * @Date: Created in 0:16 2020/8/30
 */
@Slf4j
@Component
public class JsApiGongYi implements PaySuper {

    @Autowired
    private LogicServer logicServer;


    /**
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String result = "";
        try {
            String money = String.valueOf(json.get("money"));
            String openid = json.getString("openid");
            String attach = String.valueOf(json.get("attach"));
            String filiale = json.getString("filiale");
            String otherType = json.optString("othertype","");

            if (filiale == null || filiale.length() == 0) {
                throw new RuntimeException("公司信息不能为空！");
            }
            // 金额正则,可以没有小数,小数最多不超过两位
            Pattern pattern = compile("\\d+(\\.\\d{1,2})?");
            Matcher matcher = pattern.matcher(money);
            if (!matcher.matches()) {
                throw new RuntimeException("金额格式不正确，无法进行交易");
            } else if (Double.parseDouble(money) <= 0) {
                throw new RuntimeException("支付金额必须大于0");
            }
            JSONObject wxConfig = Config.getConfig(filiale);

            if (otherType == null || otherType.length() == 0) {
                otherType = "燃气收费";
            }
            // 商户代码
            String merchantid = wxConfig.getString("MERCHANTID");
            // 商户柜台代码
            String posid = wxConfig.getString("POSID");
            // 分行代码
            String branchid = wxConfig.getString("BRANCHID");
            // 订单号
            String orderid = PayUtil.getOrderNoByNumber();
            // 付款金额 元
            String payment = money;
            // 币种 01-人民币
            String curcode = "01";
            // 备注1
            String remark1 = "";
            // 备注2
            String remark2 = "";
            // 交易码 由建行统一分配为 530590
            String txcode = "530590";
            // 接口类型
            String type = "1";
            // 网关类型
            String gateway = "0";
            // 客户在商户系统中的IP, 即客户登陆（访问）商户系统时使用的ip）
            String clientip = "";
            // 客户在商户系统中注册的信息, 中文需使用escape编码
            String reginfo = "";
            // 客户购买的商品, 中文需使用escape编码
            String proinfo = "";
            // 商户送空值即可, 具体请看REFERER设置说明
            String referer = "";
            // 交易类型
            String trade_type = "JSAPI";
            // 小程序/公众号的APPID
            String sub_appid = wxConfig.getString("appId");
            // 用户的唯一标识openid
            String sub_openid = openid;
            // 商户公匙
            String pubkey = wxConfig.getString("PUBKEY");
            // PUB字段为对应柜台的公钥后30位
            String PUB = pubkey.substring(pubkey.length() - 30);
            // 验签字段
            LinkedHashMap<String, Object> linkMap = new LinkedHashMap<>();
            linkMap.put("MERCHANTID", merchantid);
            linkMap.put("POSID", posid);
            linkMap.put("BRANCHID", branchid);
            linkMap.put("ORDERID", orderid);
            linkMap.put("PAYMENT", payment);
            linkMap.put("CURCODE", curcode);
            linkMap.put("TXCODE", txcode);
            linkMap.put("REMARK1", remark1);
            linkMap.put("REMARK2", remark2);
            linkMap.put("TYPE", type);
            linkMap.put("PUB", PUB);
            linkMap.put("GATEWAY", gateway);
            linkMap.put("CLIENTIP", clientip);
            linkMap.put("REGINFO", reginfo);
            linkMap.put("PROINFO", proinfo);
            linkMap.put("REFERER", referer);
            linkMap.put("TRADE_TYPE", trade_type);
            linkMap.put("SUB_APPID", sub_appid);
            linkMap.put("SUB_OPENID", sub_openid);
            // MAC串
            StringBuilder macString = new StringBuilder();
            for (Map.Entry<String, Object> entry : linkMap.entrySet()) {
                macString.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            // 最终的MAC值
            String MAC = MD5.md5Str(macString.deleteCharAt(macString.length() - 1).toString());
            // 最终下单参数
            linkMap.put("MAC", MAC);
            // 要发送的参数map
            LinkedHashMap<String, Object> paramMap = new LinkedHashMap<>();
            // 必输项
            paramMap.put("CCB_IBSVersion", "V6");
            paramMap.putAll(linkMap);
            // 下单地址
            String downPayApi = wxConfig.getString("DOWN_PAY_API");
            log.debug("巩义建行下单地址: {},下单参数: {}", downPayApi, new JSONObject(paramMap));
            // 发送下单请求
            String response = HttpUtil.post(downPayApi, paramMap);
            log.debug("巩义建行下单返回数据: {}", response);
            JSONObject jo;
            try {
                jo = new JSONObject(response);
            } catch (Exception e) {
                throw new RuntimeException("下单请求建行未正常响应");
            }
            if (jo.isNull("SUCCESS") || !"true".equals(jo.getString("SUCCESS"))) {
                throw new RuntimeException("下单失败,银行返回信息:" + response);
            }
            // 下单成功后 发送get请求
            String payUrl = jo.getString("PAYURL");
            response = HttpUtil.get(payUrl);
            log.debug("巩义建行获取商户json串返回: {}", response);
            try {
                jo = new JSONObject(response);
            } catch (Exception e) {
                throw new RuntimeException("获取商户json串建行未正常响应");
            }
            if (jo.isNull("SUCCESS") || !"true".equals(jo.getString("SUCCESS")) || !"000000".equals(jo.opt("ERRCODE"))) {
                throw new RuntimeException("获取商户json串失败，银行返回信息:" + response);
            }
            // 信息正确直接返回给前台
            result = jo.toString();
            // 保存下单信息到中间表
            JSONObject param = new JSONObject(attach);
            String userFilesId = param.optString("f_userfiles_id", "");
            JSONObject saveOrder = new JSONObject();
            saveOrder.put("f_out_trade_no", orderid);
            saveOrder.put("f_attach", attach);
            saveOrder.put("f_openid", openid);
            saveOrder.put("f_order_state", "已下单");
            saveOrder.put("f_order_type",  otherType);
            saveOrder.put("flag", "JsApiGongYi");
            saveOrder.put("f_trade_type", "JSAPI");
            saveOrder.put("f_filiale", filiale);
            saveOrder.put("f_userfiles_id", userFilesId);
            saveOrder.put("f_total_fee", PayUtil.yuan2FenInt(money));
            // 保存分公司id
            JSONObject clientConfig = Config.getClientConfig(filiale);
            saveOrder.put("f_orgid", clientConfig.get("orgStr"));
            logicServer.run("savewxreturnxml", saveOrder);
        } catch (Exception e) {
            log.debug("巩义建行下单异常错误", e);
            result = "";
        }
        log.debug("巩义建行下单返回数据: {}", result);
        return result;
    }

    /**
     * 轮询查询
     *
     * @param value
     * @return 订单支付结果
     */
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            // 请求序列号
            String REQUEST_SN = getSerialNum();
            // 商户号
            String CUST_ID = wxConfig.getString("MERCHANTID");
            // 操作员号
            String USER_ID = wxConfig.getString("USER_ID");
            // 密码
            String PASSWORD = wxConfig.getString("PASSWORD");
            // 请求交易码
            String TX_CODE = "5W1002";
            // 语言
            String LANGUAGE = "CN";
            // 流水类型 0:未结流水,1:已结流水
            String KIND = "0";
            // 订单号
            String ORDER = jsonObject.getString("out_trade_no");
            // 文件类型 默认为“1”，1:不压缩,2.压缩成zip文件
            String DEXCEL = "1";
            // 排序 1:交易日期,2:订单号
            String NORDERBY = "1";
            // 当前页次
            int PAGE = 1;
            // 流水状态 0:交易失败,1:交易成功,2:待银行确认(针对未结流水查询);3:全部
            String STATUS = "3";
            // 组织通讯xml数据
            LinkedHashMap<String, Object> TX = new LinkedHashMap<>();
            LinkedHashMap<String, Object> TX_INFO = new LinkedHashMap<>();
            TX.put("REQUEST_SN", REQUEST_SN);
            TX.put("CUST_ID", CUST_ID);
            TX.put("USER_ID", USER_ID);
            TX.put("PASSWORD", PASSWORD);
            TX.put("TX_CODE", TX_CODE);
            TX.put("LANGUAGE", LANGUAGE);
            TX_INFO.put("KIND", KIND);
            TX_INFO.put("ORDER", ORDER);
            TX_INFO.put("DEXCEL", DEXCEL);
            TX_INFO.put("NORDERBY", NORDERBY);
            TX_INFO.put("PAGE", PAGE);
            TX_INFO.put("STATUS", STATUS);
            TX.put("TX_INFO", TX_INFO);
            // map转xml
            String xml = XmlUtil.mapToXmlStr(TX, "TX", null, "GB18030", false, false);
            xml = xml.replace("standalone=\"no\"", "standalone=\"yes\"");
            log.debug("查询报文: {}", xml);
            String response = "";
            if (wxConfig.has("QueryMode")) {
                if ("HTTP".equals(wxConfig.optString("QueryMode","SOCKET"))) {
                    response = sendHttpRequest(wxConfig.getString("socketUrl"), wxConfig.getInt("socketPort"), xml);
                } else {
                    response = sendSocketRequest(wxConfig.getString("socketUrl"), wxConfig.getInt("socketPort"), xml);
                }
            } else {
                response = sendSocketRequest(wxConfig.getString("socketUrl"), wxConfig.getInt("socketPort"), xml);
            }

            JSONObject json = XML.toJSONObject(response);
            log.debug("返回信息: {}", json.toString());
            JSONObject tx = json.getJSONObject("TX");
            if ("000000".equals(tx.getString("RETURN_CODE"))) {
                JSONObject list = tx.getJSONObject("TX_INFO").getJSONObject("LIST");
                // 订单状态 0:失败,1:成功,2:待银行确认,3:已部分退款,4:已全额退款,5:待银行确认
                int orderStatus = list.getInt("ORDER_STATUS");
                if (orderStatus == 1) {
                    result.put("result_code", "SUCCESS");
                    result.put("trade_state", "SUCCESS");
                    // 订单号
                    result.put("transaction_id", ORDER);
                    // 支付银行 BHK:建行;THK:他行;ZFB:支付宝;CFT:微信
                    String payMode = list.getString("PAY_MODE");
                    String payModeName = "";
                    switch (payMode) {
                        case "BHK":
                            payModeName = "建行";
                            break;
                        case "THK":
                            payModeName = "他行";
                            break;
                        case "ZFB":
                            payModeName = "支付宝";
                            break;
                        case "CFT":
                            payModeName = "微信";
                            break;
                        default:
                            payModeName = "未知";
                    }
                    result.put("bank_type", payModeName);
                    // 交易日期
                    result.put("time_end", DateUtil.format(DateUtil.parse(list.getString("TRAN_DATE")), DatePattern.PURE_DATETIME_PATTERN));
                    // 交易金额
                    result.put("total_fee", PayUtil.yuan2FenInt(String.valueOf(list.get("PAYMENT_MONEY"))));
                } else {
                    result.put("result_code", "FAIL");
                    result.put("result_msg", orderStatus);
                }
            } else {
                result.put("result_code", "FAIL");
                result.put("result_msg", json.getString("RETURN_MSG"));
            }
        } catch (Exception e) {
            log.debug("巩义查询订单异常", e);
            result.put("result_code", "FAIL");
            result.put("trade_state", "FAIL");
            result.put("result_msg", e.getMessage());
        }
        log.debug("查询订单返回: {}", result.toString());
        return result.toString();
    }

    /**
     * 生成交易序列号
     *
     * @return len=16
     */
    public static String getSerialNum() {
        String ret = String.valueOf(System.nanoTime());
        if (ret.length() == 14) {
            int num = (new Random()).nextInt(99);
            ret += String.format("%02d", num);
        }
        return ret;
    }
    // HTTP对接
    public static String sendHttpRequest(String ipAdress, int nPort,
                                         String sRequest) {
        String sResult = "";
        OutputStream out = null;
        BufferedReader in = null;
        try {
            String encoding = "GB18030"; // 如系统使用UTF-8编码，需将请求报文转码为GB18030

            String params = "requestXml=" + sRequest;  //注意：请求报文必须放在requestXml参数送

            String path = "http://" + ipAdress + ":" + nPort;
            URL url = new URL(path);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();

            conn.setConnectTimeout(30 * 1000); // 设置连接超时时间

            conn.setDoOutput(true); // 将 doOutput 标志设置为 true，指示应用程序要将数据写入 URL
            // 连接。
            conn.setDoInput(true); // //将 doInput 标志设置为 true，指示应用程序要从 URL
            // 连接读取数据。

            // 设置HTTP请求报文头
            conn.setRequestProperty("Content-Type",
                    "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length",
                    String.valueOf(params.length()));
            conn.setRequestProperty("Connection", "close");
            // 打印请求报文
            System.out.println("HTTP请求报文:");
            System.out.println("---------------");
            // 获取并打印请求方法
            System.out.println("Request Method: " + conn.getRequestMethod());
            // 获取并打印URL
            System.out.println("URL: " + conn.getURL());
            // 获取并打印请求头
            Map<String, List<String>> requestHeaders = conn.getRequestProperties();
            System.out.println("Request Headers:");
            for (Map.Entry<String, List<String>> entry : requestHeaders.entrySet()) {
                System.out.println("  " + entry.getKey() + ": " + entry.getValue());
            }
            System.out.println("Request Parameters: " + params);
            System.out.println("---------------");
            // 发送请求报文数据
            out = conn.getOutputStream();
            out.write(params.getBytes(encoding));
            out.flush();
            out.close();

            // 读取返回数据
            if (conn.getResponseCode() == 200) {
                in = new BufferedReader(new InputStreamReader(
                        conn.getInputStream(), encoding));
            } else {
                in = new BufferedReader(new InputStreamReader(
                        conn.getErrorStream(), encoding));
            }

            String sLine = null;
            StringBuffer sb = new StringBuffer();
            while ((sLine = in.readLine()) != null) {
                sb.append(sLine);
            }
            sResult = sb.toString();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.debug("http通讯返回: {}", sResult);
        return sResult;
    }

    /**
     * 外联平台socket通讯
     *
     * @param ip
     * @param port
     * @param info
     * @return
     * @throws IOException
     */
    public static String sendSocketRequest(String ip, int port, String info) throws IOException {
        Socket socket = null;
        BufferedReader br = null;
        InputStream is = null;
        PrintWriter pw = null;
        OutputStream os = null;
        StringBuilder result = new StringBuilder();
        try {
            //1.建立客户端socket连接，指定服务器位置及端口
            socket = new Socket(ip, port);
            //2.得到socket读写流
            os = socket.getOutputStream();
            pw = new PrintWriter(os);
            //输入流
            is = socket.getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
            //3.利用流按照一定的操作，对socket进行读写操作
            pw.write(info);
            pw.flush();
            socket.shutdownOutput();
            //接收服务器的相应
            String reply = null;
            while ((reply = br.readLine()) != null) {
                result.append(reply);
            }
        } catch (IOException e) {
            log.debug("和外联平台交互异常", e);
        } finally {
            //4.关闭资源
            if (br != null) {
                br.close();
            }
            if (is != null) {
                is.close();
            }
            if (pw != null) {
                pw.close();
            }
            if (os != null) {
                os.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
        log.debug("socket通讯返回: {}", result);
        return result.toString();
    }
}
