package com.aote.pay.boc.yongzhou;

import com.alibaba.fastjson.JSON;
import com.bocom.api.BizContent;
import com.bocom.api.BocomDownloadRequest;
import com.fasterxml.jackson.annotation.JsonProperty;

public class DownloadNewPosStmtRequestV1  extends BocomDownloadRequest<DownloadNewPosStmtResponseV1> {

    @Override
    public boolean isNeedEncrypt() {
        return false;
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public Class<DownloadNewPosStmtResponseV1> getResponseClass() {
        return DownloadNewPosStmtResponseV1.class;
    }

    @Override
    public Class<? extends BizContent> getBizContentClass() {
        return DownloadNewPosStmtRequestV1Biz.class;
    }

    public static class DownloadNewPosStmtRequestV1Biz implements BizContent {


        @JsonProperty("stmt_date")
        private String stmtDate;

        @JsonProperty("isv_no")
        private String isvNo;

        @JsonProperty("merch_code")
        private String merchCode;

        @JsonProperty("template_no")
        private String templateNo;

        public String getStmtDate() {
            return stmtDate;
        }

        public void setStmtDate(String stmtDate) {
            this.stmtDate = stmtDate;
        }

        public String getIsvNo() {
            return isvNo;
        }

        public void setIsvNo(String isvNo) {
            this.isvNo = isvNo;
        }

        public String getMerchCode() {
            return merchCode;
        }

        public void setMerchCode(String merchCode) {
            this.merchCode = merchCode;
        }

        public String getTemplateNo() {
            return templateNo;
        }

        public void setTemplateNo(String templateNo) {
            this.templateNo = templateNo;
        }

        @Override
        public String toString() {
            return JSON.toJSONString(this);
        }
    }
}
